/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.metadata.persist.node;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public final class ShardingSphereDataNode {
    private static final String ROOT_NODE = "statistics";
    private static final String DATABASES_NODE = "databases";
    private static final String SCHEMAS_NODE = "schemas";
    private static final String TABLES_NODE = "tables";
    private static final String JOB_NODE = "job";

    public static String getShardingSphereDataNodePath() {
        return String.join((CharSequence)"/", "", ROOT_NODE, DATABASES_NODE);
    }

    public static String getDatabaseNamePath(String databaseName) {
        return String.join((CharSequence)"/", ShardingSphereDataNode.getShardingSphereDataNodePath(), databaseName);
    }

    public static String getTablesPath(String databaseName, String schemaName) {
        return String.join((CharSequence)"/", ShardingSphereDataNode.getSchemaDataPath(databaseName, schemaName), TABLES_NODE);
    }

    public static String getSchemaDataPath(String databaseName, String schemaName) {
        return String.join((CharSequence)"/", ShardingSphereDataNode.getSchemasPath(databaseName), schemaName);
    }

    public static String getSchemasPath(String databaseName) {
        return String.join((CharSequence)"/", ShardingSphereDataNode.getDatabaseNamePath(databaseName), SCHEMAS_NODE);
    }

    public static String getTablePath(String databaseName, String schemaName, String table) {
        return String.join((CharSequence)"/", ShardingSphereDataNode.getTablesPath(databaseName, schemaName), table);
    }

    public static String getTableRowPath(String databaseName, String schemaName, String table, String uniqueKey) {
        return String.join((CharSequence)"/", ShardingSphereDataNode.getTablePath(databaseName, schemaName, table), uniqueKey);
    }

    public static Optional<String> getDatabaseName(String configNodeFullPath) {
        Pattern pattern = Pattern.compile(ShardingSphereDataNode.getShardingSphereDataNodePath() + "/([\\w\\-]+)$", 2);
        Matcher matcher = pattern.matcher(configNodeFullPath);
        return matcher.find() ? Optional.of(matcher.group(1)) : Optional.empty();
    }

    public static Optional<String> getSchemaName(String configNodeFullPath) {
        Pattern pattern = Pattern.compile(ShardingSphereDataNode.getShardingSphereDataNodePath() + "/([\\w\\-]+)/schemas/([\\w\\-]+)$", 2);
        Matcher matcher = pattern.matcher(configNodeFullPath);
        return matcher.find() ? Optional.of(matcher.group(2)) : Optional.empty();
    }

    public static Optional<String> getDatabaseNameByDatabasePath(String databasePath) {
        Pattern pattern = Pattern.compile(ShardingSphereDataNode.getShardingSphereDataNodePath() + "/([\\w\\-]+)?", 2);
        Matcher matcher = pattern.matcher(databasePath);
        return matcher.find() ? Optional.of(matcher.group(1)) : Optional.empty();
    }

    public static Optional<String> getSchemaNameBySchemaPath(String schemaPath) {
        Pattern pattern = Pattern.compile(ShardingSphereDataNode.getShardingSphereDataNodePath() + "/([\\w\\-]+)/schemas/([\\w\\-]+)?", 2);
        Matcher matcher = pattern.matcher(schemaPath);
        return matcher.find() ? Optional.of(matcher.group(2)) : Optional.empty();
    }

    public static Optional<String> getTableName(String tableMetaDataPath) {
        Pattern pattern = Pattern.compile(ShardingSphereDataNode.getShardingSphereDataNodePath() + "/([\\w\\-]+)/schemas/([\\w\\-]+)/tables/([\\w\\-]+)$", 2);
        Matcher matcher = pattern.matcher(tableMetaDataPath);
        return matcher.find() ? Optional.of(matcher.group(3)) : Optional.empty();
    }

    public static Optional<String> getTableNameByRowPath(String rowPath) {
        Pattern pattern = Pattern.compile(ShardingSphereDataNode.getShardingSphereDataNodePath() + "/([\\w\\-]+)/schemas/([\\w\\-]+)/tables/([\\w\\-]+)?", 2);
        Matcher matcher = pattern.matcher(rowPath);
        return matcher.find() ? Optional.of(matcher.group(3)) : Optional.empty();
    }

    public static Optional<String> getRowUniqueKey(String rowPath) {
        Pattern pattern = Pattern.compile(ShardingSphereDataNode.getShardingSphereDataNodePath() + "/([\\w\\-]+)/schemas/([\\w\\-]+)/tables/([\\w\\-]+)/(\\w+)$", 2);
        Matcher matcher = pattern.matcher(rowPath);
        return matcher.find() ? Optional.of(matcher.group(4)) : Optional.empty();
    }

    public static String getJobPath() {
        return String.join((CharSequence)"/", ROOT_NODE, JOB_NODE);
    }

    @Generated
    private ShardingSphereDataNode() {
    }
}

