/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.listener;

import java.util.Collection;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.util.eventbus.EventBusContext;
import org.apache.shardingsphere.metadata.persist.node.DatabaseMetaDataNode;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.event.builder.DispatchEventBuilder;
import org.apache.shardingsphere.mode.manager.cluster.listener.DatabaseMetaDataChangedListener;
import org.apache.shardingsphere.mode.manager.cluster.listener.GlobalMetaDataChangedListener;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.apache.shardingsphere.mode.repository.cluster.listener.DataChangedEventListener;

public final class DataChangedEventListenerRegistry {
    private final ClusterPersistRepository repository;
    private final EventBusContext eventBusContext;
    private final Collection<String> databaseNames;

    public DataChangedEventListenerRegistry(ContextManager contextManager, Collection<String> databaseNames) {
        this.repository = (ClusterPersistRepository)contextManager.getPersistServiceFacade().getRepository();
        this.eventBusContext = contextManager.getComputeNodeInstanceContext().getEventBusContext();
        this.databaseNames = databaseNames;
    }

    public void register() {
        this.databaseNames.forEach(this::registerDatabaseListeners);
        ShardingSphereServiceLoader.getServiceInstances(DispatchEventBuilder.class).forEach(this::registerGlobalListeners);
    }

    private void registerDatabaseListeners(String databaseName) {
        this.repository.watch(DatabaseMetaDataNode.getDatabaseNamePath((String)databaseName), (DataChangedEventListener)new DatabaseMetaDataChangedListener(this.eventBusContext));
    }

    private void registerGlobalListeners(DispatchEventBuilder<?> builder) {
        this.repository.watch(builder.getSubscribedKey(), (DataChangedEventListener)new GlobalMetaDataChangedListener(this.eventBusContext, builder));
    }
}

