/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.schema.manager;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereView;

public final class GenericSchemaManager {
    public static Map<String, ShardingSphereSchema> getToBeAddedTablesBySchemas(Map<String, ShardingSphereSchema> reloadSchemas, Map<String, ShardingSphereSchema> currentSchemas) {
        LinkedHashMap<String, ShardingSphereSchema> result = new LinkedHashMap<String, ShardingSphereSchema>(currentSchemas.size(), 1.0f);
        reloadSchemas.entrySet().stream().filter(entry -> !currentSchemas.containsKey(entry.getKey())).forEach(entry -> result.put((String)entry.getKey(), (ShardingSphereSchema)entry.getValue()));
        reloadSchemas.entrySet().stream().filter(entry -> currentSchemas.containsKey(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)).forEach((key, value) -> result.put((String)key, GenericSchemaManager.getToBeAddedTablesBySchema(value, (ShardingSphereSchema)currentSchemas.get(key))));
        return result;
    }

    private static ShardingSphereSchema getToBeAddedTablesBySchema(ShardingSphereSchema reloadSchema, ShardingSphereSchema currentSchema) {
        return new ShardingSphereSchema(currentSchema.getName(), GenericSchemaManager.getToBeAddedTables(reloadSchema.getTables(), currentSchema.getTables()), new LinkedHashMap<String, ShardingSphereView>());
    }

    public static Map<String, ShardingSphereTable> getToBeAddedTables(Map<String, ShardingSphereTable> reloadTables, Map<String, ShardingSphereTable> currentTables) {
        return reloadTables.entrySet().stream().filter(entry -> !((ShardingSphereTable)entry.getValue()).equals(currentTables.get(entry.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static Map<String, ShardingSphereSchema> getToBeDroppedTablesBySchemas(Map<String, ShardingSphereSchema> reloadSchemas, Map<String, ShardingSphereSchema> currentSchemas) {
        LinkedHashMap<String, ShardingSphereSchema> result = new LinkedHashMap<String, ShardingSphereSchema>(currentSchemas.size(), 1.0f);
        currentSchemas.entrySet().stream().filter(entry -> reloadSchemas.containsKey(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)).forEach((key, value) -> result.put((String)key, GenericSchemaManager.getToBeDroppedTablesBySchema((ShardingSphereSchema)reloadSchemas.get(key), value)));
        return result;
    }

    private static ShardingSphereSchema getToBeDroppedTablesBySchema(ShardingSphereSchema reloadSchema, ShardingSphereSchema currentSchema) {
        return new ShardingSphereSchema(currentSchema.getName(), GenericSchemaManager.getToBeDroppedTables(reloadSchema.getTables(), currentSchema.getTables()), new LinkedHashMap<String, ShardingSphereView>());
    }

    public static Map<String, ShardingSphereTable> getToBeDroppedTables(Map<String, ShardingSphereTable> reloadTables, Map<String, ShardingSphereTable> currentTables) {
        return currentTables.entrySet().stream().filter(entry -> !reloadTables.containsKey(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static Map<String, ShardingSphereSchema> getToBeDroppedSchemas(Map<String, ShardingSphereSchema> reloadSchemas, Map<String, ShardingSphereSchema> currentSchemas) {
        return currentSchemas.entrySet().stream().filter(entry -> !reloadSchemas.containsKey(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Generated
    private GenericSchemaManager() {
    }
}

