/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.exception.core.external.sql.type.feature;

import com.google.common.base.Preconditions;
import org.apache.shardingsphere.infra.exception.core.external.sql.ShardingSphereSQLException;
import org.apache.shardingsphere.infra.exception.core.external.sql.sqlstate.SQLState;

public abstract class FeatureSQLException
extends ShardingSphereSQLException {
    private static final long serialVersionUID = -3748977692432149265L;
    private static final int TYPE_OFFSET = 2;

    protected FeatureSQLException(SQLState sqlState, int featureCode, int errorCode, String reason, Object ... messageArgs) {
        super(sqlState, 2, FeatureSQLException.getErrorCode(featureCode, errorCode), reason, messageArgs);
    }

    protected FeatureSQLException(SQLState sqlState, int featureCode, int errorCode, Exception cause, String reason, Object ... messageArgs) {
        super(sqlState, 2, FeatureSQLException.getErrorCode(featureCode, errorCode), cause, reason, messageArgs);
    }

    private static int getErrorCode(int featureCode, int errorCode) {
        Preconditions.checkArgument((featureCode >= 0 && featureCode < 100 ? 1 : 0) != 0, (Object)"The value range of feature code should be [0, 100).");
        Preconditions.checkArgument((errorCode >= 0 && errorCode < 100 ? 1 : 0) != 0, (Object)"The value range of error code should be [0, 100).");
        return featureCode * 100 + errorCode;
    }
}

