/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.pojo;

import java.util.Collection;
import java.util.LinkedList;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptAssignmentToken;

public final class EncryptLiteralAssignmentToken
extends EncryptAssignmentToken {
    private final Collection<LiteralAssignment> assignments = new LinkedList<LiteralAssignment>();

    public EncryptLiteralAssignmentToken(int startIndex, int stopIndex) {
        super(startIndex, stopIndex);
    }

    public void addAssignment(String columnName, Object value) {
        this.assignments.add(new LiteralAssignment(columnName, value));
    }

    public String toString() {
        return this.assignments.stream().map(LiteralAssignment::toString).collect(Collectors.joining(", "));
    }

    private static final class LiteralAssignment {
        private final String columnName;
        private final Object value;

        public String toString() {
            return this.columnName + " = " + this.toString(this.value);
        }

        private String toString(Object value) {
            if (null == value) {
                return "NULL";
            }
            return value instanceof String ? "'" + value + "'" : value.toString();
        }

        @Generated
        public LiteralAssignment(String columnName, Object value) {
            this.columnName = columnName;
            this.value = value;
        }
    }
}

