/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator.select;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.aware.DatabaseTypeAware;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.column.EncryptColumn;
import org.apache.shardingsphere.encrypt.rule.table.EncryptTable;
import org.apache.shardingsphere.infra.binder.context.segment.select.orderby.OrderByItem;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.database.core.metadata.database.enums.QuoteCharacter;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.aware.SchemaMetaDataAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.generic.SubstitutableColumnNameToken;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.ColumnOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class EncryptGroupByItemTokenGenerator
implements CollectionSQLTokenGenerator<SelectStatementContext>,
SchemaMetaDataAware,
DatabaseTypeAware {
    private final EncryptRule encryptRule;
    private Map<String, ShardingSphereSchema> schemas;
    private ShardingSphereSchema defaultSchema;
    private DatabaseType databaseType;

    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof SelectStatementContext && this.containsGroupByItem((SelectStatementContext)sqlStatementContext);
    }

    private boolean containsGroupByItem(SelectStatementContext sqlStatementContext) {
        if (!sqlStatementContext.getGroupByContext().getItems().isEmpty()) {
            return true;
        }
        for (SelectStatementContext each : sqlStatementContext.getSubqueryContexts().values()) {
            if (!this.containsGroupByItem(each)) continue;
            return true;
        }
        return false;
    }

    public Collection<SQLToken> generateSQLTokens(SelectStatementContext sqlStatementContext) {
        LinkedHashSet<SQLToken> result = new LinkedHashSet<SQLToken>();
        ShardingSphereSchema schema = sqlStatementContext.getTablesContext().getSchemaName().map(this.schemas::get).orElseGet(() -> this.defaultSchema);
        for (OrderByItem each : this.getGroupByItems(sqlStatementContext)) {
            if (!(each.getSegment() instanceof ColumnOrderByItemSegment)) continue;
            ColumnSegment columnSegment = ((ColumnOrderByItemSegment)each.getSegment()).getColumn();
            Map columnTableNames = sqlStatementContext.getTablesContext().findTableNames(Collections.singleton(columnSegment), schema);
            this.generateSQLToken(columnSegment, columnTableNames).ifPresent(result::add);
        }
        return result;
    }

    private Optional<SubstitutableColumnNameToken> generateSQLToken(ColumnSegment columnSegment, Map<String, String> columnTableNames) {
        String tableName = columnTableNames.getOrDefault(columnSegment.getExpression(), "");
        Optional<EncryptTable> encryptTable = this.encryptRule.findEncryptTable(tableName);
        String columnName = columnSegment.getIdentifier().getValue();
        if (!encryptTable.isPresent() || !encryptTable.get().isEncryptColumn(columnName)) {
            return Optional.empty();
        }
        EncryptColumn encryptColumn = encryptTable.get().getEncryptColumn(columnName);
        int startIndex = columnSegment.getOwner().isPresent() ? ((OwnerSegment)columnSegment.getOwner().get()).getStopIndex() + 2 : columnSegment.getStartIndex();
        int stopIndex = columnSegment.getStopIndex();
        return Optional.of(encryptColumn.getAssistedQuery().map(optional -> new SubstitutableColumnNameToken(startIndex, stopIndex, this.createColumnProjections(optional.getName(), columnSegment.getIdentifier().getQuoteCharacter()), this.databaseType)).orElseGet(() -> new SubstitutableColumnNameToken(startIndex, stopIndex, this.createColumnProjections(encryptColumn.getCipher().getName(), columnSegment.getIdentifier().getQuoteCharacter()), this.databaseType)));
    }

    private Collection<OrderByItem> getGroupByItems(SelectStatementContext sqlStatementContext) {
        LinkedList<OrderByItem> result = new LinkedList<OrderByItem>(sqlStatementContext.getGroupByContext().getItems());
        for (SelectStatementContext each : sqlStatementContext.getSubqueryContexts().values()) {
            result.addAll(this.getGroupByItems(each));
        }
        return result;
    }

    private Collection<Projection> createColumnProjections(String columnName, QuoteCharacter quoteCharacter) {
        return Collections.singleton(new ColumnProjection(null, new IdentifierValue(columnName, quoteCharacter), null, this.databaseType));
    }

    @Generated
    public EncryptGroupByItemTokenGenerator(EncryptRule encryptRule) {
        this.encryptRule = encryptRule;
    }

    @Generated
    public void setSchemas(Map<String, ShardingSphereSchema> schemas) {
        this.schemas = schemas;
    }

    @Generated
    public void setDefaultSchema(ShardingSphereSchema defaultSchema) {
        this.defaultSchema = defaultSchema;
    }

    @Override
    @Generated
    public void setDatabaseType(DatabaseType databaseType) {
        this.databaseType = databaseType;
    }
}

