/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.checker.sql.projection;

import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithm;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.combine.CombineSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ShorthandProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.bound.ColumnSegmentBoundInfo;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class EncryptProjectionRewriteSupportedChecker {
    public static void checkNotContainEncryptProjectionInCombineSegment(EncryptRule encryptRule, SelectStatementContext selectStatementContext) {
        ShardingSpherePreconditions.checkState((!EncryptProjectionRewriteSupportedChecker.containsEncryptProjectionInCombineSegment(encryptRule, selectStatementContext) ? 1 : 0) != 0, () -> new UnsupportedSQLOperationException("Can not support encrypt projection in combine statement."));
    }

    private static boolean containsEncryptProjectionInCombineSegment(EncryptRule encryptRule, SelectStatementContext selectStatementContext) {
        if (!selectStatementContext.getSqlStatement().getCombine().isPresent()) {
            return false;
        }
        CombineSegment combineSegment = (CombineSegment)selectStatementContext.getSqlStatement().getCombine().get();
        List leftProjections = ((SelectStatementContext)selectStatementContext.getSubqueryContexts().get(combineSegment.getLeft().getStartIndex())).getProjectionsContext().getExpandProjections();
        List rightProjections = ((SelectStatementContext)selectStatementContext.getSubqueryContexts().get(combineSegment.getRight().getStartIndex())).getProjectionsContext().getExpandProjections();
        ShardingSpherePreconditions.checkState((leftProjections.size() == rightProjections.size() ? 1 : 0) != 0, () -> new UnsupportedSQLOperationException("Column projections must be same for combine statement"));
        for (int i = 0; i < leftProjections.size(); ++i) {
            if (!EncryptProjectionRewriteSupportedChecker.containsEncryptProjectionInCombineSegment(encryptRule, (Projection)leftProjections.get(i), (Projection)rightProjections.get(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean containsEncryptProjectionInCombineSegment(EncryptRule encryptRule, Projection leftProjection, Projection rightProjection) {
        ColumnSegmentBoundInfo leftColumnInfo = EncryptProjectionRewriteSupportedChecker.getColumnSegmentBoundInfo(leftProjection);
        EncryptAlgorithm leftColumnEncryptor = encryptRule.findQueryEncryptor(leftColumnInfo.getOriginalTable().getValue(), leftColumnInfo.getOriginalColumn().getValue()).orElse(null);
        ColumnSegmentBoundInfo rightColumnInfo = EncryptProjectionRewriteSupportedChecker.getColumnSegmentBoundInfo(rightProjection);
        EncryptAlgorithm rightColumnEncryptor = encryptRule.findQueryEncryptor(rightColumnInfo.getOriginalTable().getValue(), rightColumnInfo.getOriginalColumn().getValue()).orElse(null);
        return null != leftColumnEncryptor || null != rightColumnEncryptor;
    }

    private static ColumnSegmentBoundInfo getColumnSegmentBoundInfo(Projection projection) {
        return projection instanceof ColumnProjection ? new ColumnSegmentBoundInfo(null, null, ((ColumnProjection)projection).getOriginalTable(), ((ColumnProjection)projection).getOriginalColumn()) : new ColumnSegmentBoundInfo(new IdentifierValue(projection.getColumnLabel()));
    }

    public static void checkNotContainEncryptShorthandExpandWithSubqueryStatement(SelectStatementContext selectStatementContext, ProjectionSegment projectionSegment) {
        ShardingSpherePreconditions.checkState((!(projectionSegment instanceof ShorthandProjectionSegment) || !selectStatementContext.containsTableSubquery() ? 1 : 0) != 0, () -> new UnsupportedSQLOperationException("Can not support encrypt shorthand expand with subquery statement."));
    }

    @Generated
    private EncryptProjectionRewriteSupportedChecker() {
    }
}

