/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.checker.sql.projection;

import org.apache.shardingsphere.encrypt.checker.sql.projection.EncryptProjectionRewriteSupportedChecker;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.checker.SupportedSQLChecker;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionSegment;

public final class EncryptInsertSelectProjectionSupportedChecker
implements SupportedSQLChecker<InsertStatementContext, EncryptRule> {
    public boolean isCheck(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof InsertStatementContext && null != ((InsertStatementContext)sqlStatementContext).getInsertSelectContext();
    }

    public void check(EncryptRule encryptRule, ShardingSphereSchema schema, InsertStatementContext sqlStatementContext) {
        this.checkSelect(encryptRule, sqlStatementContext.getInsertSelectContext().getSelectStatementContext());
        for (SelectStatementContext each : sqlStatementContext.getInsertSelectContext().getSelectStatementContext().getSubqueryContexts().values()) {
            this.checkSelect(encryptRule, each);
        }
    }

    private void checkSelect(EncryptRule encryptRule, SelectStatementContext selectStatementContext) {
        EncryptProjectionRewriteSupportedChecker.checkNotContainEncryptProjectionInCombineSegment(encryptRule, selectStatementContext);
        for (ProjectionSegment each : selectStatementContext.getSqlStatement().getProjections().getProjections()) {
            EncryptProjectionRewriteSupportedChecker.checkNotContainEncryptShorthandExpandWithSubqueryStatement(selectStatementContext, each);
        }
    }
}

