/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.broadcast.rule;

import com.cedarsoftware.util.CaseInsensitiveSet;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.broadcast.config.BroadcastRuleConfiguration;
import org.apache.shardingsphere.broadcast.rule.attribute.BroadcastDataNodeRuleAttribute;
import org.apache.shardingsphere.broadcast.rule.attribute.BroadcastTableNamesRuleAttribute;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.attribute.RuleAttribute;
import org.apache.shardingsphere.infra.rule.attribute.RuleAttributes;
import org.apache.shardingsphere.infra.rule.attribute.datasource.DataSourceMapperRuleAttribute;
import org.apache.shardingsphere.infra.rule.scope.DatabaseRule;

public final class BroadcastRule
implements DatabaseRule {
    private final BroadcastRuleConfiguration configuration;
    private final String databaseName;
    private final Collection<String> tables;
    private final Collection<String> dataSourceNames;
    private final RuleAttributes attributes;

    public BroadcastRule(BroadcastRuleConfiguration config, String databaseName, Map<String, DataSource> dataSources, Collection<ShardingSphereRule> builtRules) {
        this.configuration = config;
        this.databaseName = databaseName;
        this.dataSourceNames = this.getAggregatedDataSourceNames(dataSources, builtRules);
        this.tables = this.createBroadcastTables(config.getTables());
        this.attributes = new RuleAttributes(new RuleAttribute[]{new BroadcastDataNodeRuleAttribute(this.dataSourceNames, this.tables), new BroadcastTableNamesRuleAttribute(this.tables)});
    }

    private Collection<String> getAggregatedDataSourceNames(Map<String, DataSource> dataSources, Collection<ShardingSphereRule> builtRules) {
        Collection<String> result = new LinkedList<String>(dataSources.keySet());
        for (ShardingSphereRule each : builtRules) {
            Optional ruleAttribute = each.getAttributes().findAttribute(DataSourceMapperRuleAttribute.class);
            if (!ruleAttribute.isPresent()) continue;
            result = this.getAggregatedDataSourceNames(result, (DataSourceMapperRuleAttribute)ruleAttribute.get());
        }
        return result;
    }

    private Collection<String> getAggregatedDataSourceNames(Collection<String> dataSourceNames, DataSourceMapperRuleAttribute ruleAttribute) {
        LinkedList<String> result = new LinkedList<String>();
        for (Map.Entry entry : ruleAttribute.getDataSourceMapper().entrySet()) {
            for (String each : (Collection)entry.getValue()) {
                if (!dataSourceNames.contains(each)) continue;
                dataSourceNames.remove(each);
                if (result.contains(entry.getKey())) continue;
                result.add((String)entry.getKey());
            }
        }
        result.addAll(dataSourceNames);
        return result;
    }

    private Collection<String> createBroadcastTables(Collection<String> broadcastTables) {
        return new CaseInsensitiveSet(broadcastTables);
    }

    public Collection<String> getBroadcastRuleTableNames(Collection<String> logicTableNames) {
        return logicTableNames.stream().filter(this.tables::contains).collect(Collectors.toSet());
    }

    public boolean isAllBroadcastTables(Collection<String> logicTableNames) {
        return !logicTableNames.isEmpty() && this.tables.containsAll(logicTableNames);
    }

    @Generated
    public BroadcastRuleConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Generated
    public Collection<String> getTables() {
        return this.tables;
    }

    @Generated
    public Collection<String> getDataSourceNames() {
        return this.dataSourceNames;
    }

    @Generated
    public RuleAttributes getAttributes() {
        return this.attributes;
    }
}

