/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.metadata.persist.node.metadata;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public final class DataSourceMetaDataNode {
    private static final String ROOT_NODE = "metadata";
    private static final String DATA_SOURCES_NODE = "data_sources";
    private static final String DATA_SOURCE_NODES_NODE = "nodes";
    private static final String DATA_SOURCE_UNITS_NODE = "units";
    private static final String ACTIVE_VERSION = "active_version";
    private static final String VERSIONS = "versions";
    private static final String DATABASE_DATA_SOURCES_NODE = "/([\\w\\-]+)/data_sources/";
    private static final String ACTIVE_VERSION_SUFFIX = "/([\\w\\-]+)/active_version";
    private static final String DATA_SOURCE_SUFFIX = "/([\\w\\-]+)$";

    public static String getDataSourceUnitsNode(String databaseName) {
        return String.join((CharSequence)"/", DataSourceMetaDataNode.getMetaDataNode(), databaseName, DATA_SOURCES_NODE, DATA_SOURCE_UNITS_NODE);
    }

    public static String getDataSourceNodesNode(String databaseName) {
        return String.join((CharSequence)"/", DataSourceMetaDataNode.getMetaDataNode(), databaseName, DATA_SOURCES_NODE, DATA_SOURCE_NODES_NODE);
    }

    public static String getDataSourceUnitNode(String databaseName, String dataSourceName) {
        return String.join((CharSequence)"/", DataSourceMetaDataNode.getDataSourceUnitsNode(databaseName), dataSourceName);
    }

    public static String getDataSourceNodeNode(String databaseName, String dataSourceName) {
        return String.join((CharSequence)"/", DataSourceMetaDataNode.getDataSourceNodesNode(databaseName), dataSourceName);
    }

    public static String getDataSourceUnitVersionNode(String databaseName, String dataSourceName, String version) {
        return String.join((CharSequence)"/", DataSourceMetaDataNode.getDataSourceUnitVersionsNode(databaseName, dataSourceName), version);
    }

    public static String getDataSourceUnitVersionsNode(String databaseName, String dataSourceName) {
        return String.join((CharSequence)"/", DataSourceMetaDataNode.getDataSourceUnitsNode(databaseName), dataSourceName, VERSIONS);
    }

    public static String getDataSourceUnitActiveVersionNode(String databaseName, String dataSourceName) {
        return String.join((CharSequence)"/", DataSourceMetaDataNode.getDataSourceUnitsNode(databaseName), dataSourceName, ACTIVE_VERSION);
    }

    public static String getDataSourceNodeVersionsNode(String databaseName, String dataSourceName) {
        return String.join((CharSequence)"/", DataSourceMetaDataNode.getDataSourceNodesNode(databaseName), dataSourceName, VERSIONS);
    }

    public static String getDataSourceNodeVersionNode(String databaseName, String dataSourceName, String version) {
        return String.join((CharSequence)"/", DataSourceMetaDataNode.getDataSourceNodeVersionsNode(databaseName, dataSourceName), version);
    }

    public static String getDataSourceNodeActiveVersionNode(String databaseName, String dataSourceName) {
        return String.join((CharSequence)"/", DataSourceMetaDataNode.getDataSourceNodesNode(databaseName), dataSourceName, ACTIVE_VERSION);
    }

    public static boolean isDataSourcesNode(String path) {
        return Pattern.compile(DataSourceMetaDataNode.getMetaDataNode() + DATABASE_DATA_SOURCES_NODE + "?", 2).matcher(path).find();
    }

    public static Optional<String> getDataSourceNameByDataSourceUnitActiveVersionNode(String path) {
        Pattern pattern = Pattern.compile(DataSourceMetaDataNode.getMetaDataNode() + DATABASE_DATA_SOURCES_NODE + DATA_SOURCE_UNITS_NODE + ACTIVE_VERSION_SUFFIX, 2);
        Matcher matcher = pattern.matcher(path);
        return matcher.find() ? Optional.of(matcher.group(2)) : Optional.empty();
    }

    public static Optional<String> getDataSourceNameByDataSourceUnitNode(String path) {
        Pattern pattern = Pattern.compile(DataSourceMetaDataNode.getMetaDataNode() + DATABASE_DATA_SOURCES_NODE + DATA_SOURCE_UNITS_NODE + DATA_SOURCE_SUFFIX, 2);
        Matcher matcher = pattern.matcher(path);
        return matcher.find() ? Optional.of(matcher.group(2)) : Optional.empty();
    }

    public static Optional<String> getDataSourceNameByDataSourceNodeActiveVersionNode(String path) {
        Pattern pattern = Pattern.compile(DataSourceMetaDataNode.getMetaDataNode() + DATABASE_DATA_SOURCES_NODE + DATA_SOURCE_NODES_NODE + ACTIVE_VERSION_SUFFIX, 2);
        Matcher matcher = pattern.matcher(path);
        return matcher.find() ? Optional.of(matcher.group(2)) : Optional.empty();
    }

    public static Optional<String> getDataSourceNameByDataSourceNodeNode(String path) {
        Pattern pattern = Pattern.compile(DataSourceMetaDataNode.getMetaDataNode() + DATABASE_DATA_SOURCES_NODE + DATA_SOURCE_NODES_NODE + DATA_SOURCE_SUFFIX, 2);
        Matcher matcher = pattern.matcher(path);
        return matcher.find() ? Optional.of(matcher.group(2)) : Optional.empty();
    }

    public static boolean isDataSourceUnitActiveVersionNode(String path) {
        return Pattern.compile(DataSourceMetaDataNode.getMetaDataNode() + DATABASE_DATA_SOURCES_NODE + DATA_SOURCE_UNITS_NODE + ACTIVE_VERSION_SUFFIX, 2).matcher(path).find();
    }

    public static boolean isDataSourceUnitNode(String path) {
        return Pattern.compile(DataSourceMetaDataNode.getMetaDataNode() + DATABASE_DATA_SOURCES_NODE + DATA_SOURCE_UNITS_NODE + DATA_SOURCE_SUFFIX, 2).matcher(path).find();
    }

    public static boolean isDataSourceNodeActiveVersionNode(String path) {
        return Pattern.compile(DataSourceMetaDataNode.getMetaDataNode() + DATABASE_DATA_SOURCES_NODE + DATA_SOURCE_NODES_NODE + ACTIVE_VERSION_SUFFIX, 2).matcher(path).find();
    }

    public static boolean isDataSourceNodeNode(String path) {
        return Pattern.compile(DataSourceMetaDataNode.getMetaDataNode() + DATABASE_DATA_SOURCES_NODE + DATA_SOURCE_NODES_NODE + DATA_SOURCE_SUFFIX, 2).matcher(path).find();
    }

    private static String getMetaDataNode() {
        return String.join((CharSequence)"/", "", ROOT_NODE);
    }

    @Generated
    private DataSourceMetaDataNode() {
    }
}

