/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.metadata.persist.node;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.shardingsphere.infra.instance.metadata.InstanceType;

public final class ComputeNode {
    private static final String ROOT_NODE = "nodes";
    private static final String COMPUTE_NODE = "compute_nodes";
    private static final String ONLINE_NODE = "online";
    private static final String LABELS_NODE = "labels";
    private static final String SHOW_PROCESS_LIST_TRIGGER = "show_process_list_trigger";
    private static final String KILL_PROCESS_TRIGGER = "kill_process_trigger";
    private static final String STATUS_NODE = "status";
    private static final String WORKER_ID = "worker_id";

    public static String getOnlineNodePath(InstanceType instanceType) {
        return String.join((CharSequence)"/", "", ROOT_NODE, COMPUTE_NODE, ONLINE_NODE, instanceType.name().toLowerCase());
    }

    public static String getOnlineInstanceNodePath(String instanceId, InstanceType instanceType) {
        return String.join((CharSequence)"/", "", ROOT_NODE, COMPUTE_NODE, ONLINE_NODE, instanceType.name().toLowerCase(), instanceId);
    }

    public static String getOnlineInstanceNodePath() {
        return String.join((CharSequence)"/", "", ROOT_NODE, COMPUTE_NODE, ONLINE_NODE);
    }

    public static String getShowProcessListTriggerNodePath() {
        return String.join((CharSequence)"/", "", ROOT_NODE, COMPUTE_NODE, SHOW_PROCESS_LIST_TRIGGER);
    }

    public static String getKillProcessTriggerNodePath() {
        return String.join((CharSequence)"/", "", ROOT_NODE, COMPUTE_NODE, KILL_PROCESS_TRIGGER);
    }

    public static String getProcessTriggerInstanceNodePath(String instanceId, String taskId) {
        return String.join((CharSequence)"/", "", ROOT_NODE, COMPUTE_NODE, SHOW_PROCESS_LIST_TRIGGER, String.join((CharSequence)":", instanceId, taskId));
    }

    public static String getProcessKillInstanceIdNodePath(String instanceId, String processId) {
        return String.join((CharSequence)"/", "", ROOT_NODE, COMPUTE_NODE, KILL_PROCESS_TRIGGER, String.join((CharSequence)":", instanceId, processId));
    }

    public static String getInstanceLabelsNodePath(String instanceId) {
        return String.join((CharSequence)"/", "", ROOT_NODE, COMPUTE_NODE, LABELS_NODE, instanceId);
    }

    public static String getComputeNodePath() {
        return String.join((CharSequence)"/", "", ROOT_NODE, COMPUTE_NODE);
    }

    public static String getInstanceWorkerIdNodePath(String instanceId) {
        return String.join((CharSequence)"/", "", ROOT_NODE, COMPUTE_NODE, WORKER_ID, instanceId);
    }

    public static String getInstanceWorkerIdRootNodePath() {
        return String.join((CharSequence)"/", "", ROOT_NODE, COMPUTE_NODE, WORKER_ID);
    }

    public static String getInstanceIdByComputeNode(String computeNodePath) {
        Pattern pattern = Pattern.compile(ComputeNode.getComputeNodePath() + "(/status|/worker_id|/labels)/([\\S]+)$", 2);
        Matcher matcher = pattern.matcher(computeNodePath);
        return matcher.find() ? matcher.group(2) : "";
    }

    public static String getComputeNodeStateNodePath(String instanceId) {
        return String.join((CharSequence)"/", "", ROOT_NODE, COMPUTE_NODE, STATUS_NODE, instanceId);
    }

    @Generated
    private ComputeNode() {
    }
}

