/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.statement.dml;

import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.context.statement.CommonSQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.infra.binder.context.type.WhereAvailable;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.UpdateStatement;
import org.apache.shardingsphere.sql.parser.statement.core.util.ColumnExtractUtils;
import org.apache.shardingsphere.sql.parser.statement.core.util.ExpressionExtractUtils;
import org.apache.shardingsphere.sql.parser.statement.core.util.TableExtractor;

public final class UpdateStatementContext
extends CommonSQLStatementContext
implements TableAvailable,
WhereAvailable {
    private final TablesContext tablesContext;
    private final Collection<WhereSegment> whereSegments = new LinkedList<WhereSegment>();
    private final Collection<ColumnSegment> columnSegments = new LinkedList<ColumnSegment>();
    private final Collection<BinaryOperationExpression> joinConditions = new LinkedList<BinaryOperationExpression>();

    public UpdateStatementContext(UpdateStatement sqlStatement, String currentDatabaseName) {
        super((SQLStatement)sqlStatement);
        this.tablesContext = new TablesContext(this.getAllSimpleTableSegments(), this.getDatabaseType(), currentDatabaseName);
        this.getSqlStatement().getWhere().ifPresent(this.whereSegments::add);
        ColumnExtractUtils.extractColumnSegments(this.columnSegments, this.whereSegments);
        ExpressionExtractUtils.extractJoinConditions(this.joinConditions, this.whereSegments);
    }

    private Collection<SimpleTableSegment> getAllSimpleTableSegments() {
        TableExtractor tableExtractor = new TableExtractor();
        tableExtractor.extractTablesFromUpdate(this.getSqlStatement());
        return tableExtractor.getRewriteTables();
    }

    public UpdateStatement getSqlStatement() {
        return (UpdateStatement)super.getSqlStatement();
    }

    @Override
    public Collection<WhereSegment> getWhereSegments() {
        return this.whereSegments;
    }

    @Override
    public Collection<ColumnSegment> getColumnSegments() {
        return this.columnSegments;
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }

    @Override
    @Generated
    public Collection<BinaryOperationExpression> getJoinConditions() {
        return this.joinConditions;
    }
}

