/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rewrite.engine;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.rewrite.context.SQLRewriteContext;
import org.apache.shardingsphere.infra.rewrite.engine.result.RouteSQLRewriteResult;
import org.apache.shardingsphere.infra.rewrite.engine.result.SQLRewriteUnit;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.ParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.impl.GroupedParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.impl.StandardParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.sql.impl.RouteSQLBuilder;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.sql.parser.statement.core.util.SQLUtils;
import org.apache.shardingsphere.sqltranslator.context.SQLTranslatorContext;
import org.apache.shardingsphere.sqltranslator.rule.SQLTranslatorRule;

public final class RouteSQLRewriteEngine {
    private final SQLTranslatorRule translatorRule;
    private final ShardingSphereDatabase database;
    private final RuleMetaData globalRuleMetaData;

    public RouteSQLRewriteResult rewrite(SQLRewriteContext sqlRewriteContext, RouteContext routeContext, QueryContext queryContext) {
        return new RouteSQLRewriteResult(this.translate(queryContext, this.createSQLRewriteUnits(sqlRewriteContext, routeContext)));
    }

    private Map<RouteUnit, SQLRewriteUnit> createSQLRewriteUnits(SQLRewriteContext sqlRewriteContext, RouteContext routeContext) {
        LinkedHashMap<RouteUnit, SQLRewriteUnit> result = new LinkedHashMap<RouteUnit, SQLRewriteUnit>(routeContext.getRouteUnits().size(), 1.0f);
        for (Map.Entry<String, Collection<RouteUnit>> entry : this.aggregateRouteUnitGroups(routeContext.getRouteUnits()).entrySet()) {
            Collection<RouteUnit> routeUnits = entry.getValue();
            if (this.isNeedAggregateRewrite(sqlRewriteContext.getSqlStatementContext(), routeUnits)) {
                result.put(routeUnits.iterator().next(), this.createSQLRewriteUnit(sqlRewriteContext, routeContext, routeUnits));
                continue;
            }
            for (RouteUnit each : routeUnits) {
                result.put(each, this.createSQLRewriteUnit(sqlRewriteContext, routeContext, each));
            }
        }
        return result;
    }

    private Map<String, Collection<RouteUnit>> aggregateRouteUnitGroups(Collection<RouteUnit> routeUnits) {
        LinkedHashMap<String, Collection<RouteUnit>> result = new LinkedHashMap<String, Collection<RouteUnit>>(routeUnits.size(), 1.0f);
        for (RouteUnit each : routeUnits) {
            result.computeIfAbsent(each.getDataSourceMapper().getActualName(), unused -> new LinkedList()).add(each);
        }
        return result;
    }

    private boolean isNeedAggregateRewrite(SQLStatementContext sqlStatementContext, Collection<RouteUnit> routeUnits) {
        if (!(sqlStatementContext instanceof SelectStatementContext) || 1 == routeUnits.size()) {
            return false;
        }
        SelectStatementContext statementContext = (SelectStatementContext)sqlStatementContext;
        boolean containsSubqueryJoinQuery = statementContext.isContainsSubquery() || statementContext.isContainsJoinQuery();
        boolean containsOrderByLimitClause = !statementContext.getOrderByContext().getItems().isEmpty() || statementContext.getPaginationContext().isHasPagination();
        boolean containsLockClause = statementContext.getSqlStatement().getLock().isPresent();
        boolean result = !containsSubqueryJoinQuery && !containsOrderByLimitClause && !containsLockClause;
        statementContext.setNeedAggregateRewrite(result);
        return result;
    }

    private SQLRewriteUnit createSQLRewriteUnit(SQLRewriteContext sqlRewriteContext, RouteContext routeContext, Collection<RouteUnit> routeUnits) {
        LinkedList<String> sql = new LinkedList<String>();
        LinkedList<Object> params = new LinkedList<Object>();
        boolean containsDollarMarker = sqlRewriteContext.getSqlStatementContext() instanceof SelectStatementContext && ((SelectStatementContext)sqlRewriteContext.getSqlStatementContext()).isContainsDollarParameterMarker();
        for (RouteUnit each : routeUnits) {
            sql.add(SQLUtils.trimSemicolon((String)new RouteSQLBuilder(sqlRewriteContext.getSql(), sqlRewriteContext.getSqlTokens(), each).toSQL()));
            if (containsDollarMarker && !params.isEmpty()) continue;
            params.addAll(this.getParameters(sqlRewriteContext, routeContext, each));
        }
        return new SQLRewriteUnit(String.join((CharSequence)" UNION ALL ", sql), params);
    }

    private SQLRewriteUnit createSQLRewriteUnit(SQLRewriteContext sqlRewriteContext, RouteContext routeContext, RouteUnit routeUnit) {
        return new SQLRewriteUnit(this.getActualSQL(sqlRewriteContext, routeUnit), this.getParameters(sqlRewriteContext, routeContext, routeUnit));
    }

    private String getActualSQL(SQLRewriteContext sqlRewriteContext, RouteUnit routeUnit) {
        return new RouteSQLBuilder(sqlRewriteContext.getSql(), sqlRewriteContext.getSqlTokens(), routeUnit).toSQL();
    }

    private List<Object> getParameters(SQLRewriteContext sqlRewriteContext, RouteContext routeContext, RouteUnit routeUnit) {
        ParameterBuilder parameterBuilder = sqlRewriteContext.getParameterBuilder();
        if (parameterBuilder instanceof StandardParameterBuilder) {
            return parameterBuilder.getParameters();
        }
        return routeContext.getOriginalDataNodes().isEmpty() ? ((GroupedParameterBuilder)parameterBuilder).getParameters() : this.buildRouteParameters((GroupedParameterBuilder)parameterBuilder, routeContext, routeUnit);
    }

    private List<Object> buildRouteParameters(GroupedParameterBuilder paramBuilder, RouteContext routeContext, RouteUnit routeUnit) {
        LinkedList<Object> result = new LinkedList<Object>();
        int count = 0;
        for (Collection each : routeContext.getOriginalDataNodes()) {
            if (this.isInSameDataNode(each, routeUnit)) {
                result.addAll(paramBuilder.getParameters(count));
            }
            ++count;
        }
        result.addAll(paramBuilder.getGenericParameterBuilder().getParameters());
        return result;
    }

    private boolean isInSameDataNode(Collection<DataNode> dataNodes, RouteUnit routeUnit) {
        if (dataNodes.isEmpty()) {
            return true;
        }
        for (DataNode each : dataNodes) {
            if (!routeUnit.findTableMapper(each.getDataSourceName(), each.getTableName()).isPresent()) continue;
            return true;
        }
        return false;
    }

    private Map<RouteUnit, SQLRewriteUnit> translate(QueryContext queryContext, Map<RouteUnit, SQLRewriteUnit> sqlRewriteUnits) {
        LinkedHashMap<RouteUnit, SQLRewriteUnit> result = new LinkedHashMap<RouteUnit, SQLRewriteUnit>(sqlRewriteUnits.size(), 1.0f);
        Map storageUnits = this.database.getResourceMetaData().getStorageUnits();
        for (Map.Entry<RouteUnit, SQLRewriteUnit> entry : sqlRewriteUnits.entrySet()) {
            DatabaseType storageType = ((StorageUnit)storageUnits.get(entry.getKey().getDataSourceMapper().getActualName())).getStorageType();
            SQLTranslatorContext sqlTranslatorContext = this.translatorRule.translate(entry.getValue().getSql(), entry.getValue().getParameters(), queryContext, storageType, this.database, this.globalRuleMetaData);
            SQLRewriteUnit sqlRewriteUnit = new SQLRewriteUnit(sqlTranslatorContext.getSql(), sqlTranslatorContext.getParameters());
            result.put(entry.getKey(), sqlRewriteUnit);
        }
        return result;
    }

    @Generated
    public RouteSQLRewriteEngine(SQLTranslatorRule translatorRule, ShardingSphereDatabase database, RuleMetaData globalRuleMetaData) {
        this.translatorRule = translatorRule;
        this.database = database;
        this.globalRuleMetaData = globalRuleMetaData;
    }
}

