/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.util.groovy;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public final class GroovyUtils {
    public static List<String> split(String inlineExpression) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder segment = new StringBuilder();
        int bracketsDepth = 0;
        block5: for (int i = 0; i < inlineExpression.length(); ++i) {
            char each = inlineExpression.charAt(i);
            switch (each) {
                case ',': {
                    GroovyUtils.handleSplitter(bracketsDepth, segment, each, result);
                    continue block5;
                }
                case '$': {
                    bracketsDepth = GroovyUtils.handleDollarSign(inlineExpression, i, bracketsDepth, segment, each);
                    continue block5;
                }
                case '}': {
                    bracketsDepth = GroovyUtils.handleClosingBracket(bracketsDepth, segment, each);
                    continue block5;
                }
                default: {
                    segment.append(each);
                }
            }
        }
        if (segment.length() > 0) {
            result.add(segment.toString().trim());
        }
        return result;
    }

    private static void handleSplitter(int bracketsDepth, StringBuilder segment, char each, List<String> result) {
        if (bracketsDepth > 0) {
            segment.append(each);
        } else {
            result.add(segment.toString().trim());
            segment.setLength(0);
        }
    }

    private static int handleDollarSign(String inlineExpression, int i, int bracketsDepth, StringBuilder segment, char each) {
        int bracketsDepthResult = bracketsDepth;
        if ('{' == inlineExpression.charAt(i + 1)) {
            ++bracketsDepthResult;
        }
        if ("->{".equals(inlineExpression.substring(i + 1, i + 4))) {
            ++bracketsDepthResult;
        }
        segment.append(each);
        return bracketsDepthResult;
    }

    private static int handleClosingBracket(int bracketsDepth, StringBuilder segment, char each) {
        segment.append(each);
        return bracketsDepth > 0 ? bracketsDepth - 1 : bracketsDepth;
    }

    @Generated
    private GroovyUtils() {
    }
}

