/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.refresher;

import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.props.temporary.TemporaryConfigurationPropertyKey;
import org.apache.shardingsphere.infra.executor.kernel.thread.ExecutorThreadFactoryBuilder;
import org.apache.shardingsphere.infra.lock.GlobalLockNames;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereDatabaseData;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereRowData;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereSchemaData;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereStatistics;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereTableData;
import org.apache.shardingsphere.infra.metadata.statistics.collector.ShardingSphereStatisticsCollector;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.infra.yaml.data.swapper.YamlShardingSphereRowDataSwapper;
import org.apache.shardingsphere.metadata.persist.data.AlteredShardingSphereDatabaseData;
import org.apache.shardingsphere.mode.lock.GlobalLockContext;
import org.apache.shardingsphere.mode.lock.GlobalLockDefinition;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShardingSphereStatisticsRefreshEngine {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShardingSphereStatisticsRefreshEngine.class);
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newSingleThreadScheduledExecutor(ExecutorThreadFactoryBuilder.build((String)"statistics-collect-%d"));
    private final ContextManager contextManager;
    private final GlobalLockContext globalLockContext;

    public void asyncRefresh() {
        EXECUTOR_SERVICE.execute(this::refresh);
    }

    public void refresh() {
        try {
            if (((Boolean)this.contextManager.getMetaDataContexts().getMetaData().getTemporaryProps().getValue((Enum)TemporaryConfigurationPropertyKey.PROXY_META_DATA_COLLECTOR_ENABLED)).booleanValue()) {
                this.collectAndRefresh();
            }
        }
        catch (Exception ex) {
            log.error("Collect data error", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectAndRefresh() {
        GlobalLockDefinition lockDefinition = new GlobalLockDefinition(GlobalLockNames.STATISTICS.getLockName());
        if (this.globalLockContext.tryLock(lockDefinition, 5000L)) {
            try {
                ShardingSphereStatistics statistics = this.contextManager.getMetaDataContexts().getStatistics();
                ShardingSphereMetaData metaData = this.contextManager.getMetaDataContexts().getMetaData();
                ShardingSphereStatistics changedStatistics = new ShardingSphereStatistics();
                for (Map.Entry entry : statistics.getDatabaseData().entrySet()) {
                    if (!metaData.containsDatabase((String)entry.getKey())) continue;
                    this.collectForDatabase((String)entry.getKey(), (ShardingSphereDatabaseData)entry.getValue(), metaData, changedStatistics);
                }
                this.compareAndUpdate(changedStatistics);
            }
            finally {
                this.globalLockContext.unlock(lockDefinition);
            }
        }
    }

    private void collectForDatabase(String databaseName, ShardingSphereDatabaseData databaseData, ShardingSphereMetaData metaData, ShardingSphereStatistics statistics) {
        for (Map.Entry entry : databaseData.getSchemaData().entrySet()) {
            if (!metaData.getDatabase(databaseName).containsSchema((String)entry.getKey())) continue;
            this.collectForSchema(databaseName, (String)entry.getKey(), (ShardingSphereSchemaData)entry.getValue(), metaData, statistics);
        }
    }

    private void collectForSchema(String databaseName, String schemaName, ShardingSphereSchemaData schemaData, ShardingSphereMetaData metaData, ShardingSphereStatistics statistics) {
        for (Map.Entry entry : schemaData.getTableData().entrySet()) {
            if (!metaData.getDatabase(databaseName).getSchema(schemaName).containsTable((String)entry.getKey())) continue;
            this.collectForTable(databaseName, schemaName, metaData.getDatabase(databaseName).getSchema(schemaName).getTable((String)entry.getKey()), metaData, statistics);
        }
    }

    private void collectForTable(String databaseName, String schemaName, ShardingSphereTable table, ShardingSphereMetaData metaData, ShardingSphereStatistics statistics) {
        Optional dataCollector = TypedSPILoader.findService(ShardingSphereStatisticsCollector.class, (Object)table.getName());
        Optional tableData = Optional.empty();
        if (dataCollector.isPresent()) {
            try {
                tableData = ((ShardingSphereStatisticsCollector)dataCollector.get()).collect(databaseName, table, metaData.getDatabases(), this.contextManager.getMetaDataContexts().getMetaData().getGlobalRuleMetaData());
            }
            catch (Exception ex) {
                log.error(String.format("Collect %s.%s.%s data failed", databaseName, schemaName, table.getName()), (Throwable)ex);
            }
        }
        ShardingSphereDatabaseData databaseData = statistics.containsDatabase(databaseName) ? statistics.getDatabase(databaseName) : new ShardingSphereDatabaseData();
        ShardingSphereSchemaData schemaData = databaseData.containsSchema(schemaName) ? databaseData.getSchema(schemaName) : new ShardingSphereSchemaData();
        tableData.ifPresent(optional -> schemaData.putTable(table.getName(), optional));
        databaseData.putSchema(schemaName, schemaData);
        statistics.putDatabase(databaseName, databaseData);
    }

    private void compareAndUpdate(ShardingSphereStatistics changedStatistics) {
        ShardingSphereMetaData metaData = this.contextManager.getMetaDataContexts().getMetaData();
        ShardingSphereStatistics statistics = this.contextManager.getMetaDataContexts().getStatistics();
        for (Map.Entry entry : changedStatistics.getDatabaseData().entrySet()) {
            this.compareAndUpdateForDatabase((String)entry.getKey(), statistics.getDatabase((String)entry.getKey()), (ShardingSphereDatabaseData)entry.getValue(), statistics, metaData.getDatabase((String)entry.getKey()));
        }
        for (Map.Entry entry : statistics.getDatabaseData().entrySet()) {
            if (changedStatistics.containsDatabase((String)entry.getKey())) continue;
            statistics.dropDatabase((String)entry.getKey());
            this.contextManager.getPersistServiceFacade().getMetaDataPersistService().getShardingSphereDataPersistService().delete((String)entry.getKey());
        }
    }

    private void compareAndUpdateForDatabase(String databaseName, ShardingSphereDatabaseData databaseData, ShardingSphereDatabaseData changedDatabaseData, ShardingSphereStatistics statistics, ShardingSphereDatabase database) {
        for (Map.Entry entry : changedDatabaseData.getSchemaData().entrySet()) {
            this.compareAndUpdateForSchema(databaseName, (String)entry.getKey(), databaseData.getSchema((String)entry.getKey()), (ShardingSphereSchemaData)entry.getValue(), statistics, database.getSchema((String)entry.getKey()));
        }
    }

    private void compareAndUpdateForSchema(String databaseName, String schemaName, ShardingSphereSchemaData schemaData, ShardingSphereSchemaData changedSchemaData, ShardingSphereStatistics statistics, ShardingSphereSchema schema) {
        for (Map.Entry entry : changedSchemaData.getTableData().entrySet()) {
            this.compareAndUpdateForTable(databaseName, schemaName, schemaData.getTable((String)entry.getKey()), (ShardingSphereTableData)entry.getValue(), statistics, schema.getTable((String)entry.getKey()));
        }
    }

    private void compareAndUpdateForTable(String databaseName, String schemaName, ShardingSphereTableData tableData, ShardingSphereTableData changedTableData, ShardingSphereStatistics statistics, ShardingSphereTable table) {
        if (!tableData.equals((Object)changedTableData)) {
            statistics.getDatabase(databaseName).getSchema(schemaName).putTable(changedTableData.getName(), changedTableData);
            AlteredShardingSphereDatabaseData alteredShardingSphereDatabaseData = this.createAlteredShardingSphereDatabaseData(databaseName, schemaName, tableData, changedTableData, table);
            this.contextManager.getPersistServiceFacade().getMetaDataPersistService().getShardingSphereDataPersistService().update(alteredShardingSphereDatabaseData);
        }
    }

    private AlteredShardingSphereDatabaseData createAlteredShardingSphereDatabaseData(String databaseName, String schemaName, ShardingSphereTableData tableData, ShardingSphereTableData changedTableData, ShardingSphereTable table) {
        AlteredShardingSphereDatabaseData result = new AlteredShardingSphereDatabaseData(databaseName, schemaName, tableData.getName());
        Map tableDataMap = tableData.getRows().stream().collect(Collectors.toMap(ShardingSphereRowData::getUniqueKey, Function.identity()));
        Map changedTableDataMap = changedTableData.getRows().stream().collect(Collectors.toMap(ShardingSphereRowData::getUniqueKey, Function.identity()));
        YamlShardingSphereRowDataSwapper swapper = new YamlShardingSphereRowDataSwapper(new ArrayList(table.getColumnValues()));
        for (Map.Entry entry : changedTableDataMap.entrySet()) {
            if (!tableDataMap.containsKey(entry.getKey())) {
                result.getAddedRows().add(swapper.swapToYamlConfiguration((ShardingSphereRowData)entry.getValue()));
                continue;
            }
            if (((ShardingSphereRowData)tableDataMap.get(entry.getKey())).equals(entry.getValue())) continue;
            result.getUpdatedRows().add(swapper.swapToYamlConfiguration((ShardingSphereRowData)entry.getValue()));
        }
        for (Map.Entry entry : tableDataMap.entrySet()) {
            if (changedTableDataMap.containsKey(entry.getKey())) continue;
            result.getDeletedRows().add(swapper.swapToYamlConfiguration((ShardingSphereRowData)entry.getValue()));
        }
        return result;
    }

    @Generated
    public ShardingSphereStatisticsRefreshEngine(ContextManager contextManager, GlobalLockContext globalLockContext) {
        this.contextManager = contextManager;
        this.globalLockContext = globalLockContext;
    }
}

