/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.event.builder;

import com.google.common.base.Strings;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.event.dispatch.DispatchEvent;
import org.apache.shardingsphere.mode.event.dispatch.rule.RuleItemChangedEvent;
import org.apache.shardingsphere.mode.event.dispatch.rule.alter.AlterNamedRuleItemEvent;
import org.apache.shardingsphere.mode.event.dispatch.rule.alter.AlterUniqueRuleItemEvent;
import org.apache.shardingsphere.mode.event.dispatch.rule.drop.DropNamedRuleItemEvent;
import org.apache.shardingsphere.mode.event.dispatch.rule.drop.DropUniqueRuleItemEvent;
import org.apache.shardingsphere.mode.path.rule.RuleNodePath;
import org.apache.shardingsphere.mode.path.rule.item.NamedRuleItemNodePath;
import org.apache.shardingsphere.mode.path.rule.item.UniqueRuleItemNodePath;
import org.apache.shardingsphere.mode.spi.RuleNodePathProvider;

public final class RuleConfigurationEventBuilder {
    public Optional<DispatchEvent> build(String databaseName, DataChangedEvent event) {
        for (RuleNodePathProvider each : ShardingSphereServiceLoader.getServiceInstances(RuleNodePathProvider.class)) {
            Optional<DispatchEvent> result = this.build(each.getRuleNodePath(), databaseName, event);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    private Optional<DispatchEvent> build(RuleNodePath ruleNodePath, String databaseName, DataChangedEvent event) {
        if (!ruleNodePath.getRoot().isValidatedPath(event.getKey()) || DataChangedEvent.Type.DELETED != event.getType() && Strings.isNullOrEmpty((String)event.getValue())) {
            return Optional.empty();
        }
        for (Map.Entry entry : ruleNodePath.getNamedItems().entrySet()) {
            Optional itemName = DataChangedEvent.Type.ADDED == event.getType() || DataChangedEvent.Type.UPDATED == event.getType() ? ((NamedRuleItemNodePath)entry.getValue()).getNameByActiveVersion(event.getKey()) : ((NamedRuleItemNodePath)entry.getValue()).getNameByItemPath(event.getKey());
            if (!itemName.isPresent()) continue;
            return Optional.of(this.create(databaseName, (String)itemName.get(), event, ruleNodePath.getRoot().getRuleType() + "." + (String)entry.getKey()));
        }
        for (Map.Entry entry : ruleNodePath.getUniqueItems().entrySet()) {
            if (!((UniqueRuleItemNodePath)entry.getValue()).isActiveVersionPath(event.getKey())) continue;
            return Optional.of(this.create(databaseName, event, ruleNodePath.getRoot().getRuleType() + "." + (String)entry.getKey()));
        }
        return Optional.empty();
    }

    private RuleItemChangedEvent create(String databaseName, String itemName, DataChangedEvent event, String type) {
        return DataChangedEvent.Type.ADDED == event.getType() || DataChangedEvent.Type.UPDATED == event.getType() ? new AlterNamedRuleItemEvent(databaseName, itemName, event.getKey(), event.getValue(), type) : new DropNamedRuleItemEvent(databaseName, itemName, type);
    }

    private RuleItemChangedEvent create(String databaseName, DataChangedEvent event, String type) {
        return DataChangedEvent.Type.ADDED == event.getType() || DataChangedEvent.Type.UPDATED == event.getType() ? new AlterUniqueRuleItemEvent(databaseName, event.getKey(), event.getValue(), type) : new DropUniqueRuleItemEvent(databaseName, type);
    }
}

