/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rule.builder;

import java.util.Collection;
import java.util.Map;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstanceContext;
import org.apache.shardingsphere.infra.metadata.database.resource.ResourceMetaData;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.builder.database.DatabaseRuleBuilder;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.exception.metadata.MissingRequiredShardingConfigurationException;
import org.apache.shardingsphere.sharding.rule.ShardingRule;

public final class ShardingRuleBuilder
implements DatabaseRuleBuilder<ShardingRuleConfiguration> {
    public ShardingRule build(ShardingRuleConfiguration ruleConfig, String databaseName, DatabaseType protocolType, ResourceMetaData resourceMetaData, Collection<ShardingSphereRule> builtRules, ComputeNodeInstanceContext computeNodeInstanceContext) {
        ShardingSpherePreconditions.checkNotEmpty((Map)resourceMetaData.getDataSourceMap(), () -> new MissingRequiredShardingConfigurationException("Data source", databaseName));
        return new ShardingRule(ruleConfig, resourceMetaData.getDataSourceMap(), computeNodeInstanceContext);
    }

    public int getOrder() {
        return 0;
    }

    public Class<ShardingRuleConfiguration> getTypeClass() {
        return ShardingRuleConfiguration.class;
    }
}

