/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.merge.ddl;

import com.cedarsoftware.util.CaseInsensitiveMap;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.ddl.FetchStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.merge.engine.merger.ResultMerger;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.transparent.TransparentMergedResult;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.session.connection.ConnectionContext;
import org.apache.shardingsphere.sharding.merge.common.IteratorStreamMergedResult;
import org.apache.shardingsphere.sharding.merge.ddl.fetch.FetchStreamMergedResult;
import org.apache.shardingsphere.sql.parser.statement.core.util.SQLUtils;

public final class ShardingDDLResultMerger
implements ResultMerger {
    public MergedResult merge(List<QueryResult> queryResults, SQLStatementContext sqlStatementContext, ShardingSphereDatabase database, ConnectionContext connectionContext) throws SQLException {
        if (!(sqlStatementContext instanceof FetchStatementContext)) {
            return new TransparentMergedResult(queryResults.get(0));
        }
        if (1 == queryResults.size()) {
            return new IteratorStreamMergedResult(queryResults);
        }
        FetchStatementContext fetchStatementContext = (FetchStatementContext)sqlStatementContext;
        Map<String, Integer> columnLabelIndexMap = this.getColumnLabelIndexMap(queryResults.get(0));
        fetchStatementContext.getCursorStatementContext().getSelectStatementContext().setIndexes(columnLabelIndexMap);
        return new FetchStreamMergedResult(queryResults, fetchStatementContext, this.getSchema(sqlStatementContext, database), connectionContext);
    }

    private ShardingSphereSchema getSchema(SQLStatementContext sqlStatementContext, ShardingSphereDatabase database) {
        String defaultSchemaName = new DatabaseTypeRegistry(sqlStatementContext.getDatabaseType()).getDefaultSchemaName(database.getName());
        return sqlStatementContext instanceof TableAvailable ? ((TableAvailable)sqlStatementContext).getTablesContext().getSchemaName().map(arg_0 -> ((ShardingSphereDatabase)database).getSchema(arg_0)).orElseGet(() -> database.getSchema(defaultSchemaName)) : database.getSchema(defaultSchemaName);
    }

    private Map<String, Integer> getColumnLabelIndexMap(QueryResult queryResult) throws SQLException {
        CaseInsensitiveMap result = new CaseInsensitiveMap();
        for (int i = 0; i < queryResult.getMetaData().getColumnCount(); ++i) {
            result.put(SQLUtils.getExactlyValue((String)queryResult.getMetaData().getColumnLabel(i + 1)), i + 1);
        }
        return result;
    }
}

