/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.statement.core.util;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.JoinTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.statement.core.util.SubqueryExtractUtils;

public final class WhereExtractUtils {
    public static Collection<WhereSegment> getJoinWhereSegments(SelectStatement selectStatement) {
        return selectStatement.getFrom().map(WhereExtractUtils::getJoinWhereSegments).orElseGet(Collections::emptyList);
    }

    private static Collection<WhereSegment> getJoinWhereSegments(TableSegment tableSegment) {
        if (!(tableSegment instanceof JoinTableSegment) || null == ((JoinTableSegment)tableSegment).getCondition()) {
            return Collections.emptyList();
        }
        JoinTableSegment joinTableSegment = (JoinTableSegment)tableSegment;
        LinkedList<WhereSegment> result = new LinkedList<WhereSegment>();
        result.add(WhereExtractUtils.generateWhereSegment(joinTableSegment));
        result.addAll(WhereExtractUtils.getJoinWhereSegments(joinTableSegment.getLeft()));
        result.addAll(WhereExtractUtils.getJoinWhereSegments(joinTableSegment.getRight()));
        return result;
    }

    private static WhereSegment generateWhereSegment(JoinTableSegment joinTableSegment) {
        ExpressionSegment expressionSegment = joinTableSegment.getCondition();
        return new WhereSegment(expressionSegment.getStartIndex(), expressionSegment.getStopIndex(), expressionSegment);
    }

    public static Collection<WhereSegment> getSubqueryWhereSegments(SelectStatement selectStatement) {
        LinkedList<WhereSegment> result = new LinkedList<WhereSegment>();
        for (SubquerySegment each : SubqueryExtractUtils.getSubquerySegments(selectStatement)) {
            each.getSelect().getWhere().ifPresent(result::add);
            result.addAll(WhereExtractUtils.getJoinWhereSegments(each.getSelect()));
        }
        return result;
    }

    public static Collection<WhereSegment> getSubqueryWhereSegmentsWithoutJoinConditions(SelectStatement selectStatement) {
        LinkedList<WhereSegment> result = new LinkedList<WhereSegment>();
        for (SubquerySegment each : SubqueryExtractUtils.getSubquerySegments(selectStatement)) {
            each.getSelect().getWhere().ifPresent(result::add);
        }
        return result;
    }

    @Generated
    private WhereExtractUtils() {
    }
}

