/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.statement.core.util;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.statement.core.enums.SubqueryType;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.combine.CombineSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.datetime.DatetimeExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BetweenExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.CaseWhenExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.CollateExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExistsSubqueryExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.FunctionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.InExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ListExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.NotExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.TypeCastExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.complex.CommonTableExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.subquery.SubqueryExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionsSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.SubqueryProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.match.MatchAgainstExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.JoinTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.SelectStatement;

public final class SubqueryExtractUtils {
    public static Collection<SubquerySegment> getSubquerySegments(SelectStatement selectStatement) {
        LinkedList<SubquerySegment> result = new LinkedList<SubquerySegment>();
        SubqueryExtractUtils.extractSubquerySegments(result, selectStatement);
        return result;
    }

    private static void extractSubquerySegments(List<SubquerySegment> result, SelectStatement selectStatement) {
        SubqueryExtractUtils.extractSubquerySegmentsFromProjections(result, selectStatement.getProjections());
        selectStatement.getFrom().ifPresent(optional -> SubqueryExtractUtils.extractSubquerySegmentsFromTableSegment(result, optional));
        if (selectStatement.getWhere().isPresent()) {
            SubqueryExtractUtils.extractSubquerySegmentsFromWhere(result, selectStatement.getWhere().get().getExpr());
        }
        if (selectStatement.getCombine().isPresent()) {
            SubqueryExtractUtils.extractSubquerySegmentsFromCombine(result, selectStatement.getCombine().get());
        }
        if (selectStatement.getWithSegment().isPresent()) {
            SubqueryExtractUtils.extractSubquerySegmentsFromCTEs(result, selectStatement.getWithSegment().get().getCommonTableExpressions());
        }
    }

    private static void extractSubquerySegmentsFromCTEs(List<SubquerySegment> result, Collection<CommonTableExpressionSegment> withSegment) {
        for (CommonTableExpressionSegment each : withSegment) {
            each.getSubquery().setSubqueryType(SubqueryType.WITH);
            result.add(each.getSubquery());
            SubqueryExtractUtils.extractSubquerySegments(result, each.getSubquery().getSelect());
        }
    }

    private static void extractSubquerySegmentsFromProjections(List<SubquerySegment> result, ProjectionsSegment projections) {
        if (null == projections || projections.getProjections().isEmpty()) {
            return;
        }
        for (ProjectionSegment each : projections.getProjections()) {
            if (each instanceof SubqueryProjectionSegment) {
                SubquerySegment subquery = ((SubqueryProjectionSegment)each).getSubquery();
                subquery.setSubqueryType(SubqueryType.PROJECTION);
                result.add(subquery);
                SubqueryExtractUtils.extractSubquerySegments(result, subquery.getSelect());
                continue;
            }
            if (!(each instanceof ExpressionProjectionSegment)) continue;
            SubqueryExtractUtils.extractSubquerySegmentsFromExpression(result, ((ExpressionProjectionSegment)each).getExpr(), SubqueryType.PROJECTION);
        }
    }

    private static void extractSubquerySegmentsFromTableSegment(List<SubquerySegment> result, TableSegment tableSegment) {
        if (tableSegment instanceof SubqueryTableSegment) {
            SubqueryExtractUtils.extractSubquerySegmentsFromSubqueryTableSegment(result, (SubqueryTableSegment)tableSegment);
        }
        if (tableSegment instanceof JoinTableSegment) {
            SubqueryExtractUtils.extractSubquerySegmentsFromJoinTableSegment(result, ((JoinTableSegment)tableSegment).getLeft());
            SubqueryExtractUtils.extractSubquerySegmentsFromJoinTableSegment(result, ((JoinTableSegment)tableSegment).getRight());
        }
    }

    private static void extractSubquerySegmentsFromJoinTableSegment(List<SubquerySegment> result, TableSegment tableSegment) {
        if (tableSegment instanceof SubqueryTableSegment) {
            SubquerySegment subquery = ((SubqueryTableSegment)tableSegment).getSubquery();
            subquery.setSubqueryType(SubqueryType.JOIN);
            result.add(subquery);
            SubqueryExtractUtils.extractSubquerySegments(result, subquery.getSelect());
        } else if (tableSegment instanceof JoinTableSegment) {
            SubqueryExtractUtils.extractSubquerySegmentsFromJoinTableSegment(result, ((JoinTableSegment)tableSegment).getLeft());
            SubqueryExtractUtils.extractSubquerySegmentsFromJoinTableSegment(result, ((JoinTableSegment)tableSegment).getRight());
        }
    }

    private static void extractSubquerySegmentsFromSubqueryTableSegment(List<SubquerySegment> result, SubqueryTableSegment subqueryTableSegment) {
        SubquerySegment subquery = subqueryTableSegment.getSubquery();
        subquery.setSubqueryType(SubqueryType.TABLE);
        result.add(subquery);
        SubqueryExtractUtils.extractSubquerySegments(result, subquery.getSelect());
    }

    private static void extractSubquerySegmentsFromWhere(List<SubquerySegment> result, ExpressionSegment expressionSegment) {
        SubqueryExtractUtils.extractSubquerySegmentsFromExpression(result, expressionSegment, SubqueryType.PREDICATE);
    }

    private static void extractSubquerySegmentsFromExpression(List<SubquerySegment> result, ExpressionSegment expressionSegment, SubqueryType subqueryType) {
        SubquerySegment subquery;
        if (expressionSegment instanceof SubqueryExpressionSegment) {
            subquery = ((SubqueryExpressionSegment)expressionSegment).getSubquery();
            subquery.setSubqueryType(subqueryType);
            result.add(subquery);
            SubqueryExtractUtils.extractSubquerySegments(result, subquery.getSelect());
        }
        if (expressionSegment instanceof ExistsSubqueryExpression) {
            subquery = ((ExistsSubqueryExpression)expressionSegment).getSubquery();
            subquery.setSubqueryType(subqueryType);
            result.add(subquery);
            SubqueryExtractUtils.extractSubquerySegments(result, subquery.getSelect());
        }
        if (expressionSegment instanceof ListExpression) {
            ((ListExpression)expressionSegment).getItems().forEach(each -> SubqueryExtractUtils.extractSubquerySegmentsFromExpression(result, each, subqueryType));
        }
        if (expressionSegment instanceof BinaryOperationExpression) {
            SubqueryExtractUtils.extractSubquerySegmentsFromExpression(result, ((BinaryOperationExpression)expressionSegment).getLeft(), subqueryType);
            SubqueryExtractUtils.extractSubquerySegmentsFromExpression(result, ((BinaryOperationExpression)expressionSegment).getRight(), subqueryType);
        }
        if (expressionSegment instanceof InExpression) {
            SubqueryExtractUtils.extractSubquerySegmentsFromExpression(result, ((InExpression)expressionSegment).getLeft(), subqueryType);
            SubqueryExtractUtils.extractSubquerySegmentsFromExpression(result, ((InExpression)expressionSegment).getRight(), subqueryType);
        }
        if (expressionSegment instanceof BetweenExpression) {
            SubqueryExtractUtils.extractSubquerySegmentsFromExpression(result, ((BetweenExpression)expressionSegment).getBetweenExpr(), subqueryType);
            SubqueryExtractUtils.extractSubquerySegmentsFromExpression(result, ((BetweenExpression)expressionSegment).getAndExpr(), subqueryType);
        }
        if (expressionSegment instanceof NotExpression) {
            SubqueryExtractUtils.extractSubquerySegmentsFromExpression(result, ((NotExpression)expressionSegment).getExpression(), subqueryType);
        }
        if (expressionSegment instanceof FunctionSegment) {
            ((FunctionSegment)expressionSegment).getParameters().forEach(each -> SubqueryExtractUtils.extractSubquerySegmentsFromExpression(result, each, subqueryType));
        }
        if (expressionSegment instanceof MatchAgainstExpression) {
            SubqueryExtractUtils.extractSubquerySegmentsFromExpression(result, ((MatchAgainstExpression)expressionSegment).getExpr(), subqueryType);
        }
        if (expressionSegment instanceof CaseWhenExpression) {
            SubqueryExtractUtils.extractSubquerySegmentsFromCaseWhenExpression(result, (CaseWhenExpression)expressionSegment, subqueryType);
        }
        if (expressionSegment instanceof CollateExpression) {
            SubqueryExtractUtils.extractSubquerySegmentsFromExpression(result, ((CollateExpression)expressionSegment).getCollateName(), subqueryType);
        }
        if (expressionSegment instanceof DatetimeExpression) {
            SubqueryExtractUtils.extractSubquerySegmentsFromExpression(result, ((DatetimeExpression)expressionSegment).getLeft(), subqueryType);
            SubqueryExtractUtils.extractSubquerySegmentsFromExpression(result, ((DatetimeExpression)expressionSegment).getRight(), subqueryType);
        }
        if (expressionSegment instanceof NotExpression) {
            SubqueryExtractUtils.extractSubquerySegmentsFromExpression(result, ((NotExpression)expressionSegment).getExpression(), subqueryType);
        }
        if (expressionSegment instanceof TypeCastExpression) {
            SubqueryExtractUtils.extractSubquerySegmentsFromExpression(result, ((TypeCastExpression)expressionSegment).getExpression(), subqueryType);
        }
    }

    private static void extractSubquerySegmentsFromCaseWhenExpression(List<SubquerySegment> result, CaseWhenExpression expressionSegment, SubqueryType subqueryType) {
        SubqueryExtractUtils.extractSubquerySegmentsFromExpression(result, expressionSegment.getCaseExpr(), subqueryType);
        expressionSegment.getWhenExprs().forEach(each -> SubqueryExtractUtils.extractSubquerySegmentsFromExpression(result, each, subqueryType));
        expressionSegment.getThenExprs().forEach(each -> SubqueryExtractUtils.extractSubquerySegmentsFromExpression(result, each, subqueryType));
        SubqueryExtractUtils.extractSubquerySegmentsFromExpression(result, expressionSegment.getElseExpr(), subqueryType);
    }

    private static void extractSubquerySegmentsFromCombine(List<SubquerySegment> result, CombineSegment combineSegment) {
        result.add(combineSegment.getLeft());
        result.add(combineSegment.getRight());
        SubqueryExtractUtils.extractSubquerySegments(result, combineSegment.getLeft().getSelect());
        SubqueryExtractUtils.extractSubquerySegments(result, combineSegment.getRight().getSelect());
    }

    @Generated
    private SubqueryExtractUtils() {
    }
}

