/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.util.internal;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;

public abstract class PrivilegedUtils {
    private static final GetTCCLAction getTCCLAction = new GetTCCLAction();

    public static ClassLoader getTCCL() {
        return getTCCLAction.getTCCL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object executeWithCustomTCCL(final ClassLoader customClassLoader, UnprivilegedExecution execution) {
        Object object;
        final Thread currentThread = Thread.currentThread();
        ClassLoader oldTCCL = getTCCLAction.getTCCL();
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    currentThread.setContextClassLoader(customClassLoader);
                    return null;
                }
            });
            object = execution.run();
        }
        catch (Throwable throwable) {
            AccessController.doPrivileged(new PrivilegedAction(currentThread, oldTCCL){
                private final /* synthetic */ Thread val$currentThread;
                private final /* synthetic */ ClassLoader val$oldTCCL;
                {
                    this.val$currentThread = thread;
                    this.val$oldTCCL = classLoader;
                }

                public Object run() {
                    this.val$currentThread.setContextClassLoader(this.val$oldTCCL);
                    return null;
                }
            });
            throw throwable;
        }
        AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
        return object;
    }

    public static Object executeWithCustomTCCL(final ClassLoader customClassLoader, UnprivilegedThrowableExecution execution) throws Throwable {
        Object object;
        final Thread currentThread = Thread.currentThread();
        ClassLoader oldTCCL = getTCCLAction.getTCCL();
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    currentThread.setContextClassLoader(customClassLoader);
                    return null;
                }
            });
            object = execution.run();
        }
        catch (PrivilegedActionException pae) {
            try {
                throw pae.getCause();
            }
            catch (Throwable throwable) {
                AccessController.doPrivileged(new PrivilegedAction(currentThread, oldTCCL){
                    private final /* synthetic */ Thread val$currentThread;
                    private final /* synthetic */ ClassLoader val$oldTCCL;
                    {
                        this.val$currentThread = thread;
                        this.val$oldTCCL = classLoader;
                    }

                    public Object run() {
                        this.val$currentThread.setContextClassLoader(this.val$oldTCCL);
                        return null;
                    }
                });
                throw throwable;
            }
        }
        AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
        return object;
    }

    public static interface UnprivilegedExecution {
        public Object run();
    }

    public static interface UnprivilegedThrowableExecution {
        public Object run() throws Throwable;
    }

    private static class GetTCCLAction
    implements PrivilegedAction {
        private GetTCCLAction() {
        }

        public Object run() {
            return Thread.currentThread().getContextClassLoader();
        }

        public ClassLoader getTCCL() {
            return (ClassLoader)AccessController.doPrivileged(this);
        }
    }
}

