/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.util;

import java.util.Map;
import java.util.NoSuchElementException;
import org.iq80.leveldb.impl.SeekingIterator;

public abstract class AbstractSeekingIterator<K, V>
implements SeekingIterator<K, V> {
    private Map.Entry<K, V> nextElement;

    @Override
    public final void seekToFirst() {
        this.nextElement = null;
        this.seekToFirstInternal();
    }

    @Override
    public final void seek(K targetKey) {
        this.nextElement = null;
        this.seekInternal(targetKey);
    }

    @Override
    public final boolean hasNext() {
        if (this.nextElement == null) {
            this.nextElement = this.getNextElement();
        }
        return this.nextElement != null;
    }

    @Override
    public final Map.Entry<K, V> next() {
        if (this.nextElement == null) {
            this.nextElement = this.getNextElement();
            if (this.nextElement == null) {
                throw new NoSuchElementException();
            }
        }
        Map.Entry<K, V> result = this.nextElement;
        this.nextElement = null;
        return result;
    }

    @Override
    public final Map.Entry<K, V> peek() {
        if (this.nextElement == null) {
            this.nextElement = this.getNextElement();
            if (this.nextElement == null) {
                throw new NoSuchElementException();
            }
        }
        return this.nextElement;
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    protected abstract void seekToFirstInternal();

    protected abstract void seekInternal(K var1);

    protected abstract Map.Entry<K, V> getNextElement();
}

