/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletException;
import org.ops4j.pax.web.service.spi.model.ContainerInitializerModel;
import org.ops4j.pax.web.service.spi.model.ContextModel;
import org.ops4j.pax.web.service.spi.model.FilterModel;
import org.ops4j.pax.web.service.spi.model.Model;
import org.ops4j.pax.web.service.spi.model.ServletModel;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.NamespaceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerModel {
    private static final Logger LOG = LoggerFactory.getLogger(ServerModel.class);
    private final Map<String, ServletModel> aliasMapping = new HashMap<String, ServletModel>();
    private final Set<Servlet> servlets = new HashSet<Servlet>();
    private final Map<String, UrlPattern> servletUrlPatterns = new HashMap<String, UrlPattern>();
    private final ConcurrentMap<String, Set<UrlPattern>> filterUrlPatterns = new ConcurrentHashMap<String, Set<UrlPattern>>();
    private final ConcurrentMap<HttpContext, Bundle> httpContexts = new ConcurrentHashMap<HttpContext, Bundle>();
    private final ReentrantReadWriteLock servletLock;
    private final ReentrantReadWriteLock filterLock;
    private final ConcurrentMap<ServletContainerInitializer, ContainerInitializerModel> containerInitializers = new ConcurrentHashMap<ServletContainerInitializer, ContainerInitializerModel>();

    public ServerModel() {
        this.servletLock = new ReentrantReadWriteLock(true);
        this.filterLock = new ReentrantReadWriteLock(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServletModel(ServletModel model) throws NamespaceException, ServletException {
        this.servletLock.writeLock().lock();
        try {
            if (model.getServlet() != null && this.servlets.contains(model.getServlet())) {
                throw new ServletException("servlet already registered with a different alias");
            }
            if (model.getAlias() != null) {
                String alias = ServerModel.getFullPath(model.getContextModel(), model.getAlias());
                if (this.aliasMapping.containsKey(alias)) {
                    throw new NamespaceException("alias: '" + alias + "' is already in use in this or another context");
                }
                this.aliasMapping.put(alias, model);
            }
            if (model.getServlet() != null) {
                this.servlets.add(model.getServlet());
            }
            for (String urlPattern : model.getUrlPatterns()) {
                this.servletUrlPatterns.put(ServerModel.getFullPath(model.getContextModel(), urlPattern), new UrlPattern(ServerModel.getFullPath(model.getContextModel(), urlPattern), model));
            }
        }
        finally {
            this.servletLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServletModel(ServletModel model) {
        this.servletLock.writeLock().lock();
        try {
            if (model.getAlias() != null) {
                this.aliasMapping.remove(ServerModel.getFullPath(model.getContextModel(), model.getAlias()));
            }
            if (model.getServlet() != null) {
                this.servlets.remove(model.getServlet());
            }
            if (model.getUrlPatterns() != null) {
                for (String urlPattern : model.getUrlPatterns()) {
                    this.servletUrlPatterns.remove(ServerModel.getFullPath(model.getContextModel(), urlPattern));
                }
            }
        }
        finally {
            this.servletLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilterModel(FilterModel model) {
        if (model.getUrlPatterns() != null) {
            try {
                this.filterLock.writeLock().lock();
                for (String urlPattern : model.getUrlPatterns()) {
                    UrlPattern newUrlPattern = new UrlPattern(ServerModel.getFullPath(model.getContextModel(), urlPattern), model);
                    String fullPath = ServerModel.getFullPath(model.getContextModel(), urlPattern);
                    HashSet<UrlPattern> urlSet = (HashSet<UrlPattern>)this.filterUrlPatterns.get(fullPath);
                    if (urlSet == null) {
                        urlSet = new HashSet<UrlPattern>();
                    }
                    urlSet.add(newUrlPattern);
                    this.filterUrlPatterns.put(fullPath, urlSet);
                }
            }
            finally {
                this.filterLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFilterModel(FilterModel model) {
        if (model.getUrlPatterns() != null) {
            try {
                this.filterLock.writeLock().lock();
                for (String urlPattern : model.getUrlPatterns()) {
                    String fullPath = ServerModel.getFullPath(model.getContextModel(), urlPattern);
                    Set urlSet = (Set)this.filterUrlPatterns.get(fullPath);
                    UrlPattern toDelete = null;
                    for (UrlPattern pattern : urlSet) {
                        FilterModel filterModel = (FilterModel)pattern.getModel();
                        Class<? extends Filter> filter = filterModel.getFilterClass();
                        Class<? extends Filter> matchFilter = model.getFilterClass();
                        if (filter == null || !filter.equals(matchFilter)) continue;
                        toDelete = pattern;
                        break;
                    }
                    urlSet.remove(toDelete);
                }
            }
            finally {
                this.filterLock.writeLock().unlock();
            }
        }
    }

    public void addContainerInitializerModel(ContainerInitializerModel model) {
        if (this.containerInitializers.containsKey(model.getContainerInitializer())) {
            throw new IllegalArgumentException("ContainerInitializer Model already contains a container initializer of this: " + model.getContainerInitializer());
        }
        this.containerInitializers.put(model.getContainerInitializer(), model);
    }

    public void removeContainerInitializerModel(ContainerInitializerModel model) {
        this.containerInitializers.remove(model.getContainerInitializer());
    }

    public void associateHttpContext(HttpContext httpContext, Bundle bundle, boolean allowReAsssociation) {
        Bundle currentBundle = this.httpContexts.putIfAbsent(httpContext, bundle);
        if (!allowReAsssociation && currentBundle != null && currentBundle != bundle) {
            throw new IllegalStateException("Http context " + httpContext + " is already associated to bundle " + currentBundle);
        }
    }

    public HttpContext findDefaultHttpContextForBundle(Bundle bundle) {
        HttpContext httpContext = null;
        for (Map.Entry entry : this.httpContexts.entrySet()) {
            if (entry.getValue() != bundle) continue;
            httpContext = (HttpContext)entry.getKey();
            break;
        }
        return httpContext;
    }

    public void deassociateHttpContexts(Bundle bundle) {
        for (Map.Entry entry : this.httpContexts.entrySet()) {
            if (entry.getValue() != bundle) continue;
            this.httpContexts.remove(entry.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextModel matchPathToContext(String path) {
        boolean debug = LOG.isDebugEnabled();
        if (debug) {
            LOG.debug("Matching [" + path + "]...");
        }
        UrlPattern urlPattern = null;
        this.servletLock.readLock().lock();
        try {
            urlPattern = ServerModel.matchPathToContext(this.servletUrlPatterns, path);
        }
        finally {
            this.servletLock.readLock().unlock();
        }
        if (urlPattern == null) {
            urlPattern = ServerModel.matchFilterPathToContext(this.filterUrlPatterns, path);
        }
        ContextModel matched = null;
        if (urlPattern != null) {
            matched = urlPattern.getModel().getContextModel();
        }
        if (debug) {
            if (matched != null) {
                LOG.debug("Path [" + path + "] matched to " + urlPattern);
            } else {
                LOG.debug("Path [" + path + "] does not match any context");
            }
        }
        return matched;
    }

    private static UrlPattern matchFilterPathToContext(Map<String, Set<UrlPattern>> urlPatternsMap, String path) {
        Set<String> keySet = urlPatternsMap.keySet();
        for (String key : keySet) {
            Set<UrlPattern> patternsMap = urlPatternsMap.get(key);
            for (UrlPattern urlPattern : patternsMap) {
                HashMap<String, UrlPattern> tempMap = new HashMap<String, UrlPattern>();
                tempMap.put(key, urlPattern);
                UrlPattern pattern = ServerModel.matchPathToContext(tempMap, path);
                if (pattern == null) continue;
                return pattern;
            }
        }
        return null;
    }

    private static UrlPattern matchPathToContext(Map<String, UrlPattern> urlPatternsMap, String path) {
        UrlPattern matched = null;
        String servletPath = path;
        while (matched == null && !"".equals(servletPath)) {
            matched = servletPath.endsWith("/") ? urlPatternsMap.get(servletPath + "*") : urlPatternsMap.get(servletPath + "/*");
            if (matched == null) {
                matched = urlPatternsMap.get(servletPath);
            }
            if (matched != null) continue;
            String lastPathSegment = servletPath.substring(servletPath.lastIndexOf("/") + 1);
            if ("".equals(servletPath = servletPath.substring(0, servletPath.lastIndexOf("/"))) && "".equals(lastPathSegment)) break;
            if ("".equals(lastPathSegment)) {
                matched = urlPatternsMap.get(servletPath + "/*");
                continue;
            }
            if (lastPathSegment.contains(".")) {
                String extension = lastPathSegment.substring(lastPathSegment.lastIndexOf("."));
                if (extension.length() > 1 && matched == null) {
                    matched = urlPatternsMap.get(("".equals(servletPath) ? "*" : servletPath + "/*") + extension);
                }
            } else {
                matched = servletPath.endsWith("/") ? urlPatternsMap.get(servletPath + "*") : urlPatternsMap.get(servletPath + "/*");
            }
            if (matched == null) {
                matched = urlPatternsMap.get(servletPath);
            }
            if (matched != null || !"".equals(servletPath) || "".equals(lastPathSegment)) continue;
            matched = urlPatternsMap.get("/");
        }
        return matched;
    }

    private static String getFullPath(ContextModel model, String path) {
        String fullPath = path.trim();
        if (model.getContextName().length() > 0) {
            fullPath = "/" + model.getContextName();
            if (!"/".equals(path.trim())) {
                if (!fullPath.endsWith("/") && !path.startsWith("/")) {
                    fullPath = fullPath + "/";
                }
                fullPath = fullPath + path;
            }
        }
        return fullPath;
    }

    private static class UrlPattern {
        private final Pattern pattern;
        private final Model model;

        UrlPattern(String pattern, Model model) {
            this.model = model;
            String patternToUse = pattern;
            if (!patternToUse.contains("*")) {
                patternToUse = patternToUse + (pattern.endsWith("/") ? "*" : "/*");
            }
            patternToUse = patternToUse.replace(".", "\\.");
            patternToUse = patternToUse.replace("*", ".*");
            this.pattern = Pattern.compile(patternToUse);
        }

        Model getModel() {
            return this.model;
        }

        public String toString() {
            return "{" + "pattern=" + this.pattern.pattern() + ",model=" + this.model + "}";
        }
    }
}

