/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.blueprint.cm;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.aries.blueprint.ComponentDefinitionRegistry;
import org.apache.aries.blueprint.NamespaceHandler;
import org.apache.aries.blueprint.ParserContext;
import org.apache.aries.blueprint.mutable.MutableBeanMetadata;
import org.apache.aries.blueprint.mutable.MutableCollectionMetadata;
import org.apache.aries.blueprint.mutable.MutableComponentMetadata;
import org.apache.aries.blueprint.mutable.MutableIdRefMetadata;
import org.apache.aries.blueprint.mutable.MutableMapMetadata;
import org.apache.aries.blueprint.mutable.MutableRefMetadata;
import org.apache.aries.blueprint.mutable.MutableReferenceMetadata;
import org.apache.aries.blueprint.mutable.MutableValueMetadata;
import org.apache.xbean.blueprint.cm.JexlPropertyPlaceholder;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.osgi.service.blueprint.reflect.BeanProperty;
import org.osgi.service.blueprint.reflect.CollectionMetadata;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.IdRefMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.osgi.service.blueprint.reflect.NonNullMetadata;
import org.osgi.service.blueprint.reflect.RefMetadata;
import org.osgi.service.blueprint.reflect.ReferenceMetadata;
import org.osgi.service.blueprint.reflect.ValueMetadata;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmNamespaceHandler
implements NamespaceHandler {
    public static final String BLUEPRINT_NAMESPACE = "http://www.osgi.org/xmlns/blueprint/v1.0.0";
    public static final String XBEAN_CM_NAMESPACE = "http://xbean.apache.org/blueprint/xmlns/xbean-cm/v1.0.0";
    public static final String PROPERTY_PLACEHOLDER_ELEMENT = "property-placeholder";
    public static final String CM_PROPERTIES_ELEMENT = "cm-properties";
    public static final String DEFAULT_PROPERTIES_ELEMENT = "default-properties";
    public static final String PROPERTY_ELEMENT = "property";
    public static final String INTERFACES_ELEMENT = "interfaces";
    public static final String VALUE_ELEMENT = "value";
    public static final String MANAGED_COMPONENT_ELEMENT = "managed-component";
    public static final String ID_ATTRIBUTE = "id";
    public static final String PERSISTENT_ID_ATTRIBUTE = "persistent-id";
    public static final String PLACEHOLDER_PREFIX_ATTRIBUTE = "placeholder-prefix";
    public static final String PLACEHOLDER_SUFFIX_ATTRIBUTE = "placeholder-suffix";
    public static final String DEFAULTS_REF_ATTRIBUTE = "defaults-ref";
    public static final String UPDATE_STRATEGY_ATTRIBUTE = "update-strategy";
    public static final String UPDATE_METHOD_ATTRIBUTE = "update-method";
    public static final String FACTORY_PID_ATTRIBUTE = "factory-pid";
    public static final String AUTO_EXPORT_ATTRIBUTE = "auto-export";
    public static final String RANKING_ATTRIBUTE = "ranking";
    public static final String INTERFACE_ATTRIBUTE = "interface";
    public static final String UPDATE_ATTRIBUTE = "update";
    public static final String AUTO_EXPORT_DISABLED = "disabled";
    public static final String AUTO_EXPORT_INTERFACES = "interfaces";
    public static final String AUTO_EXPORT_CLASS_HIERARCHY = "class-hierarchy";
    public static final String AUTO_EXPORT_ALL = "all-classes";
    public static final String AUTO_EXPORT_DEFAULT = "disabled";
    public static final String RANKING_DEFAULT = "0";
    private static final String MANAGED_OBJECT_MANAGER_NAME = "org.apache.aries.managedObjectManager";
    private static final Logger LOGGER = LoggerFactory.getLogger(CmNamespaceHandler.class);
    private int idCounter;

    public URL getSchemaLocation(String namespace) {
        return this.getClass().getResource("xbean-cm.xsd");
    }

    public Set<Class> getManagedClasses() {
        return new HashSet<Class>(Arrays.asList(JexlPropertyPlaceholder.class));
    }

    public Metadata parse(Element element, ParserContext context) {
        LOGGER.debug("Parsing element {{}}{}", (Object)element.getNamespaceURI(), (Object)element.getLocalName());
        ComponentDefinitionRegistry registry = context.getComponentDefinitionRegistry();
        if (CmNamespaceHandler.nodeNameEquals(element, PROPERTY_PLACEHOLDER_ELEMENT)) {
            return this.parsePropertyPlaceholder(context, element);
        }
        throw new ComponentDefinitionException("Unsupported element: " + element.getNodeName());
    }

    public ComponentMetadata decorate(Node node, ComponentMetadata component, ParserContext context) {
        LOGGER.debug("Decorating node {{}}{}", (Object)node.getNamespaceURI(), (Object)node.getLocalName());
        ComponentDefinitionRegistry registry = context.getComponentDefinitionRegistry();
        if (node instanceof Element) {
            throw new ComponentDefinitionException("Unsupported element: " + node.getNodeName());
        }
        throw new ComponentDefinitionException("Illegal use of blueprint cm namespace");
    }

    private ComponentMetadata parsePropertyPlaceholder(ParserContext context, Element element) {
        String systemProperties;
        String ignoreMissingLocations;
        String defaultsRef;
        MutableBeanMetadata metadata = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        metadata.setProcessor(true);
        metadata.setId(this.getId(context, element));
        metadata.setScope("singleton");
        metadata.setRuntimeClass(JexlPropertyPlaceholder.class);
        metadata.addProperty("blueprintContainer", (Metadata)CmNamespaceHandler.createRef(context, "blueprintContainer"));
        metadata.addProperty("configAdmin", (Metadata)CmNamespaceHandler.createReference(context, ConfigurationAdmin.class.getName()));
        metadata.addProperty("persistentId", (Metadata)CmNamespaceHandler.createValue(context, element.getAttribute(PERSISTENT_ID_ATTRIBUTE)));
        String prefix = element.hasAttribute(PLACEHOLDER_PREFIX_ATTRIBUTE) ? element.getAttribute(PLACEHOLDER_PREFIX_ATTRIBUTE) : "${";
        metadata.addProperty("placeholderPrefix", (Metadata)CmNamespaceHandler.createValue(context, prefix));
        String suffix = element.hasAttribute(PLACEHOLDER_SUFFIX_ATTRIBUTE) ? element.getAttribute(PLACEHOLDER_SUFFIX_ATTRIBUTE) : "}";
        metadata.addProperty("placeholderSuffix", (Metadata)CmNamespaceHandler.createValue(context, suffix));
        String string = defaultsRef = element.hasAttribute(DEFAULTS_REF_ATTRIBUTE) ? element.getAttribute(DEFAULTS_REF_ATTRIBUTE) : null;
        if (defaultsRef != null) {
            metadata.addProperty("defaultProperties", (Metadata)CmNamespaceHandler.createRef(context, defaultsRef));
        }
        String string2 = ignoreMissingLocations = element.hasAttributeNS("http://aries.apache.org/blueprint/xmlns/blueprint-ext/v1.0.0", "ignore-missing-locations") ? element.getAttributeNS("http://aries.apache.org/blueprint/xmlns/blueprint-ext/v1.0.0", "ignore-missing-locations") : null;
        if (ignoreMissingLocations != null) {
            metadata.addProperty("ignoreMissingLocations", (Metadata)CmNamespaceHandler.createValue(context, ignoreMissingLocations));
        }
        String string3 = systemProperties = element.hasAttributeNS("http://aries.apache.org/blueprint/xmlns/blueprint-ext/v1.0.0", "system-properties") ? element.getAttributeNS("http://aries.apache.org/blueprint/xmlns/blueprint-ext/v1.0.0", "system-properties") : null;
        if (systemProperties == null) {
            systemProperties = "never";
        }
        metadata.addProperty("systemProperties", (Metadata)CmNamespaceHandler.createValue(context, systemProperties));
        ArrayList<String> locations = new ArrayList<String>();
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element e = (Element)node;
            if (XBEAN_CM_NAMESPACE.equals(e.getNamespaceURI())) {
                if (!CmNamespaceHandler.nodeNameEquals(e, DEFAULT_PROPERTIES_ELEMENT)) continue;
                if (defaultsRef != null) {
                    throw new ComponentDefinitionException("Only one of defaults-ref attribute or default-properties element is allowed");
                }
                Metadata props = this.parseDefaultProperties(context, metadata, e);
                metadata.addProperty("defaultProperties", props);
                continue;
            }
            if (!"http://aries.apache.org/blueprint/xmlns/blueprint-ext/v1.0.0".equals(e.getNamespaceURI()) || !CmNamespaceHandler.nodeNameEquals(e, "location")) continue;
            locations.add(CmNamespaceHandler.getTextValue(e));
        }
        if (!locations.isEmpty()) {
            metadata.addProperty("locations", (Metadata)CmNamespaceHandler.createList(context, locations));
        }
        return metadata;
    }

    private Metadata parseDefaultProperties(ParserContext context, MutableBeanMetadata enclosingComponent, Element element) {
        MutableMapMetadata props = (MutableMapMetadata)context.createMetadata(MutableMapMetadata.class);
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element e;
            Node node = nl.item(i);
            if (!(node instanceof Element) || !XBEAN_CM_NAMESPACE.equals((e = (Element)node).getNamespaceURI()) || !CmNamespaceHandler.nodeNameEquals(e, PROPERTY_ELEMENT)) continue;
            BeanProperty prop = (BeanProperty)context.parseElement(BeanProperty.class, (ComponentMetadata)enclosingComponent, e);
            props.addEntry((NonNullMetadata)CmNamespaceHandler.createValue(context, prop.getName(), String.class.getName()), prop.getValue());
        }
        return props;
    }

    private Metadata createConfigAdminProxy(ParserContext context) {
        MutableBeanMetadata bean = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        bean.setRuntimeClass(CmNamespaceHandler.class);
        bean.setFactoryMethod("getConfigAdmin");
        bean.setActivation(2);
        bean.setScope("prototype");
        return bean;
    }

    private static ValueMetadata createValue(ParserContext context, String value) {
        return CmNamespaceHandler.createValue(context, value, null);
    }

    private static ValueMetadata createValue(ParserContext context, String value, String type) {
        MutableValueMetadata m = (MutableValueMetadata)context.createMetadata(MutableValueMetadata.class);
        m.setStringValue(value);
        m.setType(type);
        return m;
    }

    private static RefMetadata createRef(ParserContext context, String value) {
        MutableRefMetadata m = (MutableRefMetadata)context.createMetadata(MutableRefMetadata.class);
        m.setComponentId(value);
        return m;
    }

    private static ReferenceMetadata createReference(ParserContext context, String interfaceName) {
        MutableReferenceMetadata m = (MutableReferenceMetadata)context.createMetadata(MutableReferenceMetadata.class);
        m.setInterface(interfaceName);
        return m;
    }

    private static IdRefMetadata createIdRef(ParserContext context, String value) {
        MutableIdRefMetadata m = (MutableIdRefMetadata)context.createMetadata(MutableIdRefMetadata.class);
        m.setComponentId(value);
        return m;
    }

    private static CollectionMetadata createList(ParserContext context, List<String> list) {
        MutableCollectionMetadata m = (MutableCollectionMetadata)context.createMetadata(MutableCollectionMetadata.class);
        m.setCollectionClass(List.class);
        m.setValueType(String.class.getName());
        for (String v : list) {
            m.addValue((Metadata)CmNamespaceHandler.createValue(context, v, String.class.getName()));
        }
        return m;
    }

    private static String getTextValue(Element element) {
        StringBuffer value = new StringBuffer();
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node item = nl.item(i);
            if ((!(item instanceof CharacterData) || item instanceof Comment) && !(item instanceof EntityReference)) continue;
            value.append(item.getNodeValue());
        }
        return value.toString();
    }

    private static boolean nodeNameEquals(Node node, String name) {
        return name.equals(node.getNodeName()) || name.equals(node.getLocalName());
    }

    public static boolean isBlueprintNamespace(String ns) {
        return BLUEPRINT_NAMESPACE.equals(ns);
    }

    public String getId(ParserContext context, Element element) {
        if (element.hasAttribute(ID_ATTRIBUTE)) {
            return element.getAttribute(ID_ATTRIBUTE);
        }
        return this.generateId(context);
    }

    public void generateIdIfNeeded(ParserContext context, MutableComponentMetadata metadata) {
        if (metadata.getId() == null) {
            metadata.setId(this.generateId(context));
        }
    }

    private String generateId(ParserContext context) {
        String id;
        do {
            id = ".cm-" + ++this.idCounter;
        } while (context.getComponentDefinitionRegistry().containsComponentDefinition(id));
        return id;
    }

    public List<String> parseInterfaceNames(Element element) {
        ArrayList<String> interfaceNames = new ArrayList<String>();
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element e = (Element)node;
            if (CmNamespaceHandler.nodeNameEquals(e, VALUE_ELEMENT)) {
                String v = CmNamespaceHandler.getTextValue(e).trim();
                if (interfaceNames.contains(v)) {
                    throw new ComponentDefinitionException("The element interfaces should not contain the same interface twice");
                }
                interfaceNames.add(CmNamespaceHandler.getTextValue(e));
                continue;
            }
            throw new ComponentDefinitionException("Unsupported element " + e.getNodeName() + " inside an " + "interfaces" + " element");
        }
        return interfaceNames;
    }
}

