/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.diagnostic.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.util.Dictionary;
import java.util.Enumeration;
import org.apache.karaf.diagnostic.core.DumpDestination;
import org.apache.karaf.diagnostic.core.DumpProvider;
import org.apache.karaf.util.StreamUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class LogDumpProvider
implements DumpProvider {
    private final BundleContext bundleContext;

    public LogDumpProvider(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void createDump(DumpDestination destination) throws Exception {
        ServiceReference ref = this.bundleContext.getServiceReference(ConfigurationAdmin.class.getName());
        if (ref == null) {
            return;
        }
        ConfigurationAdmin configurationAdmin = (ConfigurationAdmin)this.bundleContext.getService(ref);
        try {
            Configuration configuration = configurationAdmin.getConfiguration("org.ops4j.pax.logging", null);
            Dictionary dictionary = configuration.getProperties();
            Enumeration e = dictionary.keys();
            while (e.hasMoreElements()) {
                String location;
                File file;
                String property = (String)e.nextElement();
                if (!property.endsWith(".file") || !(file = new File(location = (String)dictionary.get(property))).exists()) continue;
                FileInputStream inputStream = new FileInputStream(file);
                OutputStream outputStream = destination.add("log/" + file.getName());
                StreamUtils.copy(inputStream, outputStream);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.bundleContext.ungetService(ref);
        }
    }
}

