/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.RevWalkUtils;

public class ListBranchCommand
extends GitCommand<List<Ref>> {
    private ListMode listMode;
    private String containsCommitish;

    protected ListBranchCommand(Repository repo) {
        super(repo);
    }

    @Override
    public List<Ref> call() throws GitAPIException {
        ArrayList<Ref> resultRefs;
        this.checkCallable();
        try {
            ArrayList<Ref> refs = new ArrayList<Ref>();
            Ref head = this.repo.exactRef("HEAD");
            if (head != null && head.getLeaf().getName().equals("HEAD")) {
                refs.add(head);
            }
            if (this.listMode == null) {
                refs.addAll(this.repo.getRefDatabase().getRefsByPrefix("refs/heads/"));
            } else if (this.listMode == ListMode.REMOTE) {
                refs.addAll(this.repo.getRefDatabase().getRefsByPrefix("refs/remotes/"));
            } else {
                refs.addAll(this.repo.getRefDatabase().getRefsByPrefix("refs/heads/", "refs/remotes/"));
            }
            resultRefs = new ArrayList<Ref>(this.filterRefs(refs));
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        Collections.sort(resultRefs, new Comparator<Ref>(){

            @Override
            public int compare(Ref o1, Ref o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        this.setCallable(false);
        return resultRefs;
    }

    private Collection<Ref> filterRefs(Collection<Ref> refs) throws RefNotFoundException, IOException {
        if (this.containsCommitish == null) {
            return refs;
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (RevWalk walk = new RevWalk(this.repo);){
            ObjectId resolved = this.repo.resolve(this.containsCommitish);
            if (resolved == null) {
                throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, this.containsCommitish));
            }
            RevCommit containsCommit = walk.parseCommit(resolved);
            return RevWalkUtils.findBranchesReachableFrom(containsCommit, walk, refs);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public ListBranchCommand setListMode(ListMode listMode) {
        this.checkCallable();
        this.listMode = listMode;
        return this;
    }

    public ListBranchCommand setContains(String containsCommitish) {
        this.checkCallable();
        this.containsCommitish = containsCommitish;
        return this;
    }

    public static enum ListMode {
        ALL,
        REMOTE;

    }
}

