/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.core.processor.response;

import io.swagger.converter.ModelConverters;
import io.swagger.models.Model;
import io.swagger.models.properties.Property;
import io.swagger.models.utils.PropertyModelConverter;
import io.swagger.util.ReflectionUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.servicecomb.swagger.generator.core.OperationGenerator;
import org.apache.servicecomb.swagger.generator.core.ResponseTypeProcessor;
import org.apache.servicecomb.swagger.generator.core.utils.ParamUtils;

public class DefaultResponseTypeProcessor
implements ResponseTypeProcessor {
    @Override
    public Class<?> getResponseType() {
        return null;
    }

    @Override
    public Model process(OperationGenerator operationGenerator, Type genericResponseType) {
        ResponseTypeProcessor processor;
        Type responseType;
        if (!(genericResponseType instanceof ParameterizedType)) {
            return this.doProcess(operationGenerator, genericResponseType);
        }
        Type responseRawType = responseType = ((ParameterizedType)genericResponseType).getActualTypeArguments()[0];
        if (responseType instanceof ParameterizedType) {
            responseRawType = ((ParameterizedType)responseType).getRawType();
        }
        if (responseRawType.equals((processor = operationGenerator.getContext().findResponseTypeProcessor(responseRawType)).getResponseType())) {
            return processor.process(operationGenerator, responseType);
        }
        return this.doProcess(operationGenerator, genericResponseType);
    }

    protected Model doProcess(OperationGenerator operationGenerator, Type responseType) {
        if (ReflectionUtils.isVoid((Type)responseType)) {
            return null;
        }
        ParamUtils.addDefinitions(operationGenerator.getSwagger(), responseType);
        Property property = ModelConverters.getInstance().readAsProperty(responseType);
        return new PropertyModelConverter().propertyToModel(property);
    }
}

