/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch.diff;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.github.fge.jackson.JacksonUtils;
import com.google.common.base.Preconditions;
import java.util.List;

final class IndexedJsonArray {
    private final int size;
    private final JsonNode node;
    private int index = 0;

    IndexedJsonArray(JsonNode node) {
        Preconditions.checkArgument((boolean)node.isArray(), (Object)"Class only applies to JSON arrays");
        this.node = node;
        this.size = node.size();
    }

    IndexedJsonArray(List<JsonNode> list) {
        ArrayNode arrayNode = JacksonUtils.nodeFactory().arrayNode();
        arrayNode.addAll(list);
        this.node = arrayNode;
        this.size = arrayNode.size();
    }

    int getIndex() {
        return this.isEmpty() ? -1 : this.index;
    }

    void shift() {
        ++this.index;
    }

    JsonNode getElement() {
        return this.node.get(this.index);
    }

    boolean isEmpty() {
        return this.index >= this.size;
    }
}

