/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.generator.annotation;

import org.apache.servicecomb.toolkit.generator.annotation.ClassAnnotationProcessor;
import org.apache.servicecomb.toolkit.generator.context.OasContext;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public class RequestMappingClassAnnotationProcessor
implements ClassAnnotationProcessor<RequestMapping, OasContext> {
    public void process(RequestMapping requestMapping, OasContext oasContext) {
        String[] paths = requestMapping.value();
        if (null == paths || paths.length == 0) {
            return;
        }
        if (paths.length > 1) {
            throw new Error("not support multi path for " + oasContext.getCls().getName());
        }
        oasContext.setBasePath(paths[0]);
        this.processMethod(requestMapping.method(), oasContext);
        this.processConsumes(requestMapping.consumes(), oasContext);
        this.processProduces(requestMapping.produces(), oasContext);
        this.processHeaders(requestMapping.headers(), oasContext);
    }

    protected void processMethod(RequestMethod[] requestMethods, OasContext oasContext) {
        if (null == requestMethods || requestMethods.length == 0) {
            return;
        }
        if (requestMethods.length > 1) {
            throw new Error("not allowed multi http method for " + oasContext.getCls().getName());
        }
        oasContext.setHttpMethod(requestMethods[0].name());
    }

    protected void processConsumes(String[] consumes, OasContext oasContext) {
        if (null == consumes || consumes.length == 0) {
            return;
        }
        oasContext.setConsumers(consumes);
    }

    protected void processProduces(String[] produces, OasContext oasContext) {
        if (null == produces || produces.length == 0) {
            return;
        }
        oasContext.setProduces(produces);
    }

    protected void processHeaders(String[] headers, OasContext oasContext) {
        if (null == headers || headers.length == 0) {
            return;
        }
        oasContext.setHeaders(headers);
    }
}

