/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.tracing.zipkin;

import brave.http.HttpServerRequest;
import com.netflix.config.DynamicPropertyFactory;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.tracing.zipkin.TracingConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpServeRequestWrapper
extends HttpServerRequest {
    private static final Logger LOG = LoggerFactory.getLogger(HttpServeRequestWrapper.class);
    private Invocation invocation;

    HttpServeRequestWrapper() {
    }

    HttpServeRequestWrapper(Invocation invocation) {
        this.invocation = invocation;
    }

    HttpServeRequestWrapper invocation(Invocation invocation) {
        this.invocation = invocation;
        return this;
    }

    public String method() {
        return this.invocation.getOperationMeta().getHttpMethod();
    }

    public String path() {
        if (DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.tracing.workWithThirdParty", false).get()) {
            try {
                return TracingConfiguration.createRequestPath(this.invocation);
            }
            catch (Exception e) {
                LOG.warn("generate rest path failed: {}", (Object)e.getMessage());
            }
        }
        return this.invocation.getOperationMeta().getOperationPath();
    }

    public String url() {
        return this.invocation.getEndpoint().getEndpoint();
    }

    public String header(String key) {
        return (String)this.invocation.getContext().get(key);
    }

    public Object unwrap() {
        return this.invocation;
    }
}

