/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.context.properties;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.context.properties.ConfigurationBeanFactoryMetaData;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.scope.refresh.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

@Component
public class ConfigurationPropertiesBeans
implements BeanPostProcessor,
ApplicationContextAware {
    private ConfigurationBeanFactoryMetaData metaData;
    private Map<String, Object> beans = new HashMap<String, Object>();
    private ConfigurableListableBeanFactory beanFactory;
    private String refreshScope;
    private boolean refreshScopeInitialized;
    private ConfigurationPropertiesBeans parent;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ConfigurableListableBeanFactory listable;
        String[] names;
        if (applicationContext.getAutowireCapableBeanFactory() instanceof ConfigurableListableBeanFactory) {
            this.beanFactory = (ConfigurableListableBeanFactory)applicationContext.getAutowireCapableBeanFactory();
        }
        if (applicationContext.getParent() != null && applicationContext.getParent().getAutowireCapableBeanFactory() instanceof ConfigurableListableBeanFactory && (names = (listable = (ConfigurableListableBeanFactory)applicationContext.getParent().getAutowireCapableBeanFactory()).getBeanNamesForType(ConfigurationPropertiesBeans.class)).length == 1) {
            this.parent = (ConfigurationPropertiesBeans)listable.getBean(names[0]);
            this.beans.putAll(this.parent.beans);
        }
    }

    public void setBeanMetaDataStore(ConfigurationBeanFactoryMetaData beans) {
        this.metaData = beans;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (this.isRefreshScoped(beanName)) {
            return bean;
        }
        ConfigurationProperties annotation = (ConfigurationProperties)AnnotationUtils.findAnnotation(bean.getClass(), ConfigurationProperties.class);
        if (annotation != null) {
            this.beans.put(beanName, bean);
        } else if (this.metaData != null && (annotation = (ConfigurationProperties)this.metaData.findFactoryAnnotation(beanName, ConfigurationProperties.class)) != null) {
            this.beans.put(beanName, bean);
        }
        return bean;
    }

    private boolean isRefreshScoped(String beanName) {
        if (this.refreshScope == null && !this.refreshScopeInitialized) {
            this.refreshScopeInitialized = true;
            for (String scope : this.beanFactory.getRegisteredScopeNames()) {
                if (!(this.beanFactory.getRegisteredScope(scope) instanceof RefreshScope)) continue;
                this.refreshScope = scope;
                break;
            }
        }
        if (beanName == null || this.refreshScope == null) {
            return false;
        }
        return this.beanFactory.containsBeanDefinition(beanName) && this.refreshScope.equals(this.beanFactory.getBeanDefinition(beanName).getScope());
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Set<String> getBeanNames() {
        return new HashSet<String>(this.beans.keySet());
    }
}

