/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon.proxy;

import com.netflix.ribbon.proxy.RibbonProxyException;
import java.lang.reflect.Method;

public final class Utils {
    private Utils() {
    }

    public static <T> Method methodByName(Class<T> aClass, String name) {
        for (Method m : aClass.getMethods()) {
            if (!m.getName().equals(name)) continue;
            return m;
        }
        return null;
    }

    public static Object executeOnInstance(Object object, Method method, Object[] args) {
        Method targetMethod = Utils.methodByName(object.getClass(), method.getName());
        if (targetMethod == null) {
            throw new IllegalArgumentException(String.format("Signature of method %s is not compatible with the object %s", method.getName(), object.getClass().getSimpleName()));
        }
        try {
            return targetMethod.invoke(object, args);
        }
        catch (Exception ex) {
            throw new RibbonProxyException(String.format("Failed to execute method %s on object %s", method.getName(), object.getClass().getSimpleName()), ex);
        }
    }

    public static <T> T newInstance(Class<T> aClass) {
        try {
            return aClass.newInstance();
        }
        catch (Exception e) {
            throw new RibbonProxyException("Cannot instantiate object from class " + aClass, e);
        }
    }
}

