/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon.http;

import com.netflix.hystrix.HystrixInvokableInfo;
import com.netflix.hystrix.HystrixObservableCommand;
import com.netflix.ribbon.RequestWithMetaData;
import com.netflix.ribbon.RibbonResponse;
import com.netflix.ribbon.http.HttpMetaResponse;
import com.netflix.ribbon.http.HttpRequest;
import com.netflix.ribbon.hystrix.HystrixObservableCommandChain;
import com.netflix.ribbon.hystrix.ResultCommandPair;
import io.netty.buffer.ByteBuf;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.Notification;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.functions.Action1;
import rx.functions.Func1;
import rx.subjects.ReplaySubject;
import rx.subjects.Subject;

class HttpMetaRequest<T>
implements RequestWithMetaData<T> {
    private final HttpRequest<T> request;

    HttpMetaRequest(HttpRequest<T> request) {
        this.request = request;
    }

    @Override
    public Observable<RibbonResponse<Observable<T>>> toObservable() {
        HystrixObservableCommandChain<T> commandChain = this.request.createHystrixCommandChain();
        return this.convertToRibbonResponse(commandChain, commandChain.toResultCommandPairObservable());
    }

    @Override
    public Observable<RibbonResponse<Observable<T>>> observe() {
        HystrixObservableCommandChain<T> commandChain = this.request.createHystrixCommandChain();
        Observable<ResultCommandPair<T>> notificationObservable = commandChain.toResultCommandPairObservable();
        notificationObservable = this.retainBufferIfNeeded(notificationObservable);
        ReplaySubject subject = ReplaySubject.create();
        notificationObservable.subscribe((Observer)subject);
        return this.convertToRibbonResponse(commandChain, (Observable<ResultCommandPair<T>>)subject);
    }

    @Override
    public Future<RibbonResponse<T>> queue() {
        Observable<ResultCommandPair<T>> resultObservable = this.request.createHystrixCommandChain().toResultCommandPairObservable();
        resultObservable = this.retainBufferIfNeeded(resultObservable);
        final Future f = resultObservable.toBlocking().toFuture();
        return new Future<RibbonResponse<T>>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return f.cancel(mayInterruptIfRunning);
            }

            @Override
            public RibbonResponse<T> get() throws InterruptedException, ExecutionException {
                ResultCommandPair pair = (ResultCommandPair)f.get();
                return new HttpMetaResponse(pair.getResult(), (HystrixInvokableInfo<?>)pair.getCommand());
            }

            @Override
            public RibbonResponse<T> get(long timeout, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
                ResultCommandPair pair = (ResultCommandPair)f.get(timeout, timeUnit);
                return new HttpMetaResponse(pair.getResult(), (HystrixInvokableInfo<?>)pair.getCommand());
            }

            @Override
            public boolean isCancelled() {
                return f.isCancelled();
            }

            @Override
            public boolean isDone() {
                return f.isDone();
            }
        };
    }

    @Override
    public RibbonResponse<T> execute() {
        RibbonResponse response = (RibbonResponse)this.observe().toBlocking().last();
        return new HttpMetaResponse<Object>(((Observable)response.content()).toBlocking().last(), response.getHystrixInfo());
    }

    private Observable<ResultCommandPair<T>> retainBufferIfNeeded(Observable<ResultCommandPair<T>> resultObservable) {
        if (this.request.isByteBufResponse()) {
            resultObservable = resultObservable.map(new Func1<ResultCommandPair<T>, ResultCommandPair<T>>(){

                public ResultCommandPair<T> call(ResultCommandPair<T> pair) {
                    ((ByteBuf)pair.getResult()).retain();
                    return pair;
                }
            });
        }
        return resultObservable;
    }

    private Observable<RibbonResponse<Observable<T>>> convertToRibbonResponse(final HystrixObservableCommandChain<T> commandChain, final Observable<ResultCommandPair<T>> hystrixNotificationObservable) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<RibbonResponse<Observable<T>>>(){

            public void call(final Subscriber<? super RibbonResponse<Observable<T>>> t1) {
                ReplaySubject subject = ReplaySubject.create();
                hystrixNotificationObservable.materialize().subscribe(new Action1<Notification<ResultCommandPair<T>>>((Subject)subject){
                    AtomicBoolean first = new AtomicBoolean(true);
                    final /* synthetic */ Subject val$subject;
                    {
                        this.val$subject = subject;
                    }

                    public void call(Notification<ResultCommandPair<T>> notification) {
                        if (this.first.compareAndSet(true, false)) {
                            HystrixObservableCommand command = notification.isOnError() ? commandChain.getLastCommand() : ((ResultCommandPair)notification.getValue()).getCommand();
                            t1.onNext(new ResponseWithSubject(this.val$subject, (HystrixInvokableInfo<?>)command));
                            t1.onCompleted();
                        }
                        if (notification.isOnNext()) {
                            this.val$subject.onNext(((ResultCommandPair)notification.getValue()).getResult());
                        } else if (notification.isOnCompleted()) {
                            this.val$subject.onCompleted();
                        } else {
                            this.val$subject.onError(notification.getThrowable());
                        }
                    }
                });
            }
        });
    }

    private static class ResponseWithSubject<T>
    extends RibbonResponse<Observable<T>> {
        Subject<T, T> subject;
        HystrixInvokableInfo<?> info;

        public ResponseWithSubject(Subject<T, T> subject, HystrixInvokableInfo<?> info) {
            this.subject = subject;
            this.info = info;
        }

        @Override
        public Observable<T> content() {
            return this.subject;
        }

        @Override
        public HystrixInvokableInfo<?> getHystrixInfo() {
            return this.info;
        }
    }
}

