/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.core.utils;

import com.fasterxml.jackson.databind.JavaType;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.lang.model.SourceVersion;
import org.apache.servicecomb.common.javassist.ClassConfig;
import org.apache.servicecomb.common.javassist.JavassistUtils;
import org.apache.servicecomb.foundation.common.utils.ReflectUtils;
import org.apache.servicecomb.swagger.converter.ConverterMgr;
import org.apache.servicecomb.swagger.converter.SwaggerToClassGenerator;
import org.apache.servicecomb.swagger.generator.core.OperationGenerator;
import org.apache.servicecomb.swagger.generator.core.SwaggerGenerator;
import org.apache.servicecomb.swagger.generator.core.utils.ParamUtils;
import org.springframework.util.StringUtils;

public final class ClassUtils {
    private ClassUtils() {
    }

    public static Class<?> getClassByName(ClassLoader classLoader, String clsName) {
        return ReflectUtils.getClassByName((ClassLoader)classLoader, (String)clsName);
    }

    public static Class<?> getOrCreateBodyClass(OperationGenerator operationGenerator, List<BodyParameter> bodyParameters) {
        SwaggerGenerator swaggerGenerator = operationGenerator.getSwaggerGenerator();
        Method method = operationGenerator.getProviderMethod();
        String clsName = swaggerGenerator.ensureGetPackageName() + "." + ParamUtils.generateBodyParameterName(method);
        Class<?> cls = ClassUtils.getClassByName(swaggerGenerator.getClassLoader(), clsName);
        if (cls != null) {
            return cls;
        }
        ClassConfig classConfig = new ClassConfig();
        classConfig.setClassName(clsName);
        SwaggerToClassGenerator classGenerator = new SwaggerToClassGenerator(swaggerGenerator.getClassLoader(), swaggerGenerator.getSwagger(), swaggerGenerator.ensureGetPackageName());
        for (BodyParameter bp : bodyParameters) {
            JavaType javaType = ConverterMgr.findJavaType(classGenerator, bp);
            classConfig.addField(bp.getName(), javaType);
        }
        return JavassistUtils.createClass((ClassLoader)swaggerGenerator.getClassLoader(), (ClassConfig)classConfig);
    }

    public static boolean hasAnnotation(Class<?> cls, Class<? extends Annotation> annotation) {
        if (cls.getAnnotation(annotation) != null) {
            return true;
        }
        for (Method method : cls.getMethods()) {
            if (method.getAnnotation(annotation) == null) continue;
            return true;
        }
        return false;
    }

    public static boolean isRawJsonType(Parameter param) {
        Object rawJson = param.getVendorExtensions().get("x-raw-json");
        if (Boolean.class.isInstance(rawJson)) {
            return (Boolean)rawJson;
        }
        return false;
    }

    public static String getClassName(Map<String, Object> vendorExtensions) {
        return (String)ClassUtils.getVendorExtension(vendorExtensions, "x-java-class");
    }

    public static String getInterfaceName(Map<String, Object> vendorExtensions) {
        return (String)ClassUtils.getVendorExtension(vendorExtensions, "x-java-interface");
    }

    public static String getRawClassName(String canonical) {
        if (StringUtils.isEmpty((Object)canonical)) {
            return null;
        }
        int idx = canonical.indexOf("<");
        if (idx == 0) {
            throw new IllegalStateException("Invalid class canonical: " + canonical);
        }
        if (idx < 0) {
            return canonical;
        }
        return canonical.substring(0, idx);
    }

    public static <T> T getVendorExtension(Map<String, Object> vendorExtensions, String key) {
        if (vendorExtensions == null) {
            return null;
        }
        return (T)vendorExtensions.get(key);
    }

    public static String correctMethodParameterName(String paramName) {
        if (SourceVersion.isName(paramName)) {
            return paramName;
        }
        StringBuilder newParam = new StringBuilder();
        for (int index = 0; index < paramName.length(); ++index) {
            char tempChar = paramName.charAt(index);
            if (Character.isJavaIdentifierPart(tempChar)) {
                newParam.append(paramName.charAt(index));
                continue;
            }
            if (tempChar != '.' && tempChar != '-') continue;
            newParam.append('_');
        }
        return newParam.toString();
    }

    public static String correctClassName(String name) {
        if (SourceVersion.isIdentifier(name) && !SourceVersion.isKeyword(name)) {
            return name;
        }
        CharSequence[] parts = name.split("\\.", -1);
        for (int idx = 0; idx < parts.length; ++idx) {
            String part = parts[idx];
            if (part.isEmpty()) {
                parts[idx] = "_";
                continue;
            }
            if (Character.isDigit((part = part.replaceAll("[,;<>-]", "_").replace("[", "array_")).charAt(0)) || SourceVersion.isKeyword(part)) {
                part = "_" + part;
            }
            parts[idx] = part;
        }
        return String.join((CharSequence)".", parts);
    }
}

