/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon.apache;

import com.netflix.client.AbstractLoadBalancerAwareClient;
import com.netflix.client.RetryHandler;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.DefaultClientConfigImpl;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.servo.monitor.Monitors;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.loadbalancer.LoadBalancedBackOffPolicyFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryListenerFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryPolicyFactory;
import org.springframework.cloud.commons.httpclient.ApacheHttpClientConnectionManagerFactory;
import org.springframework.cloud.commons.httpclient.ApacheHttpClientFactory;
import org.springframework.cloud.netflix.ribbon.ServerIntrospector;
import org.springframework.cloud.netflix.ribbon.apache.RetryableRibbonLoadBalancingHttpClient;
import org.springframework.cloud.netflix.ribbon.apache.RibbonLoadBalancingHttpClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(name={"org.apache.http.client.HttpClient"})
@ConditionalOnProperty(name={"ribbon.httpclient.enabled"}, matchIfMissing=true)
public class HttpClientRibbonConfiguration {
    @Value(value="${ribbon.client.name}")
    private String name = "client";

    @Bean
    @ConditionalOnMissingBean(value={AbstractLoadBalancerAwareClient.class})
    @ConditionalOnMissingClass(value={"org.springframework.retry.support.RetryTemplate"})
    public RibbonLoadBalancingHttpClient ribbonLoadBalancingHttpClient(IClientConfig config, ServerIntrospector serverIntrospector, ILoadBalancer loadBalancer, RetryHandler retryHandler, CloseableHttpClient httpClient) {
        RibbonLoadBalancingHttpClient client = new RibbonLoadBalancingHttpClient(httpClient, config, serverIntrospector);
        client.setLoadBalancer(loadBalancer);
        client.setRetryHandler(retryHandler);
        Monitors.registerObject((String)("Client_" + this.name), (Object)((Object)client));
        return client;
    }

    @Bean
    @ConditionalOnMissingBean(value={AbstractLoadBalancerAwareClient.class})
    @ConditionalOnClass(name={"org.springframework.retry.support.RetryTemplate"})
    public RetryableRibbonLoadBalancingHttpClient retryableRibbonLoadBalancingHttpClient(IClientConfig config, ServerIntrospector serverIntrospector, ILoadBalancer loadBalancer, RetryHandler retryHandler, LoadBalancedRetryPolicyFactory loadBalancedRetryPolicyFactory, CloseableHttpClient httpClient, LoadBalancedBackOffPolicyFactory loadBalancedBackOffPolicyFactory, LoadBalancedRetryListenerFactory loadBalancedRetryListenerFactory) {
        RetryableRibbonLoadBalancingHttpClient client = new RetryableRibbonLoadBalancingHttpClient(httpClient, config, serverIntrospector, loadBalancedRetryPolicyFactory, loadBalancedBackOffPolicyFactory, loadBalancedRetryListenerFactory);
        client.setLoadBalancer(loadBalancer);
        client.setRetryHandler(retryHandler);
        Monitors.registerObject((String)("Client_" + this.name), (Object)((Object)client));
        return client;
    }

    @Configuration
    protected static class ApacheHttpClientConfiguration {
        private final Timer connectionManagerTimer = new Timer("RibbonApacheHttpClientConfiguration.connectionManagerTimer", true);
        private CloseableHttpClient httpClient;
        @Autowired(required=false)
        private RegistryBuilder registryBuilder;

        protected ApacheHttpClientConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={HttpClientConnectionManager.class})
        public HttpClientConnectionManager httpClientConnectionManager(IClientConfig config, ApacheHttpClientConnectionManagerFactory connectionManagerFactory) {
            Integer maxTotalConnections = config.getPropertyAsInteger(CommonClientConfigKey.MaxTotalConnections, 200);
            Integer maxConnectionsPerHost = config.getPropertyAsInteger(CommonClientConfigKey.MaxConnectionsPerHost, 50);
            Integer timerRepeat = config.getPropertyAsInteger(CommonClientConfigKey.ConnectionCleanerRepeatInterval, 30000);
            Object timeToLiveObj = config.getProperty(CommonClientConfigKey.PoolKeepAliveTime);
            Long timeToLive = 900L;
            Object ttlUnitObj = config.getProperty(CommonClientConfigKey.PoolKeepAliveTimeUnits);
            TimeUnit ttlUnit = DefaultClientConfigImpl.DEFAULT_POOL_KEEP_ALIVE_TIME_UNITS;
            if (timeToLiveObj instanceof Long) {
                timeToLive = (Long)timeToLiveObj;
            }
            if (ttlUnitObj instanceof TimeUnit) {
                ttlUnit = (TimeUnit)((Object)ttlUnitObj);
            }
            final HttpClientConnectionManager connectionManager = connectionManagerFactory.newConnectionManager(false, maxTotalConnections.intValue(), maxConnectionsPerHost.intValue(), timeToLive.longValue(), ttlUnit, this.registryBuilder);
            this.connectionManagerTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    connectionManager.closeExpiredConnections();
                }
            }, 30000L, (long)timerRepeat.intValue());
            return connectionManager;
        }

        @Bean
        @ConditionalOnMissingBean(value={CloseableHttpClient.class})
        public CloseableHttpClient httpClient(ApacheHttpClientFactory httpClientFactory, HttpClientConnectionManager connectionManager, IClientConfig config) {
            Boolean followRedirects = config.getPropertyAsBoolean(CommonClientConfigKey.FollowRedirects, DefaultClientConfigImpl.DEFAULT_FOLLOW_REDIRECTS.booleanValue());
            Integer connectTimeout = config.getPropertyAsInteger(CommonClientConfigKey.ConnectTimeout, 2000);
            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(connectTimeout.intValue()).setRedirectsEnabled(followRedirects.booleanValue()).build();
            this.httpClient = httpClientFactory.createBuilder().setDefaultRequestConfig(defaultRequestConfig).setConnectionManager(connectionManager).build();
            return this.httpClient;
        }

        @PreDestroy
        public void destroy() throws Exception {
            this.connectionManagerTimer.cancel();
            if (this.httpClient != null) {
                this.httpClient.close();
            }
        }
    }
}

