/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.model;

import com.google.common.base.MoreObjects;
import io.protostuff.compiler.model.AbstractUserTypeContainer;
import io.protostuff.compiler.model.DescriptorType;
import io.protostuff.compiler.model.Import;
import io.protostuff.compiler.model.Module;
import io.protostuff.compiler.model.Package;
import io.protostuff.compiler.model.Service;
import io.protostuff.compiler.model.Syntax;
import io.protostuff.compiler.model.UserTypeContainer;
import io.protostuff.compiler.parser.ProtoContext;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Proto
extends AbstractUserTypeContainer
implements UserTypeContainer {
    protected Module module;
    protected ProtoContext context;
    protected String filename;
    protected Syntax syntax = Syntax.DEFAULT;
    protected Package pkg = Package.DEFAULT;
    protected List<Import> imports = new ArrayList<Import>();
    protected List<Service> services = new ArrayList<Service>();

    public Proto() {
        super(null);
    }

    public ProtoContext getContext() {
        return this.context;
    }

    public void setContext(ProtoContext context) {
        this.context = context;
    }

    @Override
    public DescriptorType getDescriptorType() {
        return DescriptorType.PROTO;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public Syntax getSyntax() {
        return this.syntax;
    }

    public void setSyntax(Syntax syntax) {
        this.syntax = syntax;
    }

    public Package getPackage() {
        return this.pkg;
    }

    public void setPackage(Package pkg) {
        this.pkg = pkg;
    }

    public List<Import> getImports() {
        return this.imports;
    }

    public void setImports(List<Import> imports) {
        this.imports = imports;
    }

    public List<Import> getPublicImports() {
        return this.getImports().stream().filter(Import::isPublic).collect(Collectors.toList());
    }

    public void addImport(Import anImport) {
        this.imports.add(anImport);
    }

    public List<Service> getServices() {
        return this.services;
    }

    public void setServices(List<Service> services) {
        this.services = services;
    }

    public void addService(Service service) {
        this.services.add(service);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("filename", (Object)this.filename).toString();
    }

    @Override
    public String getNamespace() {
        if (this.pkg == null) {
            return ".";
        }
        return "." + this.pkg.getValue() + ".";
    }

    public String getCanonicalName() {
        if (this.pkg == null) {
            return this.name;
        }
        return this.pkg + "." + this.name;
    }

    public Module getModule() {
        return this.module;
    }

    public void setModule(Module module) {
        this.module = module;
    }
}

