/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.exceptions.CompositeException;
import rx.exceptions.Exceptions;
import rx.exceptions.MissingBackpressureException;
import rx.exceptions.OnErrorThrowable;
import rx.internal.operators.BackpressureUtils;
import rx.internal.operators.NotificationLite;
import rx.internal.util.RxRingBuffer;
import rx.internal.util.ScalarSynchronousObservable;
import rx.internal.util.atomic.SpscAtomicArrayQueue;
import rx.internal.util.atomic.SpscExactAtomicArrayQueue;
import rx.internal.util.atomic.SpscUnboundedAtomicArrayQueue;
import rx.internal.util.unsafe.Pow2;
import rx.internal.util.unsafe.SpscArrayQueue;
import rx.internal.util.unsafe.UnsafeAccess;
import rx.subscriptions.CompositeSubscription;

public final class OperatorMerge<T>
implements Observable.Operator<T, Observable<? extends T>> {
    final boolean delayErrors;
    final int maxConcurrent;

    public static <T> OperatorMerge<T> instance(boolean delayErrors) {
        if (delayErrors) {
            return HolderDelayErrors.INSTANCE;
        }
        return HolderNoDelay.INSTANCE;
    }

    public static <T> OperatorMerge<T> instance(boolean delayErrors, int maxConcurrent) {
        if (maxConcurrent <= 0) {
            throw new IllegalArgumentException("maxConcurrent > 0 required but it was " + maxConcurrent);
        }
        if (maxConcurrent == Integer.MAX_VALUE) {
            return OperatorMerge.instance(delayErrors);
        }
        return new OperatorMerge<T>(delayErrors, maxConcurrent);
    }

    OperatorMerge(boolean delayErrors, int maxConcurrent) {
        this.delayErrors = delayErrors;
        this.maxConcurrent = maxConcurrent;
    }

    @Override
    public Subscriber<Observable<? extends T>> call(Subscriber<? super T> child) {
        MergeSubscriber<? super T> subscriber = new MergeSubscriber<T>(child, this.delayErrors, this.maxConcurrent);
        MergeProducer<? super T> producer = new MergeProducer<T>(subscriber);
        subscriber.producer = producer;
        child.add(subscriber);
        child.setProducer(producer);
        return subscriber;
    }

    static final class InnerSubscriber<T>
    extends Subscriber<T> {
        final MergeSubscriber<T> parent;
        final long id;
        volatile boolean done;
        volatile RxRingBuffer queue;
        int outstanding;
        static final int limit = RxRingBuffer.SIZE / 4;

        public InnerSubscriber(MergeSubscriber<T> parent, long id) {
            this.parent = parent;
            this.id = id;
        }

        @Override
        public void onStart() {
            this.outstanding = RxRingBuffer.SIZE;
            this.request(RxRingBuffer.SIZE);
        }

        @Override
        public void onNext(T t) {
            this.parent.tryEmit(this, t);
        }

        @Override
        public void onError(Throwable e) {
            this.done = true;
            this.parent.getOrCreateErrorQueue().offer(e);
            this.parent.emit();
        }

        @Override
        public void onCompleted() {
            this.done = true;
            this.parent.emit();
        }

        public void requestMore(long n) {
            int r = this.outstanding - (int)n;
            if (r > limit) {
                this.outstanding = r;
                return;
            }
            this.outstanding = RxRingBuffer.SIZE;
            int k = RxRingBuffer.SIZE - r;
            if (k > 0) {
                this.request(k);
            }
        }
    }

    static final class MergeSubscriber<T>
    extends Subscriber<Observable<? extends T>> {
        final Subscriber<? super T> child;
        final boolean delayErrors;
        final int maxConcurrent;
        MergeProducer<T> producer;
        volatile Queue<Object> queue;
        volatile CompositeSubscription subscriptions;
        volatile ConcurrentLinkedQueue<Throwable> errors;
        final NotificationLite<T> nl;
        volatile boolean done;
        boolean emitting;
        boolean missed;
        final Object innerGuard;
        volatile InnerSubscriber<?>[] innerSubscribers;
        long uniqueId;
        long lastId;
        int lastIndex;
        static final InnerSubscriber<?>[] EMPTY = new InnerSubscriber[0];
        final int scalarEmissionLimit;
        int scalarEmissionCount;

        public MergeSubscriber(Subscriber<? super T> child, boolean delayErrors, int maxConcurrent) {
            this.child = child;
            this.delayErrors = delayErrors;
            this.maxConcurrent = maxConcurrent;
            this.nl = NotificationLite.instance();
            this.innerGuard = new Object();
            this.innerSubscribers = EMPTY;
            if (maxConcurrent == Integer.MAX_VALUE) {
                this.scalarEmissionLimit = Integer.MAX_VALUE;
                this.request(Long.MAX_VALUE);
            } else {
                this.scalarEmissionLimit = Math.max(1, maxConcurrent >> 1);
                this.request(maxConcurrent);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Queue<Throwable> getOrCreateErrorQueue() {
            ConcurrentLinkedQueue<Throwable> q = this.errors;
            if (q == null) {
                MergeSubscriber mergeSubscriber = this;
                synchronized (mergeSubscriber) {
                    q = this.errors;
                    if (q == null) {
                        this.errors = q = new ConcurrentLinkedQueue();
                    }
                }
            }
            return q;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        CompositeSubscription getOrCreateComposite() {
            CompositeSubscription c = this.subscriptions;
            if (c == null) {
                boolean shouldAdd = false;
                MergeSubscriber mergeSubscriber = this;
                synchronized (mergeSubscriber) {
                    c = this.subscriptions;
                    if (c == null) {
                        this.subscriptions = c = new CompositeSubscription();
                        shouldAdd = true;
                    }
                }
                if (shouldAdd) {
                    this.add(c);
                }
            }
            return c;
        }

        @Override
        public void onNext(Observable<? extends T> t) {
            if (t == null) {
                return;
            }
            if (t == Observable.empty()) {
                this.emitEmpty();
            } else if (t instanceof ScalarSynchronousObservable) {
                this.tryEmit(((ScalarSynchronousObservable)t).get());
            } else {
                InnerSubscriber inner = new InnerSubscriber(this, this.uniqueId++);
                this.addInner(inner);
                t.unsafeSubscribe(inner);
                this.emit();
            }
        }

        void emitEmpty() {
            int produced = this.scalarEmissionCount + 1;
            if (produced == this.scalarEmissionLimit) {
                this.scalarEmissionCount = 0;
                this.requestMore(produced);
            } else {
                this.scalarEmissionCount = produced;
            }
        }

        private void reportError() {
            ArrayList<Throwable> list = new ArrayList<Throwable>(this.errors);
            if (list.size() == 1) {
                this.child.onError((Throwable)list.get(0));
            } else {
                this.child.onError(new CompositeException(list));
            }
        }

        @Override
        public void onError(Throwable e) {
            this.getOrCreateErrorQueue().offer(e);
            this.done = true;
            this.emit();
        }

        @Override
        public void onCompleted() {
            this.done = true;
            this.emit();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addInner(InnerSubscriber<T> inner) {
            this.getOrCreateComposite().add(inner);
            Object object = this.innerGuard;
            synchronized (object) {
                InnerSubscriber<?>[] a = this.innerSubscribers;
                int n = a.length;
                InnerSubscriber[] b = new InnerSubscriber[n + 1];
                System.arraycopy(a, 0, b, 0, n);
                b[n] = inner;
                this.innerSubscribers = b;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeInner(InnerSubscriber<T> inner) {
            RxRingBuffer q = inner.queue;
            if (q != null) {
                q.release();
            }
            this.subscriptions.remove(inner);
            Object object = this.innerGuard;
            synchronized (object) {
                InnerSubscriber<?>[] a = this.innerSubscribers;
                int n = a.length;
                int j = -1;
                for (int i = 0; i < n; ++i) {
                    if (!inner.equals(a[i])) continue;
                    j = i;
                    break;
                }
                if (j < 0) {
                    return;
                }
                if (n == 1) {
                    this.innerSubscribers = EMPTY;
                    return;
                }
                InnerSubscriber[] b = new InnerSubscriber[n - 1];
                System.arraycopy(a, 0, b, 0, j);
                System.arraycopy(a, j + 1, b, j, n - j - 1);
                this.innerSubscribers = b;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void tryEmit(InnerSubscriber<T> subscriber, T value) {
            boolean success = false;
            long r = this.producer.get();
            if (r != 0L) {
                MergeSubscriber mergeSubscriber = this;
                synchronized (mergeSubscriber) {
                    r = this.producer.get();
                    if (!this.emitting && r != 0L) {
                        this.emitting = true;
                        success = true;
                    }
                }
            }
            if (success) {
                this.emitScalar(subscriber, value, r);
            } else {
                this.queueScalar(subscriber, value);
            }
        }

        protected void queueScalar(InnerSubscriber<T> subscriber, T value) {
            RxRingBuffer q = subscriber.queue;
            if (q == null) {
                q = RxRingBuffer.getSpscInstance();
                subscriber.add(q);
                subscriber.queue = q;
            }
            try {
                q.onNext(this.nl.next(value));
            }
            catch (MissingBackpressureException ex) {
                subscriber.unsubscribe();
                subscriber.onError(ex);
                return;
            }
            catch (IllegalStateException ex) {
                if (!subscriber.isUnsubscribed()) {
                    subscriber.unsubscribe();
                    subscriber.onError(ex);
                }
                return;
            }
            this.emit();
        }

        /*
         * Exception decompiling
         */
        protected void emitScalar(InnerSubscriber<T> subscriber, T value, long r) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [15[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void requestMore(long n) {
            this.request(n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void tryEmit(T value) {
            boolean success = false;
            long r = this.producer.get();
            if (r != 0L) {
                MergeSubscriber mergeSubscriber = this;
                synchronized (mergeSubscriber) {
                    r = this.producer.get();
                    if (!this.emitting && r != 0L) {
                        this.emitting = true;
                        success = true;
                    }
                }
            }
            if (success) {
                this.emitScalar(value, r);
            } else {
                this.queueScalar(value);
            }
        }

        protected void queueScalar(T value) {
            Queue<Object> q = this.queue;
            if (q == null) {
                int mc = this.maxConcurrent;
                q = mc == Integer.MAX_VALUE ? new SpscUnboundedAtomicArrayQueue<Object>(RxRingBuffer.SIZE) : (Pow2.isPowerOfTwo(mc) ? (UnsafeAccess.isUnsafeAvailable() ? new SpscArrayQueue<Object>(mc) : new SpscAtomicArrayQueue<Object>(mc)) : new SpscExactAtomicArrayQueue<Object>(mc));
                this.queue = q;
            }
            if (!q.offer(this.nl.next(value))) {
                this.unsubscribe();
                this.onError(OnErrorThrowable.addValueAsLastCause(new MissingBackpressureException(), value));
                return;
            }
            this.emit();
        }

        /*
         * Exception decompiling
         */
        protected void emitScalar(T value, long r) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [15[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void emit() {
            MergeSubscriber mergeSubscriber = this;
            synchronized (mergeSubscriber) {
                if (this.emitting) {
                    this.missed = true;
                    return;
                }
                this.emitting = true;
            }
            this.emitLoop();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void emitLoop() {
            boolean skipFinal = false;
            try {
                Subscriber<T> child = this.child;
                while (true) {
                    int replenishMain;
                    boolean unbounded;
                    long r;
                    Queue<Object> svq;
                    block64: {
                        Object o;
                        if (this.checkTerminate()) {
                            skipFinal = true;
                            return;
                        }
                        svq = this.queue;
                        r = this.producer.get();
                        unbounded = r == Long.MAX_VALUE;
                        replenishMain = 0;
                        if (svq == null) break block64;
                        do {
                            int scalarEmission = 0;
                            o = null;
                            while (r > 0L) {
                                o = svq.poll();
                                if (this.checkTerminate()) {
                                    skipFinal = true;
                                    return;
                                }
                                if (o == null) break;
                                T v = this.nl.getValue(o);
                                try {
                                    child.onNext(v);
                                }
                                catch (Throwable t) {
                                    if (!this.delayErrors) {
                                        Exceptions.throwIfFatal(t);
                                        skipFinal = true;
                                        this.unsubscribe();
                                        child.onError(t);
                                        if (skipFinal) return;
                                        MergeSubscriber mergeSubscriber = this;
                                        synchronized (mergeSubscriber) {
                                            this.emitting = false;
                                            return;
                                        }
                                    }
                                    this.getOrCreateErrorQueue().offer(t);
                                }
                                ++replenishMain;
                                ++scalarEmission;
                                --r;
                            }
                            if (scalarEmission <= 0) continue;
                            r = unbounded ? Long.MAX_VALUE : this.producer.produced(scalarEmission);
                        } while (r != 0L && o != null);
                    }
                    boolean d = this.done;
                    svq = this.queue;
                    InnerSubscriber<?>[] inner = this.innerSubscribers;
                    int n = inner.length;
                    if (d && (svq == null || svq.isEmpty()) && n == 0) {
                        ConcurrentLinkedQueue<Throwable> e = this.errors;
                        if (e == null || e.isEmpty()) {
                            child.onCompleted();
                        } else {
                            this.reportError();
                        }
                        skipFinal = true;
                        return;
                    }
                    boolean innerCompleted = false;
                    if (n > 0) {
                        int i;
                        int j;
                        long startId = this.lastId;
                        int index = this.lastIndex;
                        if (n <= index || inner[index].id != startId) {
                            if (n <= index) {
                                index = 0;
                            }
                            j = index;
                            for (i = 0; i < n && inner[j].id != startId; ++i) {
                                if (++j != n) continue;
                                j = 0;
                            }
                            index = j;
                            this.lastIndex = j;
                            this.lastId = inner[j].id;
                        }
                        j = index;
                        for (i = 0; i < n; ++i) {
                            if (this.checkTerminate()) {
                                skipFinal = true;
                                return;
                            }
                            InnerSubscriber<?> is = inner[j];
                            Object o = null;
                            do {
                                int produced = 0;
                                while (r > 0L) {
                                    if (this.checkTerminate()) {
                                        skipFinal = true;
                                        return;
                                    }
                                    RxRingBuffer q = is.queue;
                                    if (q == null || (o = q.poll()) == null) break;
                                    T v = this.nl.getValue(o);
                                    try {
                                        child.onNext(v);
                                    }
                                    catch (Throwable t) {
                                        skipFinal = true;
                                        Exceptions.throwIfFatal(t);
                                        try {
                                            child.onError(t);
                                        }
                                        finally {
                                            this.unsubscribe();
                                        }
                                        if (skipFinal) return;
                                        MergeSubscriber mergeSubscriber = this;
                                        synchronized (mergeSubscriber) {
                                            this.emitting = false;
                                            return;
                                        }
                                    }
                                    --r;
                                    ++produced;
                                }
                                if (produced <= 0) continue;
                                r = !unbounded ? this.producer.produced(produced) : Long.MAX_VALUE;
                                is.requestMore(produced);
                            } while (r != 0L && o != null);
                            boolean innerDone = is.done;
                            RxRingBuffer innerQueue = is.queue;
                            if (innerDone && (innerQueue == null || innerQueue.isEmpty())) {
                                this.removeInner(is);
                                if (this.checkTerminate()) {
                                    skipFinal = true;
                                    return;
                                }
                                ++replenishMain;
                                innerCompleted = true;
                            }
                            if (r == 0L) break;
                            if (++j != n) continue;
                            j = 0;
                        }
                        this.lastIndex = j;
                        this.lastId = inner[j].id;
                    }
                    if (replenishMain > 0) {
                        this.request(replenishMain);
                    }
                    if (innerCompleted) continue;
                    MergeSubscriber mergeSubscriber = this;
                    synchronized (mergeSubscriber) {
                        if (!this.missed) {
                            skipFinal = true;
                            this.emitting = false;
                            return;
                        }
                        this.missed = false;
                    }
                }
            }
            finally {
                if (!skipFinal) {
                    MergeSubscriber mergeSubscriber = this;
                    synchronized (mergeSubscriber) {
                        this.emitting = false;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean checkTerminate() {
            if (this.child.isUnsubscribed()) {
                return true;
            }
            ConcurrentLinkedQueue<Throwable> e = this.errors;
            if (!this.delayErrors && e != null && !e.isEmpty()) {
                try {
                    this.reportError();
                }
                finally {
                    this.unsubscribe();
                }
                return true;
            }
            return false;
        }
    }

    static final class MergeProducer<T>
    extends AtomicLong
    implements Producer {
        private static final long serialVersionUID = -1214379189873595503L;
        final MergeSubscriber<T> subscriber;

        public MergeProducer(MergeSubscriber<T> subscriber) {
            this.subscriber = subscriber;
        }

        @Override
        public void request(long n) {
            if (n > 0L) {
                if (this.get() == Long.MAX_VALUE) {
                    return;
                }
                BackpressureUtils.getAndAddRequest(this, n);
                this.subscriber.emit();
            } else if (n < 0L) {
                throw new IllegalArgumentException("n >= 0 required");
            }
        }

        public long produced(int n) {
            return this.addAndGet(-n);
        }
    }

    private static final class HolderDelayErrors {
        static final OperatorMerge<Object> INSTANCE = new OperatorMerge(true, Integer.MAX_VALUE);

        private HolderDelayErrors() {
        }
    }

    private static final class HolderNoDelay {
        static final OperatorMerge<Object> INSTANCE = new OperatorMerge(false, Integer.MAX_VALUE);

        private HolderNoDelay() {
        }
    }
}

