/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal;

import com.fasterxml.jackson.databind.JavaType;
import io.protostuff.compiler.model.DynamicMessage;
import io.protostuff.compiler.model.Field;
import io.protostuff.compiler.model.FieldContainer;
import io.protostuff.compiler.model.ScalarFieldType;
import io.protostuff.compiler.model.Type;
import org.apache.servicecomb.foundation.protobuf.internal.ProtoConst;

public final class ProtoUtils {
    private ProtoUtils() {
    }

    public static boolean isAnyField(Field protoField) {
        return protoField.getType().getCanonicalName().equals(ProtoConst.ANY.getCanonicalName());
    }

    public static boolean isWrapProperty(FieldContainer fieldContainer) {
        return fieldContainer.getCommentLines().contains(ProtoConst.ANNOTATION_WRAP_PROPERTY);
    }

    public static boolean isSupportPacked(Field protoField) {
        if (protoField.getType().isEnum()) {
            return true;
        }
        if (protoField.getType().isScalar()) {
            ScalarFieldType scalarFieldType = (ScalarFieldType)protoField.getType();
            return scalarFieldType != ScalarFieldType.STRING && scalarFieldType != ScalarFieldType.BYTES;
        }
        return false;
    }

    public static boolean isPacked(Field protoField) {
        DynamicMessage.Value dynamicMessageValue = protoField.getOptions().get("packed");
        if (dynamicMessageValue != null) {
            return dynamicMessageValue.getBoolean();
        }
        return ProtoUtils.isSupportPacked(protoField);
    }

    public static void throwNotSupportWrite(Field protoField, Object value) throws IllegalStateException {
        ProtoUtils.throwNotSupportWrite(protoField, value.getClass());
    }

    public static void throwNotSupportWrite(Field protoField, Class<?> cls) throws IllegalStateException {
        throw new IllegalStateException(String.format("not support serialize from %s to proto %s, field=%s:%s", cls.getName(), protoField.getTypeName(), ((Type)protoField.getParent()).getCanonicalName(), protoField.getName()));
    }

    public static void throwNotSupportMerge(Field protoField, JavaType javaType) throws IllegalStateException {
        throw new IllegalStateException(String.format("not support deserialize proto %s as %s, field=%s:%s", protoField.getTypeName(), javaType.toCanonical(), ((Type)protoField.getParent()).getCanonicalName(), protoField.getName()));
    }

    public static void throwNotSupportNullElement(Field protoField) throws IllegalStateException {
        throw new IllegalStateException(String.format("not support serialize null element, field=%s:%s", ((Type)protoField.getParent()).getCanonicalName(), protoField.getName()));
    }
}

