/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.priority;

import com.netflix.config.ConfigurationManager;
import com.netflix.config.DynamicPropertyFactory;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.apache.servicecomb.config.inject.ConfigObjectFactory;
import org.apache.servicecomb.config.priority.PriorityProperty;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;

public class PriorityPropertyManager {
    private ConfigurationListener configurationListener = this::configurationListener;
    private Map<PriorityProperty<?>, PriorityProperty<?>> priorityPropertyMap = new ConcurrentHashMapEx();
    private Map<Object, List<PriorityProperty<?>>> configObjectMap = new ConcurrentHashMapEx();
    private Map<String, List<PriorityProperty<?>>> keyCache;

    public PriorityPropertyManager() {
        DynamicPropertyFactory.getInstance();
        ConfigurationManager.getConfigInstance().addConfigurationListener(this.configurationListener);
    }

    public void close() {
        ConfigurationManager.getConfigInstance().removeConfigurationListener(this.configurationListener);
    }

    public synchronized void configurationListener(ConfigurationEvent event) {
        if (event.isBeforeUpdate()) {
            return;
        }
        if (this.keyCache == null) {
            this.keyCache = new ConcurrentHashMapEx();
            this.updateCache(this.priorityPropertyMap.values());
            this.configObjectMap.values().stream().forEach(this::updateCache);
        }
        if (event.getPropertyName() != null) {
            this.keyCache.getOrDefault(event.getPropertyName(), Collections.emptyList()).stream().forEach(p -> p.updateFinalValue(false));
            return;
        }
        this.keyCache.values().stream().flatMap(Collection::stream).forEach(p -> p.updateFinalValue(false));
    }

    private void updateCache(Collection<PriorityProperty<?>> properties) {
        for (PriorityProperty<?> priorityProperty : properties) {
            for (String key : priorityProperty.getPriorityKeys()) {
                this.keyCache.computeIfAbsent(key, k -> new ArrayList()).add(priorityProperty);
            }
            priorityProperty.updateFinalValue(false);
        }
    }

    public Map<PriorityProperty<?>, PriorityProperty<?>> getPriorityPropertyMap() {
        return this.priorityPropertyMap;
    }

    public Map<Object, List<PriorityProperty<?>>> getConfigObjectMap() {
        return this.configObjectMap;
    }

    private synchronized void registerPriorityProperty(PriorityProperty<?> property) {
        this.priorityPropertyMap.put(property, property);
        this.keyCache = null;
    }

    private synchronized void registerConfigObject(Object configObject, List<PriorityProperty<?>> properties) {
        this.configObjectMap.put(configObject, properties);
        this.keyCache = null;
    }

    public synchronized void unregisterPriorityProperty(PriorityProperty<?> property) {
        this.priorityPropertyMap.remove(property);
        this.keyCache = null;
    }

    public synchronized void unregisterConfigObject(Object configObject) {
        if (configObject == null) {
            return;
        }
        this.configObjectMap.remove(configObject);
        this.keyCache = null;
    }

    public <T> T createConfigObject(Class<T> cls, Object ... kvs) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (int idx = 0; idx < kvs.length; idx += 2) {
            parameters.put(kvs[idx].toString(), kvs[idx + 1]);
        }
        return this.createConfigObject(cls, parameters);
    }

    public <T> T createConfigObject(Class<T> cls, Map<String, Object> parameters) {
        ConfigObjectFactory factory = new ConfigObjectFactory();
        T configObject = factory.create(this, cls, parameters);
        this.registerConfigObject(configObject, factory.getPriorityProperties());
        return configObject;
    }

    public <T> PriorityProperty<T> newPriorityProperty(Type cls, T invalidValue, T defaultValue, String ... priorityKeys) {
        return new PriorityProperty<T>(cls, invalidValue, defaultValue, priorityKeys);
    }

    public <T> PriorityProperty<T> createPriorityProperty(Type cls, T invalidValue, T defaultValue, String ... priorityKeys) {
        PriorityProperty<T> priorityProperty = new PriorityProperty<T>(cls, invalidValue, defaultValue, priorityKeys);
        this.registerPriorityProperty(priorityProperty);
        return priorityProperty;
    }
}

