/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.viz.core;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.Function;
import scala.Tuple2;

public class VectorOverlayOperator {
    static final Logger logger = Logger.getLogger(VectorOverlayOperator.class);
    public List<String> backVectorImage = null;
    public JavaPairRDD<Integer, String> distributedBackVectorImage = null;
    public boolean generateDistributedImage = false;

    public VectorOverlayOperator(JavaPairRDD<Integer, String> distributedBackImage) {
        this.distributedBackVectorImage = distributedBackImage;
        this.generateDistributedImage = true;
    }

    public VectorOverlayOperator(List<String> backVectorImage) {
        this.backVectorImage = backVectorImage;
        this.generateDistributedImage = false;
    }

    public boolean JoinImage(JavaPairRDD<Integer, String> distributedFontImage) throws Exception {
        logger.info((Object)"[Sedona-Viz][JoinImage][Start]");
        if (!this.generateDistributedImage) {
            throw new Exception("[OverlayOperator][JoinImage] The back image is not distributed. Please don't use distributed format.");
        }
        JavaPairRDD distributedFontImageNoHeaderFooter = distributedFontImage.filter((Function)new Function<Tuple2<Integer, String>, Boolean>(){

            public Boolean call(Tuple2<Integer, String> vectorObject) throws Exception {
                return (Integer)vectorObject._1 == 1;
            }
        });
        this.distributedBackVectorImage = this.distributedBackVectorImage.union(distributedFontImageNoHeaderFooter);
        this.distributedBackVectorImage = this.distributedBackVectorImage.sortByKey();
        logger.info((Object)"[Sedona-VizViz][JoinImage][Stop]");
        return true;
    }

    public boolean JoinImage(List<String> frontVectorImage) throws Exception {
        int i;
        logger.info((Object)"[Sedona-VizViz][JoinImage][Start]");
        if (this.generateDistributedImage) {
            throw new Exception("[OverlayOperator][JoinImage] The back image is distributed. Please don't use centralized format.");
        }
        ArrayList<String> copyOf = new ArrayList<String>();
        for (i = 0; i < this.backVectorImage.size() - 1; ++i) {
            copyOf.add(this.backVectorImage.get(i));
        }
        for (i = 1; i < frontVectorImage.size() - 1; ++i) {
            copyOf.add(frontVectorImage.get(i));
        }
        copyOf.add(this.backVectorImage.get(this.backVectorImage.size() - 1));
        this.backVectorImage = copyOf;
        logger.info((Object)"[Sedona-VizViz][JoinImage][Stop]");
        return true;
    }
}

