/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.io.stac;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.HashMap;
import org.apache.spark.sql.connector.read.Batch;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.execution.datasource.stac.TemporalFilter;
import org.apache.spark.sql.execution.datasources.parquet.Covering;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetSpatialFilter;
import org.apache.spark.sql.execution.datasources.parquet.GeometryFieldMetaData;
import org.apache.spark.sql.sedona_sql.io.stac.StacBatch$;
import org.apache.spark.sql.sedona_sql.io.stac.StacPartition;
import org.apache.spark.sql.sedona_sql.io.stac.StacPartitionReader;
import org.apache.spark.sql.sedona_sql.io.stac.StacUtils$;
import org.apache.spark.sql.types.StructType;
import org.json4s.JsonAST;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.Tuple6;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.Breaks$;

@ScalaSignature(bytes="\u0006\u0001\t]e\u0001B\u001b7\u0001\u0016C\u0001b\u0018\u0001\u0003\u0016\u0004%\t\u0001\u0019\u0005\tY\u0002\u0011\t\u0012)A\u0005C\"AQ\u000e\u0001BK\u0002\u0013\u0005\u0001\r\u0003\u0005o\u0001\tE\t\u0015!\u0003b\u0011!y\u0007A!f\u0001\n\u0003\u0001\b\u0002C<\u0001\u0005#\u0005\u000b\u0011B9\t\u0011a\u0004!Q3A\u0005\u0002eD\u0001\" \u0001\u0003\u0012\u0003\u0006IA\u001f\u0005\t}\u0002\u0011)\u001a!C\u0001\u007f\"Q\u00111\u0004\u0001\u0003\u0012\u0003\u0006I!!\u0001\t\u0015\u0005u\u0001A!f\u0001\n\u0003\ty\u0002\u0003\u0006\u00022\u0001\u0011\t\u0012)A\u0005\u0003CAq!a\r\u0001\t\u0003\t)\u0004C\u0005\u0002H\u0001\u0011\r\u0011\"\u0003\u0002J!A\u0011\u0011\u000b\u0001!\u0002\u0013\tY\u0005C\u0005\u0002T\u0001\u0011\r\u0011\"\u0003\u0002J!A\u0011Q\u000b\u0001!\u0002\u0013\tY\u0005C\u0005\u0002X\u0001\u0001\r\u0011\"\u0003\u0002J!I\u0011\u0011\f\u0001A\u0002\u0013%\u00111\f\u0005\t\u0003O\u0002\u0001\u0015)\u0003\u0002L!I\u0011\u0011\u000e\u0001A\u0002\u0013%\u0011\u0011\n\u0005\n\u0003W\u0002\u0001\u0019!C\u0005\u0003[B\u0001\"!\u001d\u0001A\u0003&\u00111\n\u0005\n\u0003g\u0002!\u0019!C\u0001\u0003kB\u0001\"a$\u0001A\u0003%\u0011q\u000f\u0005\b\u0003#\u0003A\u0011AAJ\u0011\u001d\tI\n\u0001C!\u00037Cq!!+\u0001\t\u0003\tY\u000bC\u0004\u0002T\u0002!\t!!6\t\u000f\u0005u\u0007\u0001\"\u0011\u0002`\"I\u0011q\u001d\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u001e\u0005\n\u0003o\u0004\u0011\u0013!C\u0001\u0003sD\u0011Ba\u0004\u0001#\u0003%\t!!?\t\u0013\tE\u0001!%A\u0005\u0002\tM\u0001\"\u0003B\f\u0001E\u0005I\u0011\u0001B\r\u0011%\u0011i\u0002AI\u0001\n\u0003\u0011y\u0002C\u0005\u0003$\u0001\t\n\u0011\"\u0001\u0003&!I!\u0011\u0006\u0001\u0002\u0002\u0013\u0005#1\u0006\u0005\n\u0005c\u0001\u0011\u0011!C\u0001\u0003\u0013B\u0011Ba\r\u0001\u0003\u0003%\tA!\u000e\t\u0013\t}\u0002!!A\u0005B\t\u0005\u0003\"\u0003B&\u0001\u0005\u0005I\u0011\u0001B'\u0011%\u0011\t\u0006AA\u0001\n\u0003\u0012\u0019\u0006C\u0005\u0003V\u0001\t\t\u0011\"\u0011\u0003X!I!\u0011\f\u0001\u0002\u0002\u0013\u0005#1L\u0004\n\u0005?2\u0014\u0011!E\u0001\u0005C2\u0001\"\u000e\u001c\u0002\u0002#\u0005!1\r\u0005\b\u0003gyC\u0011\u0001B9\u0011%\u0011)fLA\u0001\n\u000b\u00129\u0006C\u0005\u0003t=\n\t\u0011\"!\u0003v!I!1Q\u0018\u0002\u0002\u0013\u0005%Q\u0011\u0005\n\u0005'{\u0013\u0011!C\u0005\u0005+\u0013\u0011b\u0015;bG\n\u000bGo\u00195\u000b\u0005]B\u0014\u0001B:uC\u000eT!!\u000f\u001e\u0002\u0005%|'BA\u001e=\u0003)\u0019X\rZ8oC~\u001b\u0018\u000f\u001c\u0006\u0003{y\n1a]9m\u0015\ty\u0004)A\u0003ta\u0006\u00148N\u0003\u0002B\u0005\u00061\u0011\r]1dQ\u0016T\u0011aQ\u0001\u0004_J<7\u0001A\n\u0006\u0001\u0019se\u000b\u0018\t\u0003\u000f2k\u0011\u0001\u0013\u0006\u0003\u0013*\u000bA\u0001\\1oO*\t1*\u0001\u0003kCZ\f\u0017BA'I\u0005\u0019y%M[3diB\u0011q\nV\u0007\u0002!*\u0011\u0011KU\u0001\u0005e\u0016\fGM\u0003\u0002Ty\u0005I1m\u001c8oK\u000e$xN]\u0005\u0003+B\u0013QAQ1uG\"\u0004\"a\u0016.\u000e\u0003aS\u0011!W\u0001\u0006g\u000e\fG.Y\u0005\u00037b\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002X;&\u0011a\f\u0017\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0012gR\f7mQ8mY\u0016\u001cG/[8o+JdW#A1\u0011\u0005\tLgBA2h!\t!\u0007,D\u0001f\u0015\t1G)\u0001\u0004=e>|GOP\u0005\u0003Qb\u000ba\u0001\u0015:fI\u00164\u0017B\u00016l\u0005\u0019\u0019FO]5oO*\u0011\u0001\u000eW\u0001\u0013gR\f7mQ8mY\u0016\u001cG/[8o+Jd\u0007%\u0001\nti\u0006\u001c7i\u001c7mK\u000e$\u0018n\u001c8Kg>t\u0017aE:uC\u000e\u001cu\u000e\u001c7fGRLwN\u001c&t_:\u0004\u0013AB:dQ\u0016l\u0017-F\u0001r!\t\u0011X/D\u0001t\u0015\t!H(A\u0003usB,7/\u0003\u0002wg\nQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\u000fM\u001c\u0007.Z7bA\u0005!q\u000e\u001d;t+\u0005Q\b\u0003\u00022|C\u0006L!\u0001`6\u0003\u00075\u000b\u0007/A\u0003paR\u001c\b%A\u0007ta\u0006$\u0018.\u00197GS2$XM]\u000b\u0003\u0003\u0003\u0001RaVA\u0002\u0003\u000fI1!!\u0002Y\u0005\u0019y\u0005\u000f^5p]B!\u0011\u0011BA\f\u001b\t\tYA\u0003\u0003\u0002\u000e\u0005=\u0011a\u00029beF,X\r\u001e\u0006\u0005\u0003#\t\u0019\"A\u0006eCR\f7o\\;sG\u0016\u001c(bAA\u000by\u0005IQ\r_3dkRLwN\\\u0005\u0005\u00033\tYAA\fHK>\u0004\u0016M]9vKR\u001c\u0006/\u0019;jC24\u0015\u000e\u001c;fe\u0006q1\u000f]1uS\u0006dg)\u001b7uKJ\u0004\u0013A\u0004;f[B|'/\u00197GS2$XM]\u000b\u0003\u0003C\u0001RaVA\u0002\u0003G\u0001B!!\n\u0002.5\u0011\u0011q\u0005\u0006\u0004o\u0005%\"\u0002BA\u0016\u0003'\t!\u0002Z1uCN|WO]2f\u0013\u0011\ty#a\n\u0003\u001dQ+W\u000e]8sC24\u0015\u000e\u001c;fe\u0006yA/Z7q_J\fGNR5mi\u0016\u0014\b%\u0001\u0004=S:LGO\u0010\u000b\u000f\u0003o\tY$!\u0010\u0002@\u0005\u0005\u00131IA#!\r\tI\u0004A\u0007\u0002m!)q,\u0004a\u0001C\")Q.\u0004a\u0001C\")q.\u0004a\u0001c\")\u00010\u0004a\u0001u\"1a0\u0004a\u0001\u0003\u0003Aq!!\b\u000e\u0001\u0004\t\t#A\u000eeK\u001a\fW\u000f\u001c;Ji\u0016l7\u000fT5nSR\u0004VM\u001d*fcV,7\u000f^\u000b\u0003\u0003\u0017\u00022aVA'\u0013\r\ty\u0005\u0017\u0002\u0004\u0013:$\u0018\u0001\b3fM\u0006,H\u000e^%uK6\u001cH*[7jiB+'OU3rk\u0016\u001cH\u000fI\u0001 SR,Wn\u001d'pC\u0012\u0004&o\\2fgN\u0014V\r]8siRC'/Z:i_2$\u0017\u0001I5uK6\u001cHj\\1e!J|7-Z:t%\u0016\u0004xN\u001d;UQJ,7\u000f[8mI\u0002\n1\"\u001b;f[6\u000b\u0007\u0010T3gi\u0006y\u0011\u000e^3n\u001b\u0006DH*\u001a4u?\u0012*\u0017\u000f\u0006\u0003\u0002^\u0005\r\u0004cA,\u0002`%\u0019\u0011\u0011\r-\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003K\u001a\u0012\u0011!a\u0001\u0003\u0017\n1\u0001\u001f\u00132\u00031IG/Z7NCbdUM\u001a;!\u0003=a\u0017m\u001d;SKB|'\u000f^\"pk:$\u0018a\u00057bgR\u0014V\r]8si\u000e{WO\u001c;`I\u0015\fH\u0003BA/\u0003_B\u0011\"!\u001a\u0017\u0003\u0003\u0005\r!a\u0013\u0002!1\f7\u000f\u001e*fa>\u0014HoQ8v]R\u0004\u0013AB7baB,'/\u0006\u0002\u0002xA!\u0011\u0011PAF\u001b\t\tYH\u0003\u0003\u0002~\u0005}\u0014\u0001\u00033bi\u0006\u0014\u0017N\u001c3\u000b\t\u0005\u0005\u00151Q\u0001\bU\u0006\u001c7n]8o\u0015\u0011\t))a\"\u0002\u0013\u0019\f7\u000f^3sq6d'BAAE\u0003\r\u0019w.\\\u0005\u0005\u0003\u001b\u000bYH\u0001\u0007PE*,7\r^'baB,'/A\u0004nCB\u0004XM\u001d\u0011\u0002\u001dM,G/\u0013;f[6\u000b\u0007\u0010T3giR!\u0011QLAK\u0011\u001d\t9J\u0007a\u0001\u0003\u0017\nQA^1mk\u0016\f1\u0003\u001d7b]&s\u0007/\u001e;QCJ$\u0018\u000e^5p]N$\"!!(\u0011\u000b]\u000by*a)\n\u0007\u0005\u0005\u0006LA\u0003BeJ\f\u0017\u0010E\u0002P\u0003KK1!a*Q\u00059Ie\u000e];u!\u0006\u0014H/\u001b;j_:\f\u0001cY8mY\u0016\u001cG/\u0013;f[2Kgn[:\u0015\u0015\u0005u\u0013QVAY\u0003k\u000bI\r\u0003\u0004\u00020r\u0001\r!Y\u0001\u0013G>dG.Z2uS>t')Y:f!\u0006$\b\u000e\u0003\u0004\u00024r\u0001\r!Y\u0001\u000fG>dG.Z2uS>t'j]8o\u0011\u001d\t9\f\ba\u0001\u0003s\u000b\u0011\"\u001b;f[2Kgn[:\u0011\u000b\u0005m\u0016QY1\u000e\u0005\u0005u&\u0002BA`\u0003\u0003\fq!\\;uC\ndWMC\u0002\u0002Db\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9-!0\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\u0005\b\u0003\u0017d\u0002\u0019AAg\u0003IqW-\u001a3D_VtGOT3yi&#X-\\:\u0011\u0007]\u000by-C\u0002\u0002Rb\u0013qAQ8pY\u0016\fg.\u0001\tgS2$XM]\"pY2,7\r^5p]RA\u0011QZAl\u00033\fY\u000e\u0003\u0004\u00024v\u0001\r!\u0019\u0005\u0007}v\u0001\r!!\u0001\t\u000f\u0005uQ\u00041\u0001\u0002\"\u0005\u00192M]3bi\u0016\u0014V-\u00193fe\u001a\u000b7\r^8ssR\u0011\u0011\u0011\u001d\t\u0004\u001f\u0006\r\u0018bAAs!\n1\u0002+\u0019:uSRLwN\u001c*fC\u0012,'OR1di>\u0014\u00180\u0001\u0003d_BLHCDA\u001c\u0003W\fi/a<\u0002r\u0006M\u0018Q\u001f\u0005\b?~\u0001\n\u00111\u0001b\u0011\u001diw\u0004%AA\u0002\u0005Dqa\\\u0010\u0011\u0002\u0003\u0007\u0011\u000fC\u0004y?A\u0005\t\u0019\u0001>\t\u0011y|\u0002\u0013!a\u0001\u0003\u0003A\u0011\"!\b !\u0003\u0005\r!!\t\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111 \u0016\u0004C\u0006u8FAA\u0000!\u0011\u0011\tAa\u0003\u000e\u0005\t\r!\u0002\u0002B\u0003\u0005\u000f\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t%\u0001,\u0001\u0006b]:|G/\u0019;j_:LAA!\u0004\u0003\u0004\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTC\u0001B\u000bU\r\t\u0018Q`\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011YBK\u0002{\u0003{\fabY8qs\u0012\"WMZ1vYR$S'\u0006\u0002\u0003\")\"\u0011\u0011AA\u007f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIY*\"Aa\n+\t\u0005\u0005\u0012Q`\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\t5\u0002cA$\u00030%\u0011!\u000eS\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u00119D!\u0010\u0011\u0007]\u0013I$C\u0002\u0003<a\u00131!\u00118z\u0011%\t)\u0007KA\u0001\u0002\u0004\tY%A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011\u0019\u0005\u0005\u0004\u0003F\t\u001d#qG\u0007\u0003\u0003\u0003LAA!\u0013\u0002B\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tiMa\u0014\t\u0013\u0005\u0015$&!AA\u0002\t]\u0012\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005-\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\t5\u0012AB3rk\u0006d7\u000f\u0006\u0003\u0002N\nu\u0003\"CA3[\u0005\u0005\t\u0019\u0001B\u001c\u0003%\u0019F/Y2CCR\u001c\u0007\u000eE\u0002\u0002:=\u001aBa\fB39Bq!q\rB7C\u0006\f(0!\u0001\u0002\"\u0005]RB\u0001B5\u0015\r\u0011Y\u0007W\u0001\beVtG/[7f\u0013\u0011\u0011yG!\u001b\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>tg\u0007\u0006\u0002\u0003b\u0005)\u0011\r\u001d9msRq\u0011q\u0007B<\u0005s\u0012YH! \u0003\u0000\t\u0005\u0005\"B03\u0001\u0004\t\u0007\"B73\u0001\u0004\t\u0007\"B83\u0001\u0004\t\b\"\u0002=3\u0001\u0004Q\bB\u0002@3\u0001\u0004\t\t\u0001C\u0004\u0002\u001eI\u0002\r!!\t\u0002\u000fUt\u0017\r\u001d9msR!!q\u0011BH!\u00159\u00161\u0001BE!-9&1R1bcj\f\t!!\t\n\u0007\t5\u0005L\u0001\u0004UkBdWM\u000e\u0005\n\u0005#\u001b\u0014\u0011!a\u0001\u0003o\t1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0003\u0019\u0003")
public class StacBatch
implements Batch,
Product,
scala.Serializable {
    private final String stacCollectionUrl;
    private final String stacCollectionJson;
    private final StructType schema;
    private final Map<String, String> opts;
    private final Option<GeoParquetSpatialFilter> spatialFilter;
    private final Option<TemporalFilter> temporalFilter;
    private final int defaultItemsLimitPerRequest;
    private final int itemsLoadProcessReportThreshold;
    private int itemMaxLeft;
    private int lastReportCount;
    private final ObjectMapper mapper;

    public static Option<Tuple6<String, String, StructType, Map<String, String>, Option<GeoParquetSpatialFilter>, Option<TemporalFilter>>> unapply(StacBatch stacBatch) {
        return StacBatch$.MODULE$.unapply(stacBatch);
    }

    public static StacBatch apply(String string, String string2, StructType structType, Map<String, String> map, Option<GeoParquetSpatialFilter> option, Option<TemporalFilter> option2) {
        return StacBatch$.MODULE$.apply(string, string2, structType, map, option, option2);
    }

    public static Function1<Tuple6<String, String, StructType, Map<String, String>, Option<GeoParquetSpatialFilter>, Option<TemporalFilter>>, StacBatch> tupled() {
        return StacBatch$.MODULE$.tupled();
    }

    public static Function1<String, Function1<String, Function1<StructType, Function1<Map<String, String>, Function1<Option<GeoParquetSpatialFilter>, Function1<Option<TemporalFilter>, StacBatch>>>>>> curried() {
        return StacBatch$.MODULE$.curried();
    }

    public String stacCollectionUrl() {
        return this.stacCollectionUrl;
    }

    public String stacCollectionJson() {
        return this.stacCollectionJson;
    }

    public StructType schema() {
        return this.schema;
    }

    public Map<String, String> opts() {
        return this.opts;
    }

    public Option<GeoParquetSpatialFilter> spatialFilter() {
        return this.spatialFilter;
    }

    public Option<TemporalFilter> temporalFilter() {
        return this.temporalFilter;
    }

    private int defaultItemsLimitPerRequest() {
        return this.defaultItemsLimitPerRequest;
    }

    private int itemsLoadProcessReportThreshold() {
        return this.itemsLoadProcessReportThreshold;
    }

    private int itemMaxLeft() {
        return this.itemMaxLeft;
    }

    private void itemMaxLeft_$eq(int x$1) {
        this.itemMaxLeft = x$1;
    }

    private int lastReportCount() {
        return this.lastReportCount;
    }

    private void lastReportCount_$eq(int x$1) {
        this.lastReportCount = x$1;
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    public void setItemMaxLeft(int value) {
        this.itemMaxLeft_$eq(value);
    }

    public InputPartition[] planInputPartitions() {
        String stacCollectionBasePath = StacUtils$.MODULE$.getStacCollectionBasePath(this.stacCollectionUrl());
        ArrayBuffer itemLinks = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        int itemsLimitMax = new StringOps(Predef$.MODULE$.augmentString((String)this.opts().getOrElse((Object)"itemsLimitMax", (Function0 & Serializable & scala.Serializable)() -> "-1"))).toInt();
        boolean checkItemsLimitMax = itemsLimitMax > 0;
        this.setItemMaxLeft(itemsLimitMax);
        this.collectItemLinks(stacCollectionBasePath, this.stacCollectionJson(), (ArrayBuffer<String>)itemLinks, checkItemsLimitMax);
        if (itemLinks.isEmpty()) {
            return (InputPartition[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(InputPartition.class));
        }
        int numPartitions = StacUtils$.MODULE$.getNumPartitions(itemLinks.length(), new StringOps(Predef$.MODULE$.augmentString((String)this.opts().getOrElse((Object)"numPartitions", (Function0 & Serializable & scala.Serializable)() -> "-1"))).toInt(), new StringOps(Predef$.MODULE$.augmentString((String)this.opts().getOrElse((Object)"maxPartitionItemFiles", (Function0 & Serializable & scala.Serializable)() -> "-1"))).toInt(), new StringOps(Predef$.MODULE$.augmentString((String)this.opts().getOrElse((Object)"defaultParallelism", (Function0 & Serializable & scala.Serializable)() -> "1"))).toInt());
        if (itemLinks.length() < numPartitions) {
            return (InputPartition[])((TraversableOnce)((TraversableLike)itemLinks.zipWithIndex(ArrayBuffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String item = (String)tuple2._1();
                int index = tuple2._2$mcI$sp();
                StacPartition stacPartition = new StacPartition(index, (String[])((Object[])new String[]{item}), new HashMap<String, String>());
                return stacPartition;
            }, ArrayBuffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(InputPartition.class));
        }
        int partitionSize = (int)Math.ceil((double)itemLinks.length() / (double)numPartitions);
        return (InputPartition[])itemLinks.grouped(partitionSize).zipWithIndex().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ArrayBuffer items = (ArrayBuffer)tuple2._1();
            int index = tuple2._2$mcI$sp();
            StacPartition stacPartition = new StacPartition(index, (String[])items.toArray(ClassTag$.MODULE$.apply(String.class)), new HashMap<String, String>());
            return stacPartition;
        }).toArray(ClassTag$.MODULE$.apply(InputPartition.class));
    }

    public void collectItemLinks(String collectionBasePath, String collectionJson, ArrayBuffer<String> itemLinks, boolean needCountNextItems) {
        if (needCountNextItems && this.itemMaxLeft() <= 0) {
            return;
        }
        if (itemLinks.size() - this.lastReportCount() >= this.itemsLoadProcessReportThreshold()) {
            Console$.MODULE$.out().println(new StringBuilder(38).append("Searched or partitioned ").append(itemLinks.size()).append(" items so far.").toString());
            this.lastReportCount_$eq(itemLinks.size());
        }
        JsonNode rootNode = this.mapper().readTree(collectionJson);
        JsonNode linksNode = rootNode.get("links");
        java.util.Iterator iterator = linksNode.elements();
        while (iterator.hasNext()) {
            String href;
            String rel;
            block9: {
                block8: {
                    JsonNode linkNode = (JsonNode)iterator.next();
                    rel = linkNode.get("rel").asText();
                    href = linkNode.get("href").asText();
                    String string = rel;
                    String string2 = "item";
                    if (!(string == null ? string2 != null : !string.equals(string2))) break block8;
                    String string3 = rel;
                    String string4 = "items";
                    if (string3 != null ? !string3.equals(string4) : string4 != null) break block9;
                }
                String itemUrl = href.startsWith("http") || href.startsWith("file") ? href : new StringBuilder(0).append(collectionBasePath).append(href).toString();
                String string = rel;
                String string5 = "items";
                ArrayBuffer arrayBuffer = !(string != null ? !string.equals(string5) : string5 != null) && href.startsWith("http") ? itemLinks.$plus$eq((Object)new StringBuilder(7).append(itemUrl).append("?limit=").append(this.defaultItemsLimitPerRequest()).toString()) : itemLinks.$plus$eq((Object)itemUrl);
                if (needCountNextItems && this.itemMaxLeft() <= 0) {
                    return;
                }
                String string6 = rel;
                String string7 = "item";
                if (!(string6 != null ? !string6.equals(string7) : string7 != null) && needCountNextItems) {
                    this.itemMaxLeft_$eq(this.itemMaxLeft() - 1);
                    continue;
                }
                String string8 = rel;
                String string9 = "items";
                if (string8 != null ? !string8.equals(string9) : string9 != null) continue;
                if (!href.startsWith("http") || !this.iterateItemsWithLimit$1(new StringBuilder(7).append(itemUrl).append("?limit=").append(this.defaultItemsLimitPerRequest()).toString(), needCountNextItems, collectionBasePath, itemLinks)) continue;
                return;
            }
            String string = rel;
            String string10 = "child";
            if (string != null ? !string.equals(string10) : string10 != null) continue;
            String childUrl = href.startsWith("http") || href.startsWith("file") ? href : new StringBuilder(0).append(collectionBasePath).append(href).toString();
            String linkedCollectionJson = StacUtils$.MODULE$.loadStacCollectionToJson(childUrl, StacUtils$.MODULE$.loadStacCollectionToJson$default$2());
            String nestedCollectionBasePath = StacUtils$.MODULE$.getStacCollectionBasePath(childUrl);
            boolean collectionFiltered = this.filterCollection(linkedCollectionJson, this.spatialFilter(), this.temporalFilter());
            if (collectionFiltered) continue;
            this.collectItemLinks(nestedCollectionBasePath, linkedCollectionJson, itemLinks, needCountNextItems);
        }
    }

    public boolean filterCollection(String collectionJson, Option<GeoParquetSpatialFilter> spatialFilter, Option<TemporalFilter> temporalFilter) {
        boolean bl;
        boolean bl2;
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = mapper.readTree(collectionJson);
        Option<GeoParquetSpatialFilter> option = spatialFilter;
        if (option instanceof Some) {
            List bbox;
            Some some = (Some)option;
            GeoParquetSpatialFilter filter = (GeoParquetSpatialFilter)some.value();
            JsonNode extentNode = rootNode.path("extent").path("spatial").path("bbox");
            bl2 = extentNode.isMissingNode() ? false : !(bbox = ((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(extentNode.elements()).asScala()).map((Function1 & Serializable & scala.Serializable)bboxNode -> {
                double minX = bboxNode.get(0).asDouble();
                double minY = bboxNode.get(1).asDouble();
                double maxX = bboxNode.get(2).asDouble();
                double maxY = bboxNode.get(3).asDouble();
                return new Tuple4((Object)BoxesRunTime.boxToDouble((double)minX), (Object)BoxesRunTime.boxToDouble((double)minY), (Object)BoxesRunTime.boxToDouble((double)maxX), (Object)BoxesRunTime.boxToDouble((double)maxY));
            }).toList()).exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)StacBatch.$anonfun$filterCollection$2(filter, x0$1)));
        } else if (None$.MODULE$.equals(option)) {
            bl2 = false;
        } else {
            throw new MatchError(option);
        }
        boolean spatialFiltered = bl2;
        Option<TemporalFilter> option2 = temporalFilter;
        if (option2 instanceof Some) {
            boolean bl3;
            Some some = (Some)option2;
            TemporalFilter filter = (TemporalFilter)some.value();
            JsonNode extentNode = rootNode.path("extent").path("temporal").path("interval");
            if (extentNode.isMissingNode()) {
                bl3 = true;
            } else {
                DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss").optionalStart().appendFraction(ChronoField.MILLI_OF_SECOND, 0, 3, true).optionalEnd().appendPattern("'Z'").toFormatter();
                List intervals = ((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(extentNode.elements()).asScala()).map((Function1 & Serializable & scala.Serializable)intervalNode -> {
                    LocalDateTime start = LocalDateTime.parse(intervalNode.get(0).asText(), formatter);
                    LocalDateTime end = LocalDateTime.parse(intervalNode.get(1).asText(), formatter);
                    return new Tuple2((Object)start, (Object)end);
                }).toList();
                bl3 = !intervals.exists((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)StacBatch.$anonfun$filterCollection$4(filter, x0$2)));
            }
            bl = bl3;
        } else if (None$.MODULE$.equals(option2)) {
            bl = false;
        } else {
            throw new MatchError(option2);
        }
        boolean temporalFiltered = bl;
        return spatialFiltered || temporalFiltered;
    }

    public PartitionReaderFactory createReaderFactory() {
        return (PartitionReaderFactory & Serializable)partition -> new StacPartitionReader((StacPartition)partition, this.schema(), this.opts(), this.spatialFilter(), this.temporalFilter());
    }

    public StacBatch copy(String stacCollectionUrl, String stacCollectionJson, StructType schema, Map<String, String> opts, Option<GeoParquetSpatialFilter> spatialFilter, Option<TemporalFilter> temporalFilter) {
        return new StacBatch(stacCollectionUrl, stacCollectionJson, schema, opts, spatialFilter, temporalFilter);
    }

    public String copy$default$1() {
        return this.stacCollectionUrl();
    }

    public String copy$default$2() {
        return this.stacCollectionJson();
    }

    public StructType copy$default$3() {
        return this.schema();
    }

    public Map<String, String> copy$default$4() {
        return this.opts();
    }

    public Option<GeoParquetSpatialFilter> copy$default$5() {
        return this.spatialFilter();
    }

    public Option<TemporalFilter> copy$default$6() {
        return this.temporalFilter();
    }

    public String productPrefix() {
        return "StacBatch";
    }

    public int productArity() {
        return 6;
    }

    public Object productElement(int x$1) {
        Map<String, String> map;
        int n = x$1;
        switch (n) {
            case 0: {
                map = this.stacCollectionUrl();
                break;
            }
            case 1: {
                map = this.stacCollectionJson();
                break;
            }
            case 2: {
                map = this.schema();
                break;
            }
            case 3: {
                map = this.opts();
                break;
            }
            case 4: {
                map = this.spatialFilter();
                break;
            }
            case 5: {
                map = this.temporalFilter();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return map;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StacBatch;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StacBatch)) return false;
        boolean bl = true;
        if (!bl) return false;
        StacBatch stacBatch = (StacBatch)x$1;
        String string = this.stacCollectionUrl();
        String string2 = stacBatch.stacCollectionUrl();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.stacCollectionJson();
        String string4 = stacBatch.stacCollectionJson();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        StructType structType = this.schema();
        StructType structType2 = stacBatch.schema();
        if (structType == null) {
            if (structType2 != null) {
                return false;
            }
        } else if (!structType.equals(structType2)) return false;
        Map<String, String> map = this.opts();
        Map<String, String> map2 = stacBatch.opts();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Option<GeoParquetSpatialFilter> option = this.spatialFilter();
        Option<GeoParquetSpatialFilter> option2 = stacBatch.spatialFilter();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<TemporalFilter> option3 = this.temporalFilter();
        Option<TemporalFilter> option4 = stacBatch.temporalFilter();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        if (!stacBatch.canEqual(this)) return false;
        return true;
    }

    private final boolean iterateItemsWithLimit$1(String itemUrl, boolean needCountNextItems, String collectionBasePath$1, ArrayBuffer itemLinks$1) {
        boolean bl;
        Object object = new Object();
        try {
            ObjectRef nextUrl = ObjectRef.create((Object)new Some((Object)itemUrl));
            Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                while (((Option)nextUrl$1.elem).isDefined()) {
                    String itemJson = StacUtils$.MODULE$.loadStacCollectionToJson((String)((Option)nextUrl$1.elem).get(), StacUtils$.MODULE$.loadStacCollectionToJson$default$2());
                    JsonNode itemRootNode = this.mapper().readTree(itemJson);
                    JsonNode itemLinksNode = itemRootNode.get("links");
                    if (itemLinksNode == null) {
                        throw new NonLocalReturnControl.mcZ.sp(object, true);
                    }
                    java.util.Iterator itemIterator = itemLinksNode.elements();
                    nextUrl$1.elem = None$.MODULE$;
                    while (itemIterator.hasNext()) {
                        JsonNode itemLinkNode = (JsonNode)itemIterator.next();
                        String itemRel = itemLinkNode.get("rel").asText();
                        String itemHref = itemLinkNode.get("href").asText();
                        String string = itemRel;
                        String string2 = "next";
                        if (string != null ? !string.equals(string2) : string2 != null) continue;
                        JsonNode numberReturnedNode = itemRootNode.get("numberReturned");
                        int numberReturned = numberReturnedNode == null ? this.defaultItemsLimitPerRequest() : numberReturnedNode.asInt();
                        this.itemMaxLeft_$eq(this.itemMaxLeft() - numberReturned);
                        if (needCountNextItems && this.itemMaxLeft() <= 0) {
                            throw new NonLocalReturnControl.mcZ.sp(object, true);
                        }
                        nextUrl$1.elem = new Some((Object)(itemHref.startsWith("http") || itemHref.startsWith("file") ? itemHref : new StringBuilder(0).append(collectionBasePath$1).append(itemHref).toString()));
                    }
                    Object object = ((Option)nextUrl$1.elem).isDefined() ? itemLinks$1.$plus$eq(((Option)nextUrl$1.elem).get()) : BoxedUnit.UNIT;
                }
            });
            bl = false;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$filterCollection$2(GeoParquetSpatialFilter filter$1, Tuple4 x0$1) {
        Tuple4 tuple4 = x0$1;
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        double minX = BoxesRunTime.unboxToDouble((Object)tuple4._1());
        double minY = BoxesRunTime.unboxToDouble((Object)tuple4._2());
        double maxX = BoxesRunTime.unboxToDouble((Object)tuple4._3());
        double maxY = BoxesRunTime.unboxToDouble((Object)tuple4._4());
        Seq geometryTypes = (Seq)new .colon.colon((Object)"Polygon", (List)Nil$.MODULE$);
        Seq bbox = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{minX, minY, maxX, maxY}));
        GeometryFieldMetaData geometryFieldMetaData = new GeometryFieldMetaData("WKB", (Seq<String>)geometryTypes, (Seq<Object>)bbox, (Option<JsonAST.JValue>)None$.MODULE$, (Option<Covering>)None$.MODULE$);
        boolean bl = filter$1.evaluate((Map<String, GeometryFieldMetaData>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"geometry"), (Object)geometryFieldMetaData)}))));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$filterCollection$4(TemporalFilter filter$2, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        LocalDateTime start = (LocalDateTime)tuple2._1();
        LocalDateTime end = (LocalDateTime)tuple2._2();
        boolean bl = filter$2.evaluate((Map<String, LocalDateTime>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datetime"), (Object)start)})))) || filter$2.evaluate((Map<String, LocalDateTime>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datetime"), (Object)end)}))));
        return bl;
    }

    public StacBatch(String stacCollectionUrl, String stacCollectionJson, StructType schema, Map<String, String> opts, Option<GeoParquetSpatialFilter> spatialFilter, Option<TemporalFilter> temporalFilter) {
        this.stacCollectionUrl = stacCollectionUrl;
        this.stacCollectionJson = stacCollectionJson;
        this.schema = schema;
        this.opts = opts;
        this.spatialFilter = spatialFilter;
        this.temporalFilter = temporalFilter;
        Product.$init$((Product)this);
        int itemsLimitMax = new StringOps(Predef$.MODULE$.augmentString((String)opts.getOrElse((Object)"itemsLimitMax", (Function0 & Serializable & scala.Serializable)() -> "-1"))).toInt();
        int limitPerRequest = new StringOps(Predef$.MODULE$.augmentString((String)opts.getOrElse((Object)"itemsLimitPerRequest", (Function0 & Serializable & scala.Serializable)() -> "10"))).toInt();
        this.defaultItemsLimitPerRequest = itemsLimitMax > 0 && limitPerRequest > itemsLimitMax ? itemsLimitMax : limitPerRequest;
        this.itemsLoadProcessReportThreshold = new StringOps(Predef$.MODULE$.augmentString((String)opts.getOrElse((Object)"itemsLoadProcessReportThreshold", (Function0 & Serializable & scala.Serializable)() -> "1000000"))).toInt();
        this.itemMaxLeft = -1;
        this.lastReportCount = 0;
        this.mapper = new ObjectMapper();
    }
}

