/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.io.stac;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JSONOptionsInRead;
import org.apache.spark.sql.catalyst.json.JacksonParser;
import org.apache.spark.sql.connector.metric.CustomTaskMetric;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.execution.datasource.stac.TemporalFilter;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.json.JsonDataSource;
import org.apache.spark.sql.execution.datasources.json.JsonDataSource$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetSpatialFilter;
import org.apache.spark.sql.sedona_sql.io.geojson.GeoJSONUtils$;
import org.apache.spark.sql.sedona_sql.io.geojson.SparkCompatUtil$;
import org.apache.spark.sql.sedona_sql.io.stac.StacPartition;
import org.apache.spark.sql.sedona_sql.io.stac.StacUtils$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.io.Codec$;
import scala.io.Source$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005ug\u0001\u0002\u000f\u001e\u00011B\u0001b\u0011\u0001\u0003\u0002\u0003\u0006I\u0001\u0012\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005\u0013\"Aq\n\u0001B\u0001B\u0003%\u0001\u000b\u0003\u0005a\u0001\t\u0005\t\u0015!\u0003b\u0011!y\u0007A!A!\u0002\u0013\u0001\b\"\u0002=\u0001\t\u0003I\b\"CA\u0001\u0001\t\u0007I\u0011BA\u0002\u0011!\t\t\u0002\u0001Q\u0001\n\u0005\u0015\u0001bCA\n\u0001\u0001\u0007\t\u0019!C\u0005\u0003+A1\"a\u0006\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u001a!Q\u0011Q\u0005\u0001A\u0002\u0003\u0005\u000b\u0015B/\t\u0017\u0005\u001d\u0002\u00011AA\u0002\u0013%\u0011\u0011\u0006\u0005\f\u0003k\u0001\u0001\u0019!a\u0001\n\u0013\t9\u0004C\u0006\u0002<\u0001\u0001\r\u0011!Q!\n\u0005-\u0002\"CA\u001f\u0001\u0001\u0007I\u0011BA \u0011%\t\t\u0006\u0001a\u0001\n\u0013\t\u0019\u0006\u0003\u0005\u0002X\u0001\u0001\u000b\u0015BA!\u0011%\tI\u0006\u0001b\u0001\n\u0013\tY\u0006\u0003\u0005\u0002v\u0001\u0001\u000b\u0011BA/\u0011\u001d\t9\b\u0001C!\u0003sBq!!!\u0001\t\u0003\n\u0019\tC\u0004\u0002\u0006\u0002!\t%a\"\t\u000f\u0005%\u0005\u0001\"\u0003\u0002\f\"9\u0011\u0011\u0013\u0001\u0005\u0002\u0005M\u0005\"CAX\u0001E\u0005I\u0011AAY\u0011\u001d\t9\r\u0001C\u0001\u0003\u0013Dq!!6\u0001\t\u0003\t9NA\nTi\u0006\u001c\u0007+\u0019:uSRLwN\u001c*fC\u0012,'O\u0003\u0002\u001f?\u0005!1\u000f^1d\u0015\t\u0001\u0013%\u0001\u0002j_*\u0011!eI\u0001\u000bg\u0016$wN\\1`gFd'B\u0001\u0013&\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003M\u001d\nQa\u001d9be.T!\u0001K\u0015\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0013aA8sO\u000e\u00011c\u0001\u0001.kA\u0011afM\u0007\u0002_)\u0011\u0001'M\u0001\u0005Y\u0006twMC\u00013\u0003\u0011Q\u0017M^1\n\u0005Qz#AB(cU\u0016\u001cG\u000fE\u00027wuj\u0011a\u000e\u0006\u0003qe\nAA]3bI*\u0011!hI\u0001\nG>tg.Z2u_JL!\u0001P\u001c\u0003\u001fA\u000b'\u000f^5uS>t'+Z1eKJ\u0004\"AP!\u000e\u0003}R!\u0001Q\u0012\u0002\u0011\r\fG/\u00197zgRL!AQ \u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\na\u0006\u0014H/\u001b;j_:\u0004\"!\u0012$\u000e\u0003uI!aR\u000f\u0003\u001bM#\u0018m\u0019)beRLG/[8o\u0003\u0019\u00198\r[3nCB\u0011!*T\u0007\u0002\u0017*\u0011AjI\u0001\u0006if\u0004Xm]\u0005\u0003\u001d.\u0013!b\u0015;sk\u000e$H+\u001f9f\u0003\u0011y\u0007\u000f^:\u0011\tESV,\u0018\b\u0003%b\u0003\"a\u0015,\u000e\u0003QS!!V\u0016\u0002\rq\u0012xn\u001c;?\u0015\u00059\u0016!B:dC2\f\u0017BA-W\u0003\u0019\u0001&/\u001a3fM&\u00111\f\u0018\u0002\u0004\u001b\u0006\u0004(BA-W!\t\tf,\u0003\u0002`9\n11\u000b\u001e:j]\u001e\fQb\u001d9bi&\fGNR5mi\u0016\u0014\bc\u00012dK6\ta+\u0003\u0002e-\n1q\n\u001d;j_:\u0004\"AZ7\u000e\u0003\u001dT!\u0001[5\u0002\u000fA\f'/];fi*\u0011!n[\u0001\fI\u0006$\u0018m]8ve\u000e,7O\u0003\u0002mG\u0005IQ\r_3dkRLwN\\\u0005\u0003]\u001e\u0014qcR3p!\u0006\u0014\u0018/^3u'B\fG/[1m\r&dG/\u001a:\u0002\u001dQ,W\u000e]8sC24\u0015\u000e\u001c;feB\u0019!mY9\u0011\u0005I4X\"A:\u000b\u0005y!(BA;l\u0003)!\u0017\r^1t_V\u00148-Z\u0005\u0003oN\u0014a\u0002V3na>\u0014\u0018\r\u001c$jYR,'/\u0001\u0004=S:LGO\u0010\u000b\u0007undXP`@\u0011\u0005\u0015\u0003\u0001\"B\"\u0007\u0001\u0004!\u0005\"\u0002%\u0007\u0001\u0004I\u0005\"B(\u0007\u0001\u0004\u0001\u0006\"\u00021\u0007\u0001\u0004\t\u0007\"B8\u0007\u0001\u0004\u0001\u0018!D5uK6\u001c\u0018\n^3sCR|'/\u0006\u0002\u0002\u0006A)\u0011qAA\u0007;6\u0011\u0011\u0011\u0002\u0006\u0004\u0003\u00171\u0016AC2pY2,7\r^5p]&!\u0011qBA\u0005\u0005!IE/\u001a:bi>\u0014\u0018AD5uK6\u001c\u0018\n^3sCR|'\u000fI\u0001\fGV\u0014(/\u001a8u\u0013R,W.F\u0001^\u0003=\u0019WO\u001d:f]RLE/Z7`I\u0015\fH\u0003BA\u000e\u0003C\u00012AYA\u000f\u0013\r\tyB\u0016\u0002\u0005+:LG\u000f\u0003\u0005\u0002$)\t\t\u00111\u0001^\u0003\rAH%M\u0001\rGV\u0014(/\u001a8u\u0013R,W\u000eI\u0001\fGV\u0014(/\u001a8u\r&dW-\u0006\u0002\u0002,A!\u0011QFA\u0019\u001b\t\tyC\u0003\u0002!c%!\u00111GA\u0018\u0005\u00111\u0015\u000e\\3\u0002\u001f\r,(O]3oi\u001aKG.Z0%KF$B!a\u0007\u0002:!I\u00111E\u0007\u0002\u0002\u0003\u0007\u00111F\u0001\rGV\u0014(/\u001a8u\r&dW\rI\u0001\u0010M\u0016\fG/\u001e:f\u0013R,'/\u0019;peV\u0011\u0011\u0011\t\t\u0006\u0003\u0007\ni%\u0010\b\u0005\u0003\u000b\nIED\u0002T\u0003\u000fJ\u0011aV\u0005\u0004\u0003\u00172\u0016a\u00029bG.\fw-Z\u0005\u0005\u0003\u001f\tyEC\u0002\u0002LY\u000b1CZ3biV\u0014X-\u0013;fe\u0006$xN]0%KF$B!a\u0007\u0002V!I\u00111\u0005\t\u0002\u0002\u0003\u0007\u0011\u0011I\u0001\u0011M\u0016\fG/\u001e:f\u0013R,'/\u0019;pe\u0002\na!\\1qa\u0016\u0014XCAA/!\u0011\ty&!\u001d\u000e\u0005\u0005\u0005$\u0002BA2\u0003K\n\u0001\u0002Z1uC\nLg\u000e\u001a\u0006\u0005\u0003O\nI'A\u0004kC\u000e\\7o\u001c8\u000b\t\u0005-\u0014QN\u0001\nM\u0006\u001cH/\u001a:y[2T!!a\u001c\u0002\u0007\r|W.\u0003\u0003\u0002t\u0005\u0005$\u0001D(cU\u0016\u001cG/T1qa\u0016\u0014\u0018aB7baB,'\u000fI\u0001\u0005]\u0016DH\u000f\u0006\u0002\u0002|A\u0019!-! \n\u0007\u0005}dKA\u0004C_>dW-\u00198\u0002\u0007\u001d,G\u000fF\u0001>\u0003\u0015\u0019Gn\\:f)\t\tY\"\u0001\fdQ\u0016\u001c7.\u00118e\t\u0016dW\r^3UK6\u0004h)\u001b7f)\u0011\tY\"!$\t\u000f\u0005=u\u00031\u0001\u0002,\u0005!a-\u001b7f\u0003U1W\r^2i\u0007>tG/\u001a8u/&$\bNU3uef$R!XAK\u0003KCq!a&\u0019\u0001\u0004\tI*A\u0002ve2\u0004B!a'\u0002\"6\u0011\u0011Q\u0014\u0006\u0004\u0003?\u000b\u0014a\u00018fi&!\u00111UAO\u0005\r)&\u000b\u0014\u0005\n\u0003OC\u0002\u0013!a\u0001\u0003S\u000b!\"\\1y%\u0016$(/[3t!\r\u0011\u00171V\u0005\u0004\u0003[3&aA%oi\u0006yb-\u001a;dQ\u000e{g\u000e^3oi^KG\u000f\u001b*fiJLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005M&\u0006BAU\u0003k[#!a.\u0011\t\u0005e\u00161Y\u0007\u0003\u0003wSA!!0\u0002@\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u00034\u0016AC1o]>$\u0018\r^5p]&!\u0011QYA^\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0016GJ,\u0017\r^3QCJ$\u0018\u000e^5p]\u0016$g)\u001b7f)\u0011\tY-a5\u0011\t\u00055\u0017qZ\u0007\u0002S&\u0019\u0011\u0011[5\u0003\u001fA\u000b'\u000f^5uS>tW\r\u001a$jY\u0016Dq!a\n\u001b\u0001\u0004\tY#A\bde\u0016\fG/Z*qCJ\\\u0007+\u0019;i)\ri\u0013\u0011\u001c\u0005\u0007\u00037\\\u0002\u0019A/\u0002\u0015A\fG\u000f[*ue&tw\r")
public class StacPartitionReader
implements PartitionReader<InternalRow> {
    private final StructType schema;
    private final Map<String, String> opts;
    private final Iterator<String> itemsIterator;
    private String currentItem;
    private File currentFile;
    private Iterator<InternalRow> featureIterator;
    private final ObjectMapper mapper;

    public CustomTaskMetric[] currentMetricsValues() {
        return super.currentMetricsValues();
    }

    private Iterator<String> itemsIterator() {
        return this.itemsIterator;
    }

    private String currentItem() {
        return this.currentItem;
    }

    private void currentItem_$eq(String x$1) {
        this.currentItem = x$1;
    }

    private File currentFile() {
        return this.currentFile;
    }

    private void currentFile_$eq(File x$1) {
        this.currentFile = x$1;
    }

    private Iterator<InternalRow> featureIterator() {
        return this.featureIterator;
    }

    private void featureIterator_$eq(Iterator<InternalRow> x$1) {
        this.featureIterator = x$1;
    }

    private ObjectMapper mapper() {
        return this.mapper;
    }

    public boolean next() {
        if (this.featureIterator().hasNext()) {
            return true;
        }
        if (this.itemsIterator().hasNext()) {
            Iterator iterator;
            File tempFile;
            this.currentItem_$eq((String)this.itemsIterator().next());
            if (this.currentItem().startsWith("http://") || this.currentItem().startsWith("https://") || this.currentItem().startsWith("file://")) {
                URL url = new URL(this.currentItem());
                tempFile = File.createTempFile("stac_item_", ".json");
                try (PrintWriter writer = new PrintWriter(tempFile);){
                    String nodeType;
                    String fileContent = this.fetchContentWithRetry(url, this.fetchContentWithRetry$default$2());
                    JsonNode rootNode = this.mapper().readTree(fileContent);
                    String string = nodeType = rootNode.get("type").asText();
                    switch (string == null ? 0 : string.hashCode()) {
                        case -1377727980: {
                            if (!"FeatureCollection".equals(string)) break;
                            JsonNode features = rootNode.get("features");
                            java.util.Iterator featureIterator = features.elements();
                            while (featureIterator.hasNext()) {
                                JsonNode feature = (JsonNode)featureIterator.next();
                                String content = this.mapper().writeValueAsString((Object)feature);
                                writer.write(content);
                                writer.write("\n");
                            }
                        }
                        case 685445846: {
                            if (!"Feature".equals(string)) break;
                            String content = this.mapper().writeValueAsString((Object)rootNode);
                            writer.write(content);
                        }
                    }
                    throw new IllegalArgumentException(new StringBuilder(27).append("Unsupported type for item: ").append(nodeType).toString());
                }
            } else {
                throw new IllegalArgumentException(new StringBuilder(31).append("Unsupported protocol for item: ").append(this.currentItem()).toString());
            }
            this.checkAndDeleteTempFile(this.currentFile());
            this.currentFile_$eq(tempFile);
            if (this.currentFile().exists()) {
                JSONOptionsInRead parsedOptions = new JSONOptionsInRead(this.opts, (String)this.opts.getOrElse((Object)"sessionLocalTimeZone", (Function0 & Serializable)() -> "UTC"), (String)this.opts.getOrElse((Object)"columnNameOfCorruptRecord", (Function0 & Serializable)() -> "_corrupt_record"));
                JsonDataSource dataSource = JsonDataSource$.MODULE$.apply((JSONOptions)parsedOptions);
                StructType alteredSchema = GeoJSONUtils$.MODULE$.updateGeometrySchema(this.schema, (DataType)StringType$.MODULE$);
                JacksonParser parser = SparkCompatUtil$.MODULE$.constructJacksonParser((DataType)alteredSchema, (JSONOptions)parsedOptions, true);
                Iterator<InternalRow> rows = SparkCompatUtil$.MODULE$.readFile(dataSource, new Configuration(), this.createPartitionedFile(this.currentFile()), parser, this.schema);
                iterator = rows.map((Function1 & Serializable)row -> {
                    InternalRow geometryConvertedRow = GeoJSONUtils$.MODULE$.convertGeoJsonToGeometry((InternalRow)row, alteredSchema);
                    InternalRow rasterAddedRow = StacUtils$.MODULE$.buildOutDbRasterFields(geometryConvertedRow, alteredSchema);
                    InternalRow propertiesPromotedRow = StacUtils$.MODULE$.promotePropertiesToTop(rasterAddedRow, alteredSchema);
                    return propertiesPromotedRow;
                });
            } else {
                iterator = package$.MODULE$.Iterator().empty();
            }
            this.featureIterator_$eq((Iterator<InternalRow>)iterator);
            return this.next();
        }
        return false;
    }

    public InternalRow get() {
        return (InternalRow)this.featureIterator().next();
    }

    public void close() {
        this.checkAndDeleteTempFile(this.currentFile());
    }

    private void checkAndDeleteTempFile(File file) {
        if (file != null && file.exists() && file.getAbsolutePath().startsWith(System.getProperty("java.io.tmpdir"))) {
            file.delete();
            return;
        }
    }

    public String fetchContentWithRetry(URL url, int maxRetries) {
        int attempt = 0;
        boolean success = false;
        String fileContent = "";
        while (attempt < maxRetries && !success) {
            try {
                fileContent = Source$.MODULE$.fromURL(url, Codec$.MODULE$.fallbackSystemCodec()).mkString();
                success = true;
            }
            catch (Exception e) {
                if (++attempt < maxRetries) continue;
                throw new RuntimeException(new StringBuilder(48).append("Failed to fetch content from URL after ").append(maxRetries).append(" attempts").toString(), e);
            }
        }
        return fileContent;
    }

    public int fetchContentWithRetry$default$2() {
        return 3;
    }

    public PartitionedFile createPartitionedFile(File currentFile) {
        Object[] objectArray;
        Class<?> partitionedFileClass = Class.forName("org.apache.spark.sql.execution.datasources.PartitionedFile");
        Constructor[] constructors = partitionedFileClass.getConstructors();
        Constructor constructor = (Constructor)ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])constructors), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)StacPartitionReader.$anonfun$createPartitionedFile$1(x$3))).getOrElse((Function0 & Serializable)() -> (Constructor)ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])constructors), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)StacPartitionReader.$anonfun$createPartitionedFile$3(x$4))).getOrElse((Function0 & Serializable)() -> {
            throw new NoSuchMethodException("No constructor with 7 or 8 parameters found");
        }));
        if (constructor.getParameterCount() == 7) {
            Class<?> secondParamType = constructor.getParameterTypes()[1];
            String string = secondParamType.getName();
            String string2 = "org.apache.spark.paths.SparkPath";
            objectArray = !(string != null ? !string.equals(string2) : string2 != null) ? new Object[]{null, this.createSparkPath(currentFile.getPath()), 0L, currentFile.length(), Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), 0L, 0L} : new Object[]{null, currentFile.getPath(), 0L, currentFile.length(), Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), 0L, 0L};
        } else {
            objectArray = new Object[]{null, this.createSparkPath(currentFile.getPath()), 0L, currentFile.length(), Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), 0L, 0L, null};
        }
        Object[] params = objectArray;
        return (PartitionedFile)constructor.newInstance(params);
    }

    public Object createSparkPath(String pathString) {
        Class<?> sparkPathClass = Class.forName("org.apache.spark.paths.SparkPath");
        Constructor<?> constructor = sparkPathClass.getDeclaredConstructor(String.class);
        constructor.setAccessible(true);
        return constructor.newInstance(pathString);
    }

    public static final /* synthetic */ boolean $anonfun$createPartitionedFile$1(Constructor x$3) {
        return x$3.getParameterCount() == 7;
    }

    public static final /* synthetic */ boolean $anonfun$createPartitionedFile$3(Constructor x$4) {
        return x$4.getParameterCount() == 8;
    }

    public StacPartitionReader(StacPartition partition, StructType schema, Map<String, String> opts, Option<GeoParquetSpatialFilter> spatialFilter, Option<TemporalFilter> temporalFilter) {
        this.schema = schema;
        this.opts = opts;
        this.itemsIterator = ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.refArrayOps((Object[])partition.items()));
        this.featureIterator = package$.MODULE$.Iterator().empty();
        this.mapper = new ObjectMapper();
    }
}

