/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.spatialPartitioning;

import java.util.Iterator;
import javax.annotation.Nullable;
import org.apache.sedona.core.enums.GridType;
import org.apache.sedona.core.joinJudgement.DedupParams;
import org.apache.sedona.core.spatialPartitioning.SpatialPartitioner;
import org.apache.sedona.core.spatialPartitioning.quadtree.StandardQuadTree;
import org.locationtech.jts.geom.Geometry;
import scala.Tuple2;

public class QuadTreePartitioner
extends SpatialPartitioner {
    private final StandardQuadTree<?> quadTree;

    public QuadTreePartitioner(StandardQuadTree<?> quadTree) {
        super(GridType.QUADTREE, quadTree.fetchLeafZones());
        this.quadTree = quadTree;
        this.quadTree.dropElements();
    }

    public Iterator<Tuple2<Integer, Geometry>> placeObject(Geometry spatialObject) throws Exception {
        return this.quadTree.placeObject(spatialObject);
    }

    @Override
    @Nullable
    public DedupParams getDedupParams() {
        return new DedupParams(this.grids);
    }

    public int numPartitions() {
        return this.grids.size();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof QuadTreePartitioner)) {
            return false;
        }
        QuadTreePartitioner other = (QuadTreePartitioner)o;
        return other.quadTree.equals(this.quadTree);
    }
}

