/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Objects;
import com.google.common.geometry.S2Point;
import java.io.Serializable;
import javax.annotation.Nullable;

@GwtCompatible(serializable=true)
public final class S2AreaCentroid
implements Serializable {
    private final double area;
    private final S2Point centroid;

    public S2AreaCentroid(double area, @Nullable S2Point centroid) {
        this.area = area;
        this.centroid = centroid;
    }

    public double getArea() {
        return this.area;
    }

    @Nullable
    public S2Point getCentroid() {
        return this.centroid;
    }

    public boolean equals(Object obj) {
        if (obj instanceof S2AreaCentroid) {
            S2AreaCentroid that = (S2AreaCentroid)obj;
            return this.area == that.area && Objects.equal(this.centroid, that.centroid);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.area, this.centroid);
    }
}

