/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.writer2;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataComposite;
import ucar.ma2.StructureDataFromMember;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.Dimension;
import ucar.nc2.Structure;
import ucar.nc2.VariableSimpleBuilder;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.CF;
import ucar.nc2.dataset.conv.CF1Convention;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.ProfileFeature;
import ucar.nc2.ft.StationProfileFeature;
import ucar.nc2.ft.point.StationFeature;
import ucar.nc2.ft.point.writer2.CFPointWriterConfig;
import ucar.nc2.ft.point.writer2.CFPointWriterUtils;
import ucar.nc2.ft.point.writer2.WriterCFPointAbstract;
import ucar.nc2.time.CalendarDateUnit;

class WriterCFStationProfileCollection
extends WriterCFPointAbstract {
    private static Logger log = LoggerFactory.getLogger(WriterCFStationProfileCollection.class);
    private List<StationFeature> stnList;
    private Structure stationStruct;
    private HashMap<String, Integer> stationIndexMap;
    private boolean useDesc;
    private boolean useAlt;
    private boolean useWmoId;
    private int desc_strlen = 1;
    private int wmo_strlen = 1;
    private HashSet<String> stationVarMap = new HashSet();
    private Structure profileStruct;
    private HashSet<String> profileVarMap = new HashSet();
    private boolean headerDone;
    private int stnRecno;
    private int profileRecno;
    private int obsRecno;

    WriterCFStationProfileCollection(String fileOut, AttributeContainer globalAtts, List<VariableSimpleIF> dataVars, CalendarDateUnit timeUnit, String altUnits, CFPointWriterConfig config) throws IOException {
        super(fileOut, globalAtts, dataVars, timeUnit, altUnits, config);
        this.writerb.addAttribute(new Attribute("featureType", CF.FeatureType.timeSeriesProfile.name()));
        this.writerb.addAttribute(new Attribute("DSG_representation", "Ragged array representation of time series profiless, H.5.3"));
    }

    void setStations(List<StationFeature> stns) {
        this.stnList = stns;
        for (StationFeature stn : this.stnList) {
            if (!Double.isNaN(stn.getAltitude())) {
                this.useAlt = true;
            }
            if (stn.getWmoId() != null && !stn.getWmoId().trim().isEmpty()) {
                this.useWmoId = true;
            }
            if (stn.getDescription() != null && !stn.getDescription().trim().isEmpty()) {
                this.useDesc = true;
            }
            this.id_strlen = Math.max(this.id_strlen, stn.getName().length());
            if (stn.getDescription() != null) {
                this.desc_strlen = Math.max(this.desc_strlen, stn.getDescription().length());
            }
            if (stn.getWmoId() == null) continue;
            this.wmo_strlen = Math.max(this.wmo_strlen, stn.getWmoId().length());
        }
        this.llbb = CFPointWriterUtils.getBoundingBox(this.stnList);
    }

    int writeProfile(StationProfileFeature spf, ProfileFeature profile) throws IOException {
        int count = 0;
        for (PointFeature pf : profile) {
            if (!this.headerDone) {
                if (this.id_strlen == 0) {
                    this.id_strlen = profile.getName().length() * 2;
                }
                this.writeHeader(spf, profile, pf);
                this.headerDone = true;
            }
            this.writeObsData(pf);
            ++count;
        }
        Integer stnIndex = this.stationIndexMap.get(spf.getName());
        if (stnIndex == null) {
            log.warn("BAD station {}", (Object)spf.getName());
        } else {
            this.writeProfileData(stnIndex, profile, count);
        }
        return count;
    }

    private void writeHeader(StationProfileFeature stn, ProfileFeature profile, PointFeature obs) throws IOException {
        StructureData stnData = stn.getFeatureData();
        StructureData profileData = profile.getFeatureData();
        StructureData obsData = obs.getFeatureData();
        ArrayList<VariableSimpleIF> obsCoords = new ArrayList<VariableSimpleIF>();
        Formatter coordNames = new Formatter().format("%s %s %s", "profileTime", "latitude", "longitude");
        obsCoords.add(VariableSimpleBuilder.makeScalar(this.altitudeCoordinateName, "obs altitude", this.altUnits, DataType.DOUBLE).addAttribute("standard_name", "altitude").addAttribute("positive", CF1Convention.getZisPositive(this.altitudeCoordinateName, this.altUnits)).build());
        coordNames.format(" %s", this.altitudeCoordinateName);
        super.writeHeader(obsCoords, stnData, profileData, obsData, coordNames.toString());
        int count = 0;
        this.stationIndexMap = new HashMap(2 * this.stnList.size());
        for (StationFeature sf : this.stnList) {
            this.writeStationData(sf);
            this.stationIndexMap.put(sf.getName(), count);
            ++count;
        }
    }

    @Override
    void makeFeatureVariables(StructureData stnData, boolean isExtended) {
        Dimension stationDim = this.writerb.addDimension("station", this.stnList.size());
        ArrayList<VariableSimpleIF> stnVars = new ArrayList<VariableSimpleIF>();
        stnVars.add(VariableSimpleBuilder.makeScalar("latitude", "station latitude", "degrees_north", DataType.DOUBLE).build());
        stnVars.add(VariableSimpleBuilder.makeScalar("longitude", "station longitude", "degrees_east", DataType.DOUBLE).build());
        if (this.useAlt) {
            stnVars.add(VariableSimpleBuilder.makeScalar("stationAltitude", "station altitude", this.altUnits, DataType.DOUBLE).addAttribute("standard_name", "surface_altitude").addAttribute("positive", CF1Convention.getZisPositive("altitude", this.altUnits)).build());
        }
        stnVars.add(VariableSimpleBuilder.makeString("station_id", "station identifier", null, this.id_strlen).addAttribute("cf_role", "timeseries_id").build());
        if (this.useDesc) {
            stnVars.add(VariableSimpleBuilder.makeString("station_description", "station description", null, this.desc_strlen).addAttribute("standard_name", "platform_name").build());
        }
        if (this.useWmoId) {
            stnVars.add(VariableSimpleBuilder.makeString("wmo_id", "station WMO id", null, this.wmo_strlen).addAttribute("standard_name", "platform_id").build());
        }
        for (StructureMembers.Member m3 : stnData.getMembers()) {
            if (this.findDataVar(m3.getName()) == null) continue;
            stnVars.add(VariableSimpleBuilder.fromMember(m3).build());
        }
        if (isExtended) {
            Structure.Builder structb = this.writerb.addStructure("station", "station");
            this.addCoordinatesExtended(structb, stnVars);
        } else {
            this.addCoordinatesClassic(stationDim, stnVars, this.stationVarMap);
        }
    }

    private void writeStationData(StationFeature stn) throws IOException {
        StructureMembers.Builder smb = StructureMembers.builder().setName("Coords");
        smb.addMemberScalar("latitude", null, null, DataType.DOUBLE, stn.getLatLon().getLatitude());
        smb.addMemberScalar("longitude", null, null, DataType.DOUBLE, stn.getLatLon().getLongitude());
        if (this.useAlt) {
            smb.addMemberScalar("stationAltitude", null, null, DataType.DOUBLE, stn.getAltitude());
        }
        smb.addMemberString("station_id", null, null, stn.getName().trim(), this.id_strlen);
        if (this.useDesc) {
            smb.addMemberString("station_description", null, null, stn.getDescription().trim(), this.desc_strlen);
        }
        if (this.useWmoId) {
            smb.addMemberString("wmo_id", null, null, stn.getWmoId().trim(), this.wmo_strlen);
        }
        StructureDataFromMember stnCoords = new StructureDataFromMember(smb.build());
        StructureDataComposite sdall = StructureDataComposite.create(ImmutableList.of(stnCoords, stn.getFeatureData()));
        this.stnRecno = super.writeStructureData(this.stnRecno, this.stationStruct, sdall, this.stationVarMap);
    }

    @Override
    void makeMiddleVariables(StructureData profileData, boolean isExtended) {
        Dimension profileDim = this.writerb.addDimension("profile", this.nfeatures);
        ArrayList<VariableSimpleIF> profileVars = new ArrayList<VariableSimpleIF>();
        profileVars.add(VariableSimpleBuilder.makeString("profileId", "profile identifier", null, this.id_strlen).addAttribute("cf_role", "profile_id").addAttribute("missing_value", String.valueOf(-9999)).build());
        profileVars.add(VariableSimpleBuilder.makeScalar("nobs", "number of obs for this profile", null, DataType.INT).addAttribute("sample_dimension", "obs").build());
        profileVars.add(VariableSimpleBuilder.makeScalar("profileTime", "nominal time of profile", this.timeUnit.getUdUnit(), DataType.DOUBLE).addAttribute("calendar", this.timeUnit.getCalendar().toString()).build());
        profileVars.add(VariableSimpleBuilder.makeScalar("stationIndex", "station index for this profile", null, DataType.INT).addAttribute("instance_dimension", "station").build());
        for (StructureMembers.Member m3 : profileData.getMembers()) {
            VariableSimpleIF dv = this.findDataVar(m3.getName());
            if (dv == null) continue;
            profileVars.add(dv);
        }
        if (isExtended) {
            Structure.Builder structb = this.writerb.addStructure("profile", "profile");
            this.addCoordinatesExtended(structb, profileVars);
        } else {
            this.addCoordinatesClassic(profileDim, profileVars, this.profileVarMap);
        }
    }

    @Override
    void finishBuilding() throws IOException {
        super.finishBuilding();
        this.stationStruct = this.findStructure("station");
        this.profileStruct = this.findStructure("profile");
    }

    private void writeProfileData(int stnIndex, ProfileFeature profile, int nobs) throws IOException {
        this.trackBB(profile.getLatLon(), profile.getTime());
        StructureMembers.Builder smb = StructureMembers.builder().setName("Coords");
        smb.addMemberScalar("latitude", null, null, DataType.DOUBLE, profile.getLatLon().getLatitude());
        smb.addMemberScalar("longitude", null, null, DataType.DOUBLE, profile.getLatLon().getLongitude());
        double timeInMyUnits = this.timeUnit.makeOffsetFromRefDate(profile.getTime());
        smb.addMemberScalar("profileTime", null, null, DataType.DOUBLE, timeInMyUnits);
        smb.addMemberString("profileId", null, null, profile.getName().trim(), this.id_strlen);
        smb.addMemberScalar("nobs", null, null, DataType.INT, nobs);
        smb.addMemberScalar("stationIndex", null, null, DataType.INT, stnIndex);
        StructureDataFromMember profileCoords = new StructureDataFromMember(smb.build());
        StructureDataComposite sdall = StructureDataComposite.create(ImmutableList.of(profileCoords, profile.getFeatureData()));
        this.profileRecno = super.writeStructureData(this.profileRecno, this.profileStruct, sdall, this.profileVarMap);
    }

    private void writeObsData(PointFeature pf) throws IOException {
        StructureMembers.Builder smb = StructureMembers.builder().setName("Coords");
        smb.addMemberScalar(this.altitudeCoordinateName, null, null, DataType.DOUBLE, pf.getLocation().getAltitude());
        StructureDataFromMember coords = new StructureDataFromMember(smb.build());
        StructureDataComposite sdall = StructureDataComposite.create(ImmutableList.of(coords, pf.getFeatureData()));
        this.obsRecno = super.writeStructureData(this.obsRecno, this.record, sdall, this.dataMap);
    }
}

