/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.io.raster;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.sedona_sql.io.raster.RasterFileWriter;
import org.apache.spark.sql.sedona_sql.io.raster.RasterOptions;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005q4QAB\u0004\u0001\u001fUAQA\u000b\u0001\u0005\u00021BQa\f\u0001\u0005BABQa\u0019\u0001\u0005B\u0011DQ\u0001\u001e\u0001\u0005BUDQA\u001e\u0001\u0005\n]\u0014\u0001CU1ti\u0016\u0014h)\u001b7f\r>\u0014X.\u0019;\u000b\u0005!I\u0011A\u0002:bgR,'O\u0003\u0002\u000b\u0017\u0005\u0011\u0011n\u001c\u0006\u0003\u00195\t!b]3e_:\fwl]9m\u0015\tqq\"A\u0002tc2T!\u0001E\t\u0002\u000bM\u0004\u0018M]6\u000b\u0005I\u0019\u0012AB1qC\u000eDWMC\u0001\u0015\u0003\ry'oZ\n\u0005\u0001YaB\u0005\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002D\u0001\u0004B]f\u0014VM\u001a\t\u0003;\tj\u0011A\b\u0006\u0003?\u0001\n1\u0002Z1uCN|WO]2fg*\u0011\u0011%D\u0001\nKb,7-\u001e;j_:L!a\t\u0010\u0003\u0015\u0019KG.\u001a$pe6\fG\u000f\u0005\u0002&Q5\taE\u0003\u0002(\u001b\u000591o\\;sG\u0016\u001c\u0018BA\u0015'\u0005I!\u0015\r^1T_V\u00148-\u001a*fO&\u001cH/\u001a:\u0002\rqJg.\u001b;?\u0007\u0001!\u0012!\f\t\u0003]\u0001i\u0011aB\u0001\fS:4WM]*dQ\u0016l\u0017\r\u0006\u00032u\u0001\u0003\u0006cA\f3i%\u00111\u0007\u0007\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005UBT\"\u0001\u001c\u000b\u0005]j\u0011!\u0002;za\u0016\u001c\u0018BA\u001d7\u0005)\u0019FO];diRK\b/\u001a\u0005\u0006w\t\u0001\r\u0001P\u0001\rgB\f'o[*fgNLwN\u001c\t\u0003{yj\u0011!D\u0005\u0003\u007f5\u0011Ab\u00159be.\u001cVm]:j_:DQ!\u0011\u0002A\u0002\t\u000bqa\u001c9uS>t7\u000f\u0005\u0003D\u00156keB\u0001#I!\t)\u0005$D\u0001G\u0015\t95&\u0001\u0004=e>|GOP\u0005\u0003\u0013b\ta\u0001\u0015:fI\u00164\u0017BA&M\u0005\ri\u0015\r\u001d\u0006\u0003\u0013b\u0001\"a\u0011(\n\u0005=c%AB*ue&tw\rC\u0003R\u0005\u0001\u0007!+A\u0003gS2,7\u000fE\u0002T1ns!\u0001\u0016,\u000f\u0005\u0015+\u0016\"A\r\n\u0005]C\u0012a\u00029bG.\fw-Z\u0005\u00033j\u00131aU3r\u0015\t9\u0006\u0004\u0005\u0002]C6\tQL\u0003\u0002_?\u0006\u0011am\u001d\u0006\u0003AF\ta\u0001[1e_>\u0004\u0018B\u00012^\u0005)1\u0015\u000e\\3Ti\u0006$Xo]\u0001\raJ,\u0007/\u0019:f/JLG/\u001a\u000b\u0006K\"L\u0017O\u001d\t\u0003;\u0019L!a\u001a\u0010\u0003'=+H\u000f];u/JLG/\u001a:GC\u000e$xN]=\t\u000bm\u001a\u0001\u0019\u0001\u001f\t\u000b)\u001c\u0001\u0019A6\u0002\u0007)|'\r\u0005\u0002m_6\tQN\u0003\u0002o?\u0006IQ.\u00199sK\u0012,8-Z\u0005\u0003a6\u00141AS8c\u0011\u0015\t5\u00011\u0001C\u0011\u0015\u00198\u00011\u00015\u0003)!\u0017\r^1TG\",W.Y\u0001\ng\"|'\u000f\u001e(b[\u0016$\u0012!T\u0001\u0014SN4\u0016\r\\5e%\u0006\u001cH/\u001a:TG\",W.\u0019\u000b\u0003qn\u0004\"aF=\n\u0005iD\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006g\u0016\u0001\r\u0001\u000e")
public class RasterFileFormat
implements FileFormat,
DataSourceRegister {
    public boolean supportBatch(SparkSession sparkSession, StructType dataSchema) {
        return FileFormat.supportBatch$((FileFormat)this, (SparkSession)sparkSession, (StructType)dataSchema);
    }

    public Option<Seq<String>> vectorTypes(StructType requiredSchema, StructType partitionSchema, SQLConf sqlConf) {
        return FileFormat.vectorTypes$((FileFormat)this, (StructType)requiredSchema, (StructType)partitionSchema, (SQLConf)sqlConf);
    }

    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        return FileFormat.isSplitable$((FileFormat)this, (SparkSession)sparkSession, options, (Path)path);
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        return FileFormat.buildReader$((FileFormat)this, (SparkSession)sparkSession, (StructType)dataSchema, (StructType)partitionSchema, (StructType)requiredSchema, filters, options, (Configuration)hadoopConf);
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        return FileFormat.buildReaderWithPartitionValues$((FileFormat)this, (SparkSession)sparkSession, (StructType)dataSchema, (StructType)partitionSchema, (StructType)requiredSchema, filters, options, (Configuration)hadoopConf);
    }

    public boolean supportDataType(DataType dataType) {
        return FileFormat.supportDataType$((FileFormat)this, (DataType)dataType);
    }

    public boolean supportFieldName(String name) {
        return FileFormat.supportFieldName$((FileFormat)this, (String)name);
    }

    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        throw new UnsupportedOperationException("Please use 'binaryFile' data source to reading raster files");
    }

    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        RasterOptions rasterOptions = new RasterOptions(options);
        if (!this.isValidRasterSchema(dataSchema)) {
            throw new IllegalArgumentException("Invalid Raster DataFrame Schema");
        }
        return new OutputWriterFactory(null, rasterOptions){
            private final RasterOptions rasterOptions$1;

            public String getFileExtension(TaskAttemptContext context) {
                return "";
            }

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new RasterFileWriter(path, this.rasterOptions$1, dataSchema, context);
            }
            {
                this.rasterOptions$1 = rasterOptions$1;
            }
        };
    }

    public String shortName() {
        return "raster";
    }

    private boolean isValidRasterSchema(StructType dataSchema) {
        BooleanRef imageColExist = BooleanRef.create((boolean)false);
        StructField[] fields = dataSchema.fields();
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1 & Serializable)field -> {
            RasterFileFormat.$anonfun$isValidRasterSchema$1(imageColExist, field);
            return BoxedUnit.UNIT;
        });
        return imageColExist.elem;
    }

    public static final /* synthetic */ void $anonfun$isValidRasterSchema$1(BooleanRef imageColExist$1, StructField field) {
        if (field.dataType().typeName().equals("binary")) {
            imageColExist$1.elem = true;
            return;
        }
    }

    public RasterFileFormat() {
        FileFormat.$init$((FileFormat)this);
    }
}

