/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetMetaData;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetToSparkSchemaConverter$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetUtils$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaConverter$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sedona_sql.UDT.GeometryUDT$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015d\u0001\u0002\f\u0018\u0001\u0019B\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\"AQ\t\u0001B\u0001B\u0003%!\t\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003H\u0011\u0015I\u0005\u0001\"\u0001K\u0011\u001d\t\u0006A1A\u0005\nICaA\u0016\u0001!\u0002\u0013\u0019\u0006\"B%\u0001\t\u00039\u0006\"B%\u0001\t\u0003\u0011\u0007\"B7\u0001\t\u0003q\u0007\"B7\u0001\t\u0013q\bbBA\u0004\u0001\u0011\u0005\u0011\u0011\u0002\u0005\b\u00037\u0001A\u0011BA\u000f\u0011\u001d\t\u0019\u0003\u0001C\u0005\u0003KAq!!\r\u0001\t\u0013\t\u0019\u0004C\u0004\u00028\u0001!\t!!\u000f\b\u0013\u0005\rs#!A\t\u0002\u0005\u0015c\u0001\u0003\f\u0018\u0003\u0003E\t!a\u0012\t\r%\u0013B\u0011AA%\u0011%\tYEEI\u0001\n\u0003\ti\u0005C\u0005\u0002dI\t\n\u0011\"\u0001\u0002N\t\u0001s)Z8QCJ\fX/\u001a;U_N\u0003\u0018M]6TG\",W.Y\"p]Z,'\u000f^3s\u0015\tA\u0012$A\u0004qCJ\fX/\u001a;\u000b\u0005iY\u0012a\u00033bi\u0006\u001cx.\u001e:dKNT!\u0001H\u000f\u0002\u0013\u0015DXmY;uS>t'B\u0001\u0010 \u0003\r\u0019\u0018\u000f\u001c\u0006\u0003A\u0005\nQa\u001d9be.T!AI\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0013aA8sO\u000e\u00011C\u0001\u0001(!\tA3&D\u0001*\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017*\u0005\u0019\te.\u001f*fM\u0006\u00012.Z=WC2,X-T3uC\u0012\u000bG/\u0019\t\u0005_Q2d'D\u00011\u0015\t\t$'\u0001\u0003vi&d'\"A\u001a\u0002\t)\fg/Y\u0005\u0003kA\u00121!T1q!\t9dH\u0004\u00029yA\u0011\u0011(K\u0007\u0002u)\u00111(J\u0001\u0007yI|w\u000e\u001e \n\u0005uJ\u0013A\u0002)sK\u0012,g-\u0003\u0002@\u0001\n11\u000b\u001e:j]\u001eT!!P\u0015\u0002)\u0005\u001c8/^7f\u0005&t\u0017M]=JgN#(/\u001b8h!\tA3)\u0003\u0002ES\t9!i\\8mK\u0006t\u0017AF1tgVlW-\u00138usYJ5\u000fV5nKN$\u0018-\u001c9\u0002\u0015A\f'/Y7fi\u0016\u00148\u000f\u0005\u00038\u0011Z2\u0014BA\u001bA\u0003\u0019a\u0014N\\5u}Q)1*\u0014(P!B\u0011A\nA\u0007\u0002/!)Q&\u0002a\u0001]!9\u0011)\u0002I\u0001\u0002\u0004\u0011\u0005bB#\u0006!\u0003\u0005\rA\u0011\u0005\u0006\r\u0016\u0001\raR\u0001\u0013O\u0016|\u0007+\u0019:rk\u0016$X*\u001a;b\t\u0006$\u0018-F\u0001T!\taE+\u0003\u0002V/\t\u0011r)Z8QCJ\fX/\u001a;NKR\fG)\u0019;b\u0003M9Wm\u001c)beF,X\r^'fi\u0006$\u0015\r^1!)\u0011Y\u0005,W1\t\u000b5B\u0001\u0019\u0001\u0018\t\u000biC\u0001\u0019A.\u0002\t\r|gN\u001a\t\u00039~k\u0011!\u0018\u0006\u0003=v\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003Av\u0013qaU)M\u0007>tg\rC\u0003G\u0011\u0001\u0007q\t\u0006\u0003LG\u0012d\u0007\"B\u0017\n\u0001\u0004q\u0003\"\u0002.\n\u0001\u0004)\u0007C\u00014k\u001b\u00059'B\u0001.i\u0015\tI\u0017%\u0001\u0004iC\u0012|w\u000e]\u0005\u0003W\u001e\u0014QbQ8oM&<WO]1uS>t\u0007\"\u0002$\n\u0001\u00049\u0015aB2p]Z,'\u000f\u001e\u000b\u0003_V\u0004\"\u0001]:\u000e\u0003ET!A]\u000f\u0002\u000bQL\b/Z:\n\u0005Q\f(AC*ueV\u001cG\u000fV=qK\")aO\u0003a\u0001o\u0006i\u0001/\u0019:rk\u0016$8k\u00195f[\u0006\u0004\"\u0001\u001f?\u000e\u0003eT!A_>\u0002\rM\u001c\u0007.Z7b\u0015\tA\u0012%\u0003\u0002~s\nYQ*Z:tC\u001e,G+\u001f9f)\tyw\u0010\u0003\u0004w\u0017\u0001\u0007\u0011\u0011\u0001\t\u0004q\u0006\r\u0011bAA\u0003s\nIqI]8vaRK\b/Z\u0001\u0014G>tg/\u001a:u\r&,G\u000eZ,ji\"<Um\u001c\u000b\u0005\u0003\u0017\t\t\u0002E\u0002q\u0003\u001bI1!a\u0004r\u0005!!\u0015\r^1UsB,\u0007bBA\n\u0019\u0001\u0007\u0011QC\u0001\fa\u0006\u0014\u0018/^3u)f\u0004X\rE\u0002y\u0003/I1!!\u0007z\u0005\u0011!\u0016\u0010]3\u0002\u001f%\u001cx)Z8nKR\u0014\u0018PR5fY\u0012$2AQA\u0010\u0011\u0019\t\t#\u0004a\u0001m\u0005Ia-[3mI:\u000bW.Z\u0001\u0016G>tg/\u001a:u!JLW.\u001b;jm\u00164\u0015.\u001a7e)\u0011\tY!a\n\t\u000f\u0005%b\u00021\u0001\u0002,\u0005)a-[3mIB\u0019\u00010!\f\n\u0007\u0005=\u0012PA\u0007Qe&l\u0017\u000e^5wKRK\b/Z\u0001\u0012G>tg/\u001a:u\u000fJ|W\u000f\u001d$jK2$G\u0003BA\u0006\u0003kAq!!\u000b\u0010\u0001\u0004\t\t!\u0001\u000bjg\u0016cW-\\3oiRK\b/Z,ji\"<Um\u001c\u000b\u0006\u0005\u0006m\u0012q\b\u0005\b\u0003{\u0001\u0002\u0019AA\u000b\u00031\u0011X\r]3bi\u0016$G+\u001f9f\u0011\u0019\t\t\u0005\u0005a\u0001m\u0005Q\u0001/\u0019:f]Rt\u0015-\\3\u0002A\u001d+w\u000eU1scV,G\u000fV8Ta\u0006\u00148nU2iK6\f7i\u001c8wKJ$XM\u001d\t\u0003\u0019J\u0019\"AE\u0014\u0015\u0005\u0005\u0015\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0002P)\u001a!)!\u0015,\u0005\u0005M\u0003\u0003BA+\u0003?j!!a\u0016\u000b\t\u0005e\u00131L\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0018*\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003C\n9FA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0004")
public class GeoParquetToSparkSchemaConverter {
    private final boolean assumeBinaryIsString;
    private final boolean assumeInt96IsTimestamp;
    private final GeoParquetMetaData geoParquetMetaData;

    public static boolean $lessinit$greater$default$3() {
        return GeoParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$3();
    }

    public static boolean $lessinit$greater$default$2() {
        return GeoParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$2();
    }

    private GeoParquetMetaData geoParquetMetaData() {
        return this.geoParquetMetaData;
    }

    public StructType convert(MessageType parquetSchema) {
        return this.convert(parquetSchema.asGroupType());
    }

    private StructType convert(GroupType parquetSchema) {
        Buffer fields = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(parquetSchema.getFields()).asScala()).map((Function1 & Serializable & scala.Serializable)field -> {
            StructField structField;
            Type.Repetition repetition = field.getRepetition();
            if (Type.Repetition.OPTIONAL.equals(repetition)) {
                structField = new StructField(field.getName(), this.convertFieldWithGeo((Type)field), true, StructField$.MODULE$.apply$default$4());
            } else if (Type.Repetition.REQUIRED.equals(repetition)) {
                structField = new StructField(field.getName(), this.convertFieldWithGeo((Type)field), false, StructField$.MODULE$.apply$default$4());
            } else if (Type.Repetition.REPEATED.equals(repetition)) {
                ArrayType arrayType = new ArrayType(this.convertFieldWithGeo((Type)field), false);
                structField = new StructField(field.getName(), (DataType)arrayType, false, StructField$.MODULE$.apply$default$4());
            } else {
                throw new MatchError((Object)repetition);
            }
            return structField;
        }, Buffer$.MODULE$.canBuildFrom());
        return StructType$.MODULE$.apply(fields.toSeq());
    }

    public DataType convertFieldWithGeo(Type parquetType) {
        DataType dataType;
        Type type = parquetType;
        if (type instanceof PrimitiveType) {
            PrimitiveType primitiveType = (PrimitiveType)type;
            dataType = this.convertPrimitiveField(primitiveType);
        } else if (type instanceof GroupType) {
            GroupType groupType = (GroupType)type;
            dataType = this.convertGroupField(groupType.asGroupType());
        } else {
            throw new MatchError((Object)type);
        }
        return dataType;
    }

    private boolean isGeometryField(String fieldName) {
        return this.geoParquetMetaData().columns().contains((Object)fieldName);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private DataType convertPrimitiveField(PrimitiveType field) {
        block38: {
            block44: {
                block46: {
                    block45: {
                        block43: {
                            block42: {
                                block41: {
                                    block40: {
                                        block39: {
                                            block37: {
                                                typeName = field.getPrimitiveTypeName();
                                                originalType = field.getOriginalType();
                                                var12_4 = typeName;
                                                if (!PrimitiveType.PrimitiveTypeName.BOOLEAN.equals(var12_4)) break block37;
                                                var2_5 = BooleanType$.MODULE$;
                                                break block38;
                                            }
                                            if (!PrimitiveType.PrimitiveTypeName.FLOAT.equals(var12_4)) break block39;
                                            var2_5 = FloatType$.MODULE$;
                                            break block38;
                                        }
                                        if (!PrimitiveType.PrimitiveTypeName.DOUBLE.equals(var12_4)) break block40;
                                        var2_5 = DoubleType$.MODULE$;
                                        break block38;
                                    }
                                    if (!PrimitiveType.PrimitiveTypeName.INT32.equals(var12_4)) break block41;
                                    var13_6 = originalType;
                                    if (OriginalType.INT_8.equals(var13_6)) {
                                        var8_7 = ByteType$.MODULE$;
                                    } else if (OriginalType.INT_16.equals(var13_6)) {
                                        var8_7 = ShortType$.MODULE$;
                                    } else {
                                        var9_8 = OriginalType.INT_32.equals(var13_6) != false ? true : var13_6 == null;
                                        if (var9_8) {
                                            var8_7 = IntegerType$.MODULE$;
                                        } else if (OriginalType.DATE.equals(var13_6)) {
                                            var8_7 = DateType$.MODULE$;
                                        } else if (OriginalType.DECIMAL.equals(var13_6)) {
                                            var8_7 = GeoParquetToSparkSchemaConverter.makeDecimalType$1(Decimal$.MODULE$.MAX_INT_DIGITS(), field, typeName);
                                        } else {
                                            if (OriginalType.UINT_8.equals(var13_6)) {
                                                throw GeoParquetToSparkSchemaConverter.typeNotSupported$1(originalType, typeName);
                                            }
                                            if (OriginalType.UINT_16.equals(var13_6)) {
                                                throw GeoParquetToSparkSchemaConverter.typeNotSupported$1(originalType, typeName);
                                            }
                                            if (OriginalType.UINT_32.equals(var13_6)) {
                                                throw GeoParquetToSparkSchemaConverter.typeNotSupported$1(originalType, typeName);
                                            }
                                            if (OriginalType.TIME_MILLIS.equals(var13_6)) {
                                                throw GeoParquetToSparkSchemaConverter.typeNotImplemented$1(originalType, typeName);
                                            }
                                            throw GeoParquetToSparkSchemaConverter.illegalType$1(originalType, typeName);
                                        }
                                    }
                                    var2_5 = var8_7;
                                    break block38;
                                }
                                if (!PrimitiveType.PrimitiveTypeName.INT64.equals(var12_4)) break block42;
                                var14_9 = originalType;
                                var7_10 = OriginalType.INT_64.equals(var14_9) != false ? true : var14_9 == null;
                                if (var7_10) {
                                    var6_11 = LongType$.MODULE$;
                                } else if (OriginalType.DECIMAL.equals(var14_9)) {
                                    var6_11 = GeoParquetToSparkSchemaConverter.makeDecimalType$1(Decimal$.MODULE$.MAX_LONG_DIGITS(), field, typeName);
                                } else {
                                    if (OriginalType.UINT_64.equals(var14_9)) {
                                        throw GeoParquetToSparkSchemaConverter.typeNotSupported$1(originalType, typeName);
                                    }
                                    if (OriginalType.TIMESTAMP_MICROS.equals(var14_9)) {
                                        var6_11 = TimestampType$.MODULE$;
                                    } else if (OriginalType.TIMESTAMP_MILLIS.equals(var14_9)) {
                                        var6_11 = TimestampType$.MODULE$;
                                    } else {
                                        throw GeoParquetToSparkSchemaConverter.illegalType$1(originalType, typeName);
                                    }
                                }
                                var2_5 = var6_11;
                                break block38;
                            }
                            if (!PrimitiveType.PrimitiveTypeName.INT96.equals(var12_4)) break block43;
                            ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Z, $anonfun$convertPrimitiveField$2(org.apache.spark.sql.execution.datasources.parquet.GeoParquetToSparkSchemaConverter ), ()Z)((GeoParquetToSparkSchemaConverter)this), new StringBuilder(88).append("INT96 is not supported unless it's interpreted as timestamp. ").append("Please try to set ").append(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key()).append(" to true.").toString());
                            var2_5 = TimestampType$.MODULE$;
                            break block38;
                        }
                        if (!PrimitiveType.PrimitiveTypeName.BINARY.equals(var12_4)) break block44;
                        var15_12 = false;
                        var16_13 = null;
                        var17_14 = originalType;
                        var5_15 = OriginalType.UTF8.equals(var17_14) != false ? true : (OriginalType.ENUM.equals(var17_14) != false ? true : OriginalType.JSON.equals(var17_14) != false);
                        if (!var5_15) break block45;
                        var4_16 /* !! */  = StringType$.MODULE$;
                        break block46;
                    }
                    if (var17_14 != null) ** GOTO lbl-1000
                    var15_12 = true;
                    var16_13 = var17_14;
                    if (this.isGeometryField(field.getName())) {
                        var4_16 /* !! */  = GeometryUDT$.MODULE$;
                    } else if (var15_12 && this.assumeBinaryIsString) {
                        var4_16 /* !! */  = StringType$.MODULE$;
                    } else if (var15_12) {
                        var4_16 /* !! */  = BinaryType$.MODULE$;
                    } else if (OriginalType.BSON.equals(var17_14)) {
                        var4_16 /* !! */  = BinaryType$.MODULE$;
                    } else if (OriginalType.DECIMAL.equals(var17_14)) {
                        var4_16 /* !! */  = GeoParquetToSparkSchemaConverter.makeDecimalType$1(GeoParquetToSparkSchemaConverter.makeDecimalType$default$1$1(), field, typeName);
                    } else {
                        throw GeoParquetToSparkSchemaConverter.illegalType$1(originalType, typeName);
                    }
                }
                var2_5 = var4_16 /* !! */ ;
                break block38;
            }
            if (PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY.equals(var12_4)) {
                var18_17 = originalType;
                if (!OriginalType.DECIMAL.equals(var18_17)) {
                    if (OriginalType.INTERVAL.equals(var18_17)) {
                        throw GeoParquetToSparkSchemaConverter.typeNotImplemented$1(originalType, typeName);
                    }
                    throw GeoParquetToSparkSchemaConverter.illegalType$1(originalType, typeName);
                }
                var3_18 = GeoParquetToSparkSchemaConverter.makeDecimalType$1(Decimal$.MODULE$.maxPrecisionForBytes(field.getTypeLength()), field, typeName);
                var2_5 = var3_18;
            } else {
                throw GeoParquetToSparkSchemaConverter.illegalType$1(originalType, typeName);
            }
        }
        return var2_5;
    }

    private DataType convertGroupField(GroupType field) {
        return (DataType)Option$.MODULE$.apply((Object)field.getOriginalType()).fold((Function0 & Serializable & scala.Serializable)() -> this.convert(field), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            ArrayType arrayType;
            OriginalType originalType = x0$1;
            if (OriginalType.LIST.equals(originalType)) {
                ArrayType arrayType2;
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> field.getFieldCount() == 1, new StringBuilder(18).append("Invalid list type ").append(field).toString());
                Type repeatedType = field.getType(0);
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> repeatedType.isRepetition(Type.Repetition.REPEATED), new StringBuilder(18).append("Invalid list type ").append(field).toString());
                if (this.isElementTypeWithGeo(repeatedType, field.getName())) {
                    arrayType2 = new ArrayType(this.convertFieldWithGeo(repeatedType), false);
                } else {
                    Type elementType = repeatedType.asGroupType().getType(0);
                    boolean optional = elementType.isRepetition(Type.Repetition.OPTIONAL);
                    arrayType2 = new ArrayType(this.convertFieldWithGeo(elementType), optional);
                }
                arrayType = arrayType2;
            } else {
                boolean bl = OriginalType.MAP.equals(originalType) ? true : OriginalType.MAP_KEY_VALUE.equals(originalType);
                if (bl) {
                    ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> field.getFieldCount() == 1 && !field.getType(0).isPrimitive(), new StringBuilder(18).append("Invalid map type: ").append(field).toString());
                    GroupType keyValueType = field.getType(0).asGroupType();
                    ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> keyValueType.isRepetition(Type.Repetition.REPEATED) && keyValueType.getFieldCount() == 2, new StringBuilder(18).append("Invalid map type: ").append(field).toString());
                    Type keyType = keyValueType.getType(0);
                    Type valueType = keyValueType.getType(1);
                    boolean valueOptional = valueType.isRepetition(Type.Repetition.OPTIONAL);
                    arrayType = new MapType(this.convertFieldWithGeo(keyType), this.convertFieldWithGeo(valueType), valueOptional);
                } else {
                    throw new IllegalArgumentException(new StringBuilder(27).append("Unrecognized Parquet type: ").append(field).toString());
                }
            }
            return arrayType;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isElementTypeWithGeo(Type repeatedType, String parentName) {
        if (repeatedType.isPrimitive()) return true;
        if (repeatedType.asGroupType().getFieldCount() > 1) return true;
        String string = repeatedType.getName();
        String string2 = "array";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = repeatedType.getName();
        String string4 = new StringBuilder(6).append(parentName).append("_tuple").toString();
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    private static final String typeString$1(OriginalType originalType$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        return originalType$1 == null ? String.valueOf(typeName$1) : new StringBuilder(3).append(typeName$1).append(" (").append(originalType$1).append(")").toString();
    }

    private static final Nothing$ typeNotSupported$1(OriginalType originalType$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        throw new IllegalArgumentException(new StringBuilder(28).append("Parquet type not supported: ").append(GeoParquetToSparkSchemaConverter.typeString$1(originalType$1, typeName$1)).toString());
    }

    private static final Nothing$ typeNotImplemented$1(OriginalType originalType$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        throw new IllegalArgumentException(new StringBuilder(32).append("Parquet type not yet supported: ").append(GeoParquetToSparkSchemaConverter.typeString$1(originalType$1, typeName$1)).toString());
    }

    private static final Nothing$ illegalType$1(OriginalType originalType$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        throw new IllegalArgumentException(new StringBuilder(22).append("Illegal Parquet type: ").append(GeoParquetToSparkSchemaConverter.typeString$1(originalType$1, typeName$1)).toString());
    }

    private static final DecimalType makeDecimalType$1(int maxPrecision, PrimitiveType field$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        int precision = field$1.getDecimalMetadata().getPrecision();
        int scale = field$1.getDecimalMetadata().getScale();
        ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> maxPrecision == -1 || 1 <= precision && precision <= maxPrecision, new StringBuilder(55).append("Invalid decimal precision: ").append(typeName$1).append(" cannot store ").append(precision).append(" digits (max ").append(maxPrecision).append(")").toString());
        return new DecimalType(precision, scale);
    }

    private static final int makeDecimalType$default$1$1() {
        return -1;
    }

    public static final /* synthetic */ boolean $anonfun$convertPrimitiveField$2(GeoParquetToSparkSchemaConverter $this) {
        return $this.assumeInt96IsTimestamp;
    }

    public GeoParquetToSparkSchemaConverter(Map<String, String> keyValueMetaData, boolean assumeBinaryIsString, boolean assumeInt96IsTimestamp, scala.collection.immutable.Map<String, String> parameters) {
        this.assumeBinaryIsString = assumeBinaryIsString;
        this.assumeInt96IsTimestamp = assumeInt96IsTimestamp;
        this.geoParquetMetaData = GeoParquetUtils$.MODULE$.parseGeoParquetMetaData(keyValueMetaData, parameters);
    }

    public GeoParquetToSparkSchemaConverter(Map<String, String> keyValueMetaData, SQLConf conf, scala.collection.immutable.Map<String, String> parameters) {
        this(keyValueMetaData, conf.isParquetBinaryAsString(), conf.isParquetINT96AsTimestamp(), parameters);
    }

    public GeoParquetToSparkSchemaConverter(Map<String, String> keyValueMetaData, Configuration conf, scala.collection.immutable.Map<String, String> parameters) {
        this(keyValueMetaData, new StringOps(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key()))).toBoolean(), new StringOps(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key()))).toBoolean(), parameters);
    }
}

