/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.schema.ConversionPatterns;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetSchemaConverter$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaConverter$;
import org.apache.spark.sql.execution.datasources.parquet.SparkToGeoParquetSchemaConverter$;
import org.apache.spark.sql.execution.datasources.parquet.SparkToParquetSchemaConverter;
import org.apache.spark.sql.execution.datasources.parquet.SparkToParquetSchemaConverter$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005Ua\u0001\u0002\b\u0010\u0001yA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tU\u0001\u0011\t\u0011)A\u0005W!)!\b\u0001C\u0001w!)!\b\u0001C\u0001\u007f!)!\b\u0001C\u0001\u000b\")a\n\u0001C!\u001f\")q\f\u0001C!A\")q\f\u0001C\u0005S\u001e9AoDA\u0001\u0012\u0003)ha\u0002\b\u0010\u0003\u0003E\tA\u001e\u0005\u0006u)!\tA\u001f\u0005\bw*\t\n\u0011\"\u0001}\u0011%\tyACI\u0001\n\u0003\t\tB\u0001\u0011Ta\u0006\u00148\u000eV8HK>\u0004\u0016M]9vKR\u001c6\r[3nC\u000e{gN^3si\u0016\u0014(B\u0001\t\u0012\u0003\u001d\u0001\u0018M]9vKRT!AE\n\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u0003)U\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005Y9\u0012aA:rY*\u0011\u0001$G\u0001\u0006gB\f'o\u001b\u0006\u00035m\ta!\u00199bG\",'\"\u0001\u000f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001y\u0002C\u0001\u0011\"\u001b\u0005y\u0011B\u0001\u0012\u0010\u0005u\u0019\u0006/\u0019:l)>\u0004\u0016M]9vKR\u001c6\r[3nC\u000e{gN^3si\u0016\u0014\u0018\u0001G<sSR,G*Z4bGf\u0004\u0016M]9vKR4uN]7biB\u0011Q\u0005K\u0007\u0002M)\tq%A\u0003tG\u0006d\u0017-\u0003\u0002*M\t9!i\\8mK\u0006t\u0017aE8viB,H\u000fV5nKN$\u0018-\u001c9UsB,\u0007C\u0001\u00177\u001d\ti3G\u0004\u0002/c5\tqF\u0003\u00021+\u0005A\u0011N\u001c;fe:\fG.\u0003\u00023_\u000591+\u0015'D_:4\u0017B\u0001\u001b6\u0003i\u0001\u0016M]9vKR|U\u000f\u001e9viRKW.Z:uC6\u0004H+\u001f9f\u0015\t\u0011t&\u0003\u00028q\t)a+\u00197vK&\u0011\u0011H\n\u0002\f\u000b:,X.\u001a:bi&|g.\u0001\u0004=S:LGO\u0010\u000b\u0004yur\u0004C\u0001\u0011\u0001\u0011\u001d\u00193\u0001%AA\u0002\u0011BqAK\u0002\u0011\u0002\u0003\u00071\u0006\u0006\u0002=\u0001\")\u0011\t\u0002a\u0001\u0005\u0006!1m\u001c8g!\tq3)\u0003\u0002E_\t91+\u0015'D_:4GC\u0001\u001fG\u0011\u0015\tU\u00011\u0001H!\tAE*D\u0001J\u0015\t\t%J\u0003\u0002L3\u00051\u0001.\u00193p_BL!!T%\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0003\u001d\u0019wN\u001c<feR$\"\u0001U,\u0011\u0005E+V\"\u0001*\u000b\u0005M#\u0016AB:dQ\u0016l\u0017M\u0003\u0002\u00113%\u0011aK\u0015\u0002\f\u001b\u0016\u001c8/Y4f)f\u0004X\rC\u0003Y\r\u0001\u0007\u0011,\u0001\bdCR\fG._:u'\u000eDW-\\1\u0011\u0005ikV\"A.\u000b\u0005q+\u0012!\u0002;za\u0016\u001c\u0018B\u00010\\\u0005)\u0019FO];diRK\b/Z\u0001\rG>tg/\u001a:u\r&,G\u000e\u001a\u000b\u0003C\u0012\u0004\"!\u00152\n\u0005\r\u0014&\u0001\u0002+za\u0016DQ!Z\u0004A\u0002\u0019\fQAZ5fY\u0012\u0004\"AW4\n\u0005!\\&aC*ueV\u001cGOR5fY\u0012$2!\u00196l\u0011\u0015)\u0007\u00021\u0001g\u0011\u0015a\u0007\u00021\u0001n\u0003)\u0011X\r]3uSRLwN\u001c\t\u0003]Ft!!U8\n\u0005A\u0014\u0016\u0001\u0002+za\u0016L!A]:\u0003\u0015I+\u0007/\u001a;ji&|gN\u0003\u0002q%\u0006\u00013\u000b]1sWR{w)Z8QCJ\fX/\u001a;TG\",W.Y\"p]Z,'\u000f^3s!\t\u0001#b\u0005\u0002\u000boB\u0011Q\u0005_\u0005\u0003s\u001a\u0012a!\u00118z%\u00164G#A;\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132+\u0005i(F\u0001\u0013\u007fW\u0005y\b\u0003BA\u0001\u0003\u0017i!!a\u0001\u000b\t\u0005\u0015\u0011qA\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0003'\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u001b\t\u0019AA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012TCAA\nU\tYc\u0010")
public class SparkToGeoParquetSchemaConverter
extends SparkToParquetSchemaConverter {
    private final boolean writeLegacyParquetFormat;
    private final Enumeration.Value outputTimestampType;

    public static Enumeration.Value $lessinit$greater$default$2() {
        return SparkToGeoParquetSchemaConverter$.MODULE$.$lessinit$greater$default$2();
    }

    public static boolean $lessinit$greater$default$1() {
        return SparkToGeoParquetSchemaConverter$.MODULE$.$lessinit$greater$default$1();
    }

    public MessageType convert(StructType catalystSchema) {
        return (MessageType)Types.buildMessage().addFields((Type[])((IterableOnceOps)catalystSchema.map((Function1 & Serializable)field -> this.convertField((StructField)field))).toArray(ClassTag$.MODULE$.apply(Type.class))).named(ParquetSchemaConverter$.MODULE$.SPARK_PARQUET_SCHEMA_NAME());
    }

    public Type convertField(StructField field) {
        return this.convertField(field, field.nullable() ? Type.Repetition.OPTIONAL : Type.Repetition.REQUIRED);
    }

    private Type convertField(StructField field2, Type.Repetition repetition) {
        Option option;
        Option option2;
        Option option3;
        GeoParquetSchemaConverter$.MODULE$.checkFieldName(field2.name());
        boolean bl = false;
        DecimalType decimalType = null;
        boolean bl2 = false;
        ArrayType arrayType = null;
        boolean bl3 = false;
        MapType mapType = null;
        DataType dataType = field2.dataType();
        if (BooleanType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN, (Type.Repetition)repetition).named(field2.name());
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as(OriginalType.INT_8).named(field2.name());
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as(OriginalType.INT_16).named(field2.name());
        }
        if (IntegerType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).named(field2.name());
        }
        if (LongType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).named(field2.name());
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FLOAT, (Type.Repetition)repetition).named(field2.name());
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)repetition).named(field2.name());
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as(OriginalType.UTF8).named(field2.name());
        }
        if (DateType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as(OriginalType.DATE).named(field2.name());
        }
        if (TimestampType$.MODULE$.equals(dataType)) {
            Enumeration.Value value = this.outputTimestampType;
            Enumeration.Value value2 = SQLConf.ParquetOutputTimestampType$.MODULE$.INT96();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT96, (Type.Repetition)repetition).named(field2.name());
            }
            Enumeration.Value value4 = SQLConf.ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MICROS();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as(OriginalType.TIMESTAMP_MICROS).named(field2.name());
            }
            Enumeration.Value value6 = SQLConf.ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MILLIS();
            Enumeration.Value value7 = value;
            if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as(OriginalType.TIMESTAMP_MILLIS).named(field2.name());
            }
            throw new MatchError((Object)value);
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).named(field2.name());
        }
        if (dataType instanceof DecimalType) {
            bl = true;
            decimalType = (DecimalType)dataType;
            Option option4 = DecimalType.Fixed$.MODULE$.unapply(decimalType);
            if (!option4.isEmpty()) {
                int precision = ((Tuple2)option4.get())._1$mcI$sp();
                int scale = ((Tuple2)option4.get())._2$mcI$sp();
                if (this.writeLegacyParquetFormat) {
                    return (Type)((Types.BasePrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, (Type.Repetition)repetition).as(OriginalType.DECIMAL)).precision(precision).scale(scale).length(Decimal$.MODULE$.minBytesForPrecision()[precision]).named(field2.name());
                }
            }
        }
        if (bl && !(option3 = DecimalType.Fixed$.MODULE$.unapply(decimalType)).isEmpty()) {
            int precision = ((Tuple2)option3.get())._1$mcI$sp();
            int scale = ((Tuple2)option3.get())._2$mcI$sp();
            if (precision <= Decimal$.MODULE$.MAX_INT_DIGITS() && !this.writeLegacyParquetFormat) {
                return (Type)((Types.BasePrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as(OriginalType.DECIMAL)).precision(precision).scale(scale).named(field2.name());
            }
        }
        if (bl && !(option2 = DecimalType.Fixed$.MODULE$.unapply(decimalType)).isEmpty()) {
            int precision = ((Tuple2)option2.get())._1$mcI$sp();
            int scale = ((Tuple2)option2.get())._2$mcI$sp();
            if (precision <= Decimal$.MODULE$.MAX_LONG_DIGITS() && !this.writeLegacyParquetFormat) {
                return (Type)((Types.BasePrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as(OriginalType.DECIMAL)).precision(precision).scale(scale).named(field2.name());
            }
        }
        if (bl && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType)).isEmpty()) {
            int precision = ((Tuple2)option.get())._1$mcI$sp();
            int scale = ((Tuple2)option.get())._2$mcI$sp();
            if (!this.writeLegacyParquetFormat) {
                return (Type)((Types.BasePrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, (Type.Repetition)repetition).as(OriginalType.DECIMAL)).precision(precision).scale(scale).length(Decimal$.MODULE$.minBytesForPrecision()[precision]).named(field2.name());
            }
        }
        if (dataType instanceof ArrayType) {
            bl2 = true;
            arrayType = (ArrayType)dataType;
            DataType elementType = arrayType.elementType();
            boolean bl4 = arrayType.containsNull();
            if (bl4 && this.writeLegacyParquetFormat) {
                return (Type)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)repetition).as(OriginalType.LIST)).addField((Type)Types.buildGroup((Type.Repetition)Type.Repetition.REPEATED).addField(this.convertField(new StructField("array", elementType, true, StructField$.MODULE$.apply$default$4()))).named("bag")).named(field2.name());
            }
        }
        if (bl2) {
            DataType elementType = arrayType.elementType();
            boolean bl5 = arrayType.containsNull();
            if (!bl5 && this.writeLegacyParquetFormat) {
                return (Type)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)repetition).as(OriginalType.LIST)).addField(this.convertField(new StructField("array", elementType, false, StructField$.MODULE$.apply$default$4()), Type.Repetition.REPEATED)).named(field2.name());
            }
        }
        if (dataType instanceof MapType) {
            bl3 = true;
            mapType = (MapType)dataType;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            boolean valueContainsNull = mapType.valueContainsNull();
            if (this.writeLegacyParquetFormat) {
                return ConversionPatterns.mapType((Type.Repetition)repetition, (String)field2.name(), (Type)this.convertField(new StructField("key", keyType, false, StructField$.MODULE$.apply$default$4())), (Type)this.convertField(new StructField("value", valueType, valueContainsNull, StructField$.MODULE$.apply$default$4())));
            }
        }
        if (bl2) {
            DataType elementType = arrayType.elementType();
            boolean containsNull = arrayType.containsNull();
            if (!this.writeLegacyParquetFormat) {
                return (Type)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)repetition).as(OriginalType.LIST)).addField((Type)Types.repeatedGroup().addField(this.convertField(new StructField("element", elementType, containsNull, StructField$.MODULE$.apply$default$4()))).named("list")).named(field2.name());
            }
        }
        if (bl3) {
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            boolean valueContainsNull = mapType.valueContainsNull();
            return (Type)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)repetition).as(OriginalType.MAP)).addField((Type)Types.repeatedGroup().addField(this.convertField(new StructField("key", keyType, false, StructField$.MODULE$.apply$default$4()))).addField(this.convertField(new StructField("value", valueType, valueContainsNull, StructField$.MODULE$.apply$default$4()))).named("key_value")).named(field2.name());
        }
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            return (Type)((Types.Builder)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Object)Types.buildGroup((Type.Repetition)repetition), (Function2 & Serializable)(builder, field) -> (Types.GroupBuilder)builder.addField(this.convertField((StructField)field)))).named(field2.name());
        }
        if (dataType instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType;
            DataType x$1 = userDefinedType.sqlType();
            String x$2 = field2.copy$default$1();
            boolean x$3 = field2.copy$default$3();
            Metadata x$4 = field2.copy$default$4();
            return this.convertField(field2.copy(x$2, x$1, x$3, x$4));
        }
        throw new IllegalArgumentException(new StringBuilder(22).append("Unsupported data type ").append(field2.dataType().catalogString()).toString());
    }

    public SparkToGeoParquetSchemaConverter(boolean writeLegacyParquetFormat, Enumeration.Value outputTimestampType) {
        this.writeLegacyParquetFormat = writeLegacyParquetFormat;
        this.outputTimestampType = outputTimestampType;
        super(writeLegacyParquetFormat, outputTimestampType, SparkToParquetSchemaConverter$.MODULE$.$lessinit$greater$default$3());
    }

    public SparkToGeoParquetSchemaConverter(SQLConf conf) {
        this(conf.writeLegacyParquetFormat(), conf.parquetOutputTimestampType());
    }

    public SparkToGeoParquetSchemaConverter(Configuration conf) {
        this(StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key()))), SQLConf.ParquetOutputTimestampType$.MODULE$.withName(conf.get(SQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key())));
    }
}

