/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.simplify;

import org.apache.sedona.common.geometryObjects.Circle;
import org.apache.sedona.common.simplify.CircleSimplifier;
import org.apache.sedona.common.simplify.GeometryCollectionSimplifier;
import org.apache.sedona.common.simplify.LineStringSimplifier;
import org.apache.sedona.common.simplify.PolygonSimplifier;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;

public class GeometrySimplifier {
    public static Geometry simplify(Geometry geom, boolean preserveCollapsed, double epsilon) {
        if (geom instanceof Circle) {
            return CircleSimplifier.simplify((Circle)geom, preserveCollapsed, epsilon);
        }
        if (geom instanceof GeometryCollection) {
            return GeometryCollectionSimplifier.simplify((GeometryCollection)geom, preserveCollapsed, epsilon);
        }
        if (geom instanceof LineString) {
            return LineStringSimplifier.simplify(geom, preserveCollapsed, epsilon);
        }
        if (geom instanceof Polygon) {
            return PolygonSimplifier.simplify((Polygon)geom, preserveCollapsed, epsilon);
        }
        return geom;
    }
}

