/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Optional;
import ucar.httpservices.HTTPException;
import ucar.httpservices.HTTPFactory;
import ucar.httpservices.HTTPMethod;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.io.spi.RandomAccessFileProvider;

public class InMemoryRandomAccessFile
extends RandomAccessFile {
    public InMemoryRandomAccessFile(String name, byte[] data) {
        super(1);
        this.location = name;
        this.file = null;
        if (data == null) {
            throw new IllegalArgumentException("data array is null");
        }
        this.buffer = data;
        this.bufferStart = 0L;
        this.dataSize = this.buffer.length;
        this.dataEnd = this.buffer.length;
        this.filePosition = 0L;
        this.endOfFile = false;
        if (debugLeaks) {
            openFiles.add(this.location);
        }
    }

    @Override
    public long length() {
        return this.dataEnd;
    }

    @Override
    public void setBufferSize(int bufferSize) {
    }

    @Override
    protected int read_(long pos, byte[] b, int offset, int len) {
        len = Math.min(len, (int)((long)this.buffer.length - pos));
        System.arraycopy(this.buffer, (int)pos, b, offset, len);
        return len;
    }

    @Override
    public long readToByteChannel(WritableByteChannel dest, long offset, long nbytes) throws IOException {
        return dest.write(ByteBuffer.wrap(this.buffer, (int)offset, (int)nbytes));
    }

    public static class Provider
    implements RandomAccessFileProvider {
        @Override
        public boolean isOwnerOf(String location) {
            return location.startsWith("slurp:");
        }

        @Override
        public RandomAccessFile open(String location) throws IOException {
            Optional<byte[]> contents;
            String scheme = location.split(":")[0];
            location = location.replace(scheme, "http");
            try (HTTPMethod method = HTTPFactory.Get(location);){
                method.execute();
                contents = Optional.of(method.getResponseAsBytes());
            }
            catch (HTTPException he) {
                throw new IOException(he);
            }
            return new InMemoryRandomAccessFile(location, contents.get());
        }
    }
}

